/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.TextEditor;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlAnnotationHover;

public class PerlTextHover
implements ITextHover {
    private static int MAX_INFO_LENGTH = 80;
    private TextEditor fTextEditor;

    public PerlTextHover(TextEditor editor) {
        this.fTextEditor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String text = this.getTextForHover(textViewer, hoverRegion);
        if (text == null) {
            if (hoverRegion.getLength() == 0 && "true".equals(System.getProperty("org.epic.perleditor.hoverPartitionType"))) {
                return this.getPartitionHover(textViewer, hoverRegion);
            }
            return null;
        }
        try {
            ResourceBundle rb = ResourceBundle.getBundle("org.epic.perleditor.editors.quickreference");
            if (text.length() > 0 && text.indexOf(" ") < 0 && text.indexOf("\t") < 0) {
                try {
                    String value = rb.getString(text);
                    return this.splitMessage(value);
                }
                catch (MissingResourceException missingResourceException) {
                    return null;
                }
            }
            try {
                PerlAnnotationHover markerAnnotation = new PerlAnnotationHover(this.fTextEditor);
                int line = textViewer.getDocument().getLineOfOffset(hoverRegion.getOffset());
                return markerAnnotation.getHoverInfo((ISourceViewer)textViewer, line);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }

    private String getPartitionHover(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            IDocument doc = textViewer.getDocument();
            ITypedRegion partition = PartitionTypes.getPerlPartition(doc, hoverRegion.getOffset());
            return "@" + hoverRegion.getOffset() + ": " + partition.getOffset() + ":" + partition.getLength() + ":" + partition.getType() + " {" + doc.get(partition.getOffset(), partition.getLength()) + "}";
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getTextForHover(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion == null || hoverRegion.getLength() <= 0) {
            return null;
        }
        try {
            return textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String splitMessage(String message) {
        String result = "";
        if (message.length() <= MAX_INFO_LENGTH) {
            return message;
        }
        int crIndex = message.indexOf("\n");
        String tmpStr = crIndex != -1 ? message.substring(0, crIndex) : new String(message);
        while (tmpStr.length() > MAX_INFO_LENGTH) {
            int spacepos = tmpStr.indexOf(" ", MAX_INFO_LENGTH);
            if (spacepos != -1) {
                result = String.valueOf(result) + tmpStr.substring(0, spacepos) + "\n";
                tmpStr = tmpStr.substring(spacepos);
                continue;
            }
            result = String.valueOf(result) + tmpStr.substring(0, MAX_INFO_LENGTH) + "\n";
            tmpStr = tmpStr.substring(MAX_INFO_LENGTH);
        }
        result = String.valueOf(result) + tmpStr;
        if (crIndex != -1) {
            result = String.valueOf(result) + message.substring(crIndex);
        }
        return result;
    }
}

