/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class DoubleBinding
extends TupleBinding {
    private static final int DOUBLE_SIZE = 8;

    public Object entryToObject(TupleInput tupleInput) {
        return new Double(tupleInput.readDouble());
    }

    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeDouble(((Number)object).doubleValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return DoubleBinding.sizedOutput();
    }

    public static double entryToDouble(DatabaseEntry databaseEntry) {
        return DoubleBinding.entryToInput(databaseEntry).readDouble();
    }

    public static void doubleToEntry(double d, DatabaseEntry databaseEntry) {
        DoubleBinding.outputToEntry(DoubleBinding.sizedOutput().writeDouble(d), databaseEntry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

