/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;

public class RecordNumberBinding
implements EntryBinding {
    public Object entryToObject(DatabaseEntry databaseEntry) {
        return new Long(RecordNumberBinding.entryToRecordNumber(databaseEntry));
    }

    public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
        RecordNumberBinding.recordNumberToEntry(((Number)object).longValue(), databaseEntry);
    }

    public static long entryToRecordNumber(DatabaseEntry databaseEntry) {
        return (long)DbCompat.getRecordNumber(databaseEntry) & 0xFFFFFFFFL;
    }

    public static void recordNumberToEntry(long l, DatabaseEntry databaseEntry) {
        databaseEntry.setData(new byte[4], 0, 4);
        DbCompat.setRecordNumber(databaseEntry, (int)l);
    }
}

