/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.validator;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.EmailValidator;
import org.pentaho.di.job.entry.validator.FileDoesNotExistValidator;
import org.pentaho.di.job.entry.validator.FileExistsValidator;
import org.pentaho.di.job.entry.validator.IntegerValidator;
import org.pentaho.di.job.entry.validator.LongValidator;
import org.pentaho.di.job.entry.validator.NotBlankValidator;
import org.pentaho.di.job.entry.validator.NotNullValidator;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.job.entry.validator.ValidatorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryValidatorUtils {
    public static final int LEVEL_FAILURE_DEFAULT = 4;

    public static AndValidator andValidator() {
        return AndValidator.INSTANCE;
    }

    public static NotBlankValidator notBlankValidator() {
        return NotBlankValidator.INSTANCE;
    }

    public static NotNullValidator notNullValidator() {
        return NotNullValidator.INSTANCE;
    }

    public static FileExistsValidator fileExistsValidator() {
        return FileExistsValidator.INSTANCE;
    }

    public static IntegerValidator integerValidator() {
        return IntegerValidator.INSTANCE;
    }

    public static LongValidator longValidator() {
        return LongValidator.INSTANCE;
    }

    public static FileDoesNotExistValidator fileDoesNotExistValidator() {
        return FileDoesNotExistValidator.INSTANCE;
    }

    public static EmailValidator emailValidator() {
        return EmailValidator.INSTANCE;
    }

    public static int getLevelOnFail(ValidatorContext context, String validatorName) {
        String key = JobEntryValidatorUtils.getKeyLevelOnFail(validatorName);
        if (context.containsKey(key)) {
            return (Integer)context.get(key);
        }
        if (context.containsKey("levelOnFail")) {
            return (Integer)context.get("levelOnFail");
        }
        return 4;
    }

    public static void putLevelOnFail(Map<String, Object> map, String validatorName, int levelOnFail) {
        String key = JobEntryValidatorUtils.getKeyLevelOnFail(validatorName);
        map.put(key, levelOnFail);
    }

    public static void putLevelOnFail(Map<String, Object> map, int levelOnFail) {
        map.put("levelOnFail", levelOnFail);
    }

    public static String getKeyLevelOnFail(String validatorName) {
        return validatorName + "-" + "levelOnFail";
    }

    public static boolean validateMask(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, String mask, int levelOnFail) {
        return JobEntryValidatorUtils.validateMask(source, propertyName, remarks, mask, 4);
    }

    public static boolean validateMask(CheckResultSourceInterface source, String propertyName, int levelOnFail, List<CheckResultInterface> remarks, String mask) {
        String VALIDATOR_NAME = "matches";
        String value = null;
        value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        try {
            if (null == mask) {
                JobEntryValidatorUtils.addGeneralRemark(source, propertyName, "matches", remarks, "errors.missingVar", 4);
                return false;
            }
            if (StringUtils.isNotBlank((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                JobEntryValidatorUtils.addFailureRemark(source, propertyName, "matches", remarks, levelOnFail);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, "matches", remarks, e);
            return false;
        }
    }

    public static void addFailureRemark(CheckResultSourceInterface source, String propertyName, String validatorName, List<CheckResultInterface> remarks, int level) {
        String key = "messages.failed." + validatorName;
        remarks.add((CheckResultInterface)new CheckResult(level, ValidatorMessages.getString(key, propertyName), source));
    }

    public static void addExceptionRemark(CheckResultSourceInterface source, String propertyName, String validatorName, List<CheckResultInterface> remarks, Exception e) {
        String key = "messages.failed.unableToValidate";
        remarks.add((CheckResultInterface)new CheckResult(4, ValidatorMessages.getString(key, propertyName, e.getClass().getSimpleName() + ": " + e.getLocalizedMessage()), source));
    }

    public static void addGeneralRemark(CheckResultSourceInterface source, String propertyName, String validatorName, List<CheckResultInterface> remarks, String key, int level) {
        remarks.add((CheckResultInterface)new CheckResult(4, ValidatorMessages.getString(key, new Object[0]), source));
    }

    public static void addOkRemark(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks) {
        int SUBSTRING_LENGTH = 20;
        LogWriter log = LogWriter.getInstance();
        log.logBasic(JobEntryValidatorUtils.class.getSimpleName(), "attempting to fetch property named '" + propertyName + "'", new Object[0]);
        String value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        log.logBasic(JobEntryValidatorUtils.class.getSimpleName(), "fetched value [" + value + "]", new Object[0]);
        String substr = null;
        if (value != null) {
            substr = value.substring(0, Math.min(20, value.length()));
            if (value.length() > 20) {
                substr = substr + "...";
            }
        }
        remarks.add((CheckResultInterface)new CheckResult(1, ValidatorMessages.getString("messages.passed", propertyName, substr), source));
    }
}

