/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Collections;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.AggregateRouteNode;
import org.apache.camel.impl.DefaultRouteNode;
import org.apache.camel.impl.DoCatchRouteNode;
import org.apache.camel.impl.DoFinallyRouteNode;
import org.apache.camel.impl.OnCompletionRouteNode;
import org.apache.camel.impl.OnExceptionRouteNode;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceInterceptor
extends DelegateAsyncProcessor
implements ExchangeFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(TraceInterceptor.class);
    private CamelLogProcessor logger;
    private final ProcessorDefinition<?> node;
    private final Tracer tracer;
    private TraceFormatter formatter;
    private RouteContext routeContext;
    private List<TraceEventHandler> traceHandlers;

    public TraceInterceptor(ProcessorDefinition<?> node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogger(this);
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
        this.traceHandlers = tracer.getTraceHandlers();
    }

    @Override
    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (!this.tracer.isEnabled() || this.routeContext != null && !this.routeContext.isTracing().booleanValue()) {
            return this.processor.process(exchange, callback);
        }
        if (exchange.getProperty("CamelTraceEvent", false, Boolean.class).booleanValue()) {
            return this.processor.process(exchange, callback);
        }
        final boolean shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
        boolean trace = true;
        boolean sync = true;
        try {
            if (shouldLog) {
                if (exchange.getUnitOfWork() != null) {
                    TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
                    if (this.node instanceof OnCompletionDefinition || this.node instanceof OnExceptionDefinition) {
                        trace = false;
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnCompletionDefinition.class, this.node)) {
                        this.traceOnCompletion(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnExceptionDefinition.class, this.node)) {
                        this.traceOnException(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(CatchDefinition.class, this.node)) {
                        this.traceDoCatch(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(FinallyDefinition.class, this.node)) {
                        this.traceDoFinally(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(AggregateDefinition.class, this.node)) {
                        this.traceAggregate(traced, exchange);
                    } else {
                        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
                    }
                } else {
                    LOG.trace("Cannot trace as this Exchange does not have an UnitOfWork: {}", (Object)exchange);
                }
            }
            Object state = null;
            if (shouldLog && trace) {
                this.logExchange(exchange);
                if (this.tracer.isTraceOutExchanges()) {
                    state = this.traceExchangeIn(exchange);
                } else {
                    this.traceExchange(exchange);
                }
            }
            final Object traceState = state;
            if (this.node.getParent() instanceof InterceptDefinition && exchange.getUnitOfWork() != null) {
                TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
                this.traceIntercept((InterceptDefinition)this.node.getParent(), traced, exchange);
            }
            sync = this.processor.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean doneSync) {
                    try {
                        if (shouldLog && TraceInterceptor.this.tracer.isTraceOutExchanges()) {
                            TraceInterceptor.this.logExchange(exchange);
                            TraceInterceptor.this.traceExchangeOut(exchange, traceState);
                        }
                    }
                    catch (Throwable e) {
                        if (TraceInterceptor.this.shouldLogException(exchange)) {
                            TraceInterceptor.this.logException(exchange, e);
                        }
                        exchange.setException(e);
                    }
                    finally {
                        callback.done(doneSync);
                    }
                }
            });
        }
        catch (Throwable e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            exchange.setException(e);
        }
        return sync;
    }

    private void traceOnCompletion(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new OnCompletionRouteNode());
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceOnException(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new OnExceptionRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoCatch(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new DoCatchRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoFinally(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new DoFinallyRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceAggregate(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new AggregateRouteNode((AggregateDefinition)this.node.getParent()));
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    protected void traceIntercept(InterceptDefinition intercept, TracedRouteNodes traced, Exchange exchange) throws Exception {
        Processor last = intercept.getInterceptedProcessor(traced.getAndIncrementCounter(intercept));
        if (last != null && !(last instanceof TraceInterceptor)) {
            boolean shouldLog;
            traced.addTraced(new DefaultRouteNode(this.node, last));
            boolean bl = shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
            if (shouldLog) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
    }

    @Override
    public String format(Exchange exchange) {
        Object msg = this.formatter.format(this, this.getNode(), exchange);
        if (msg != null) {
            return msg.toString();
        }
        return null;
    }

    public ProcessorDefinition<?> getNode() {
        return this.node;
    }

    public CamelLogProcessor getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    protected void logExchange(Exchange exchange) throws Exception {
        this.logger.process(exchange);
    }

    protected void traceExchange(Exchange exchange) throws Exception {
        for (TraceEventHandler traceHandler : this.traceHandlers) {
            traceHandler.traceExchange(this.node, this.processor, this, exchange);
        }
    }

    protected Object traceExchangeIn(Exchange exchange) throws Exception {
        Object result = null;
        for (TraceEventHandler traceHandler : this.traceHandlers) {
            Object result1 = traceHandler.traceExchangeIn(this.node, this.processor, this, exchange);
            if (result1 == null) continue;
            result = result1;
        }
        return result;
    }

    protected void traceExchangeOut(Exchange exchange, Object traceState) throws Exception {
        for (TraceEventHandler traceHandler : this.traceHandlers) {
            traceHandler.traceExchangeOut(this.node, this.processor, this, exchange, traceState);
        }
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            if (this.tracer.isLogStackTrace()) {
                this.logger.process(exchange, throwable);
            } else {
                this.logger.process(exchange, ", Exception: " + throwable.toString());
            }
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.tracer.isEnabled() && (this.tracer.getTraceFilter() == null || this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    public boolean shouldTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    protected boolean shouldLogNode(ProcessorDefinition<?> node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.traceHandlers);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.traceHandlers);
    }

    @Deprecated
    public void setTraceHandler(TraceEventHandler traceHandler) {
        this.traceHandlers = Collections.singletonList(traceHandler);
    }
}

