/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.impl.QNameReflectionParams;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNameHelper {
    private static final Log log = LogFactory.getLog(QNameHelper.class);
    private static final Method addPropertyValueMethod;

    public static QName createQName(Element element, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            return new QName(uri, localName, prefix);
        }
        String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns");
        if (uri != null) {
            return new QName(uri, qualifiedName);
        }
        return new QName(qualifiedName);
    }

    public static String recursiveGetAttributeValue(Element element, String attributeName) {
        Node parentNode;
        String answer;
        block3: {
            answer = null;
            try {
                answer = element.getAttribute(attributeName);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Caught exception looking up attribute: " + attributeName + " on element: " + element + ". Cause: " + e, e);
            }
        }
        if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
            return QNameHelper.recursiveGetAttributeValue((Element)parentNode, attributeName);
        }
        return answer;
    }

    public static void coerceQNamePropertyValues(QNameReflectionParams params) {
        QNameHelper.coerceNamespaceAwarePropertyValues(params.getBeanDefinition(), params.getElement(), params.getDescriptors(), params.getIndex());
    }

    public static void coerceNamespaceAwarePropertyValues(AbstractBeanDefinition bd, Element element, PropertyDescriptor[] descriptors, int i) {
        PropertyDescriptor descriptor = descriptors[i];
        if (descriptor.getPropertyType() == null) {
            return;
        }
        if (descriptor.getPropertyType().isAssignableFrom(QName.class)) {
            String name = descriptor.getName();
            MutablePropertyValues propertyValues = bd.getPropertyValues();
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            if (propertyValue != null) {
                Object value = propertyValue.getValue();
                if (value instanceof String) {
                    propertyValues.removePropertyValue(propertyValue);
                    QNameHelper.addPropertyValue(propertyValues, name, QNameHelper.createQName(element, (String)value));
                } else if (value instanceof TypedStringValue) {
                    propertyValues.removePropertyValue(propertyValue);
                    QNameHelper.addPropertyValue(propertyValues, name, QNameHelper.createQName(element, ((TypedStringValue)value).getValue()));
                }
            }
        } else if (descriptor.getPropertyType().isAssignableFrom(QName[].class)) {
            Object value;
            String name = descriptor.getName();
            MutablePropertyValues propertyValues = bd.getPropertyValues();
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            if (propertyValue != null && (value = propertyValue.getValue()) instanceof List) {
                List values = (List)value;
                ManagedList<QName> newValues = new ManagedList<QName>();
                for (Object v : values) {
                    if (v instanceof String) {
                        newValues.add(QNameHelper.createQName(element, (String)v));
                        continue;
                    }
                    newValues.add((QName)v);
                }
                propertyValues.removePropertyValue(propertyValue);
                propertyValues.addPropertyValue(name, newValues);
            }
        }
    }

    public static void addPropertyValue(MutablePropertyValues values, String name, Object value) {
        try {
            addPropertyValueMethod.invoke((Object)values, name, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding property definition", e);
        }
    }

    static {
        try {
            addPropertyValueMethod = MutablePropertyValues.class.getMethod("addPropertyValue", String.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find MutablePropertyValues:addPropertyValue", e);
        }
    }
}

