/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_SESSION_H
#define _TRANSLATE_SESSION_H

#include <glib-object.h>
#include <translate-common.h>

G_BEGIN_DECLS

#define TRANSLATE_TYPE_SESSION			(translate_session_get_type())
#define TRANSLATE_SESSION(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TRANSLATE_TYPE_SESSION, TranslateSession))
#define TRANSLATE_SESSION_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TRANSLATE_TYPE_SESSION, TranslateSessionClass))
#define TRANSLATE_IS_SESSION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TRANSLATE_TYPE_SESSION))
#define TRANSLATE_IS_SESSION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TRANSLATE_TYPE_SESSION))
#define TRANSLATE_SESSION_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TRANSLATE_TYPE_SESSION, TranslateSessionClass))

#define TRANSLATE_SESSION_ERROR			(translate_session_error_quark())

typedef struct _TranslateSession		TranslateSession;
typedef struct _TranslateSessionClass		TranslateSessionClass;
typedef struct _TranslateSessionPrivate		TranslateSessionPrivate;

struct _TranslateSession
{
  GObject			parent;

  TranslateSessionPrivate	*priv;
};

struct _TranslateSessionClass
{
  GObjectClass			parent;

  void (*reserved1) (void);
  void (*reserved2) (void);
  void (*reserved3) (void);
  void (*reserved4) (void);
  void (*reserved5) (void);
  void (*reserved6) (void);
  void (*reserved7) (void);
  void (*reserved8) (void);
};

typedef enum
{
  TRANSLATE_SESSION_ERROR_NO_SERVICE
} TranslateSessionError;

GType		  translate_session_get_type		(void);
GQuark		  translate_session_error_quark		(void);

TranslateSession *translate_session_new			(const GSList		 *services);

void		  translate_session_set_services	(TranslateSession	 *session,
							 const GSList		 *services);
void		  translate_session_set_max_threads	(TranslateSession	 *session,
							 unsigned int		  max_threads);
void		  translate_session_set_max_retries	(TranslateSession	 *session,
							 unsigned int		  max_retries);

GSList		 *translate_session_get_services	(TranslateSession	 *session);
GSList		 *translate_session_get_pairs		(TranslateSession	 *session);
unsigned int	  translate_session_get_max_threads	(TranslateSession	 *session);
int		  translate_session_get_max_retries	(TranslateSession	 *session);

char		 *translate_session_translate_text	(TranslateSession	 *session,
							 const char		 *text,
							 const char		 *from,
							 const char		 *to,
							 TranslateProgressFunc	  progress_func,
							 gpointer		  user_data,
							 GError			**err);
char		 *translate_session_translate_web_page	(TranslateSession	 *session,
							 const char		 *url,
							 const char		 *from,
							 const char		 *to,
							 TranslateProgressFunc	  progress_func,
							 gpointer		  user_data,
							 GError			**err);

G_END_DECLS

#endif /* _TRANSLATE_SESSION_H */
