/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.owasp.jbrofuzz.version.ImageCreator;

final class HashPanelRightClick {
    HashPanelRightClick() {
    }

    protected static final void popupText(final JTextComponent area) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenuItem i1_cut = new JMenuItem("Cut");
        JMenuItem i2_copy = new JMenuItem("Copy");
        JMenuItem i3_paste = new JMenuItem("Paste");
        JMenuItem i4_select = new JMenuItem("Select All");
        i1_cut.setIcon(ImageCreator.IMG_CUT);
        i2_copy.setIcon(ImageCreator.IMG_COPY);
        i3_paste.setIcon(ImageCreator.IMG_PASTE);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        i1_cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        i2_copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        i3_paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        i4_select.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.addSeparator();
        popmenu.add(i4_select);
        i1_cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.cut();
            }
        });
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.copy();
            }
        });
        i3_paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (area.isEditable()) {
                    area.paste();
                }
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }
}

