/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.renderer;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;

public class TimeDurationStringValue
implements StringValue {
    private static final long serialVersionUID = -2071582450216282057L;
    private static final MessageFormat TIME_DURATION_WITH_UNIT_FORMAT = new MessageFormat(Constant.messages.getString("generic.value.time.duration.value.unit"));
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Constant.getLocale());
    private static final String UNIT_MILLISECONDS;
    private static final String UNIT_SECONDS;
    private static final String UNIT_MINUTES;
    private static final String UNIT_HOURS;
    private static final int ONE_SECOND_IN_MS = 1000;
    private static final int ONE_MINUTE_IN_MS = 60000;
    private static final int ONE_HOUR_IN_MS = 3600000;

    public String getString(Object object) {
        if (object instanceof Number) {
            String string;
            double d = ((Number)object).doubleValue();
            if (d < 1000.0) {
                string = UNIT_MILLISECONDS;
            } else if (d < 60000.0) {
                d /= 1000.0;
                string = UNIT_SECONDS;
            } else if (d < 3600000.0) {
                d /= 60000.0;
                string = UNIT_MINUTES;
            } else {
                d /= 3600000.0;
                string = UNIT_HOURS;
            }
            return TIME_DURATION_WITH_UNIT_FORMAT.format(new Object[]{NUMBER_FORMAT.format(d), string});
        }
        return StringValues.TO_STRING.getString(object);
    }

    public static boolean isTargetClass(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(2);
        UNIT_MILLISECONDS = Constant.messages.getString("generic.value.time.duration.unit.milliseconds");
        UNIT_SECONDS = Constant.messages.getString("generic.value.time.duration.unit.seconds");
        UNIT_MINUTES = Constant.messages.getString("generic.value.time.duration.unit.minutes");
        UNIT_HOURS = Constant.messages.getString("generic.value.time.duration.unit.hours");
    }
}

