/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.search.HttpSearcher;
import org.zaproxy.zap.extension.search.OptionsSearchPanel;
import org.zaproxy.zap.extension.search.SearchAPI;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchPanel;
import org.zaproxy.zap.extension.search.SearchParam;
import org.zaproxy.zap.extension.search.SearchThread;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionSearch
extends ExtensionAdaptor
implements SessionChangedListener {
    private static final Logger LOGGER = Logger.getLogger(ExtensionSearch.class);
    public static final String NAME = "ExtensionSearch2";
    private static final Logger logger = Logger.getLogger(ExtensionSearch.class);
    private SearchParam searchParam;
    private OptionsSearchPanel optionsPanel;
    private SearchPanel searchPanel = null;
    private ZapMenuItem menuSearch = null;
    private ZapMenuItem menuNext = null;
    private ZapMenuItem menuPrev = null;
    private SearchThread searchThread = null;
    private boolean searchJustInScope = false;
    private Map<String, HttpSearcher> customSearchers = new HashMap<String, HttpSearcher>();

    public ExtensionSearch() {
        this.initialize();
    }

    public ExtensionSearch(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(20);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsParamSet(this.getSearchParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookView().addStatusPanel(this.getSearchPanel());
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuSearch());
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuNext());
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuPrev());
            ExtensionHelp.enableHelpKey(this.getSearchPanel(), "ui.tabs.search");
        }
        API.getInstance().registerApiImplementor(new SearchAPI(this));
    }

    SearchParam getSearchParam() {
        if (this.searchParam == null) {
            this.searchParam = new SearchParam();
        }
        return this.searchParam;
    }

    private OptionsSearchPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new OptionsSearchPanel();
        }
        return this.optionsPanel;
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this.getView());
            this.searchPanel.setExtension(this);
        }
        return this.searchPanel;
    }

    public void addCustomHttpSearcher(HttpSearcher httpSearcher) {
        if (httpSearcher == null) {
            return;
        }
        final String string = httpSearcher.getName();
        if (this.customSearchers.containsKey(string)) {
            LOGGER.warn((Object)("Attempting to add an HTTP searcher with the same name: " + string));
            return;
        }
        this.customSearchers.put(string, httpSearcher);
        if (this.getView() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionSearch.this.searchPanel.addCustomSearcher(string);
                }
            });
        }
    }

    public void removeCustomHttpSearcher(HttpSearcher httpSearcher) {
        final String string = httpSearcher.getName();
        if (this.customSearchers.remove(string) != null && this.getView() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionSearch.this.searchPanel.removeCustomSearcher(string);
                }
            });
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionSearch.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        this.getSearchPanel().resetSearchResults();
    }

    public void search(String string, Type type) {
        this.search(string, type, false, false);
    }

    public void search(String string, Type type, boolean bl, boolean bl2) {
        this.search(string, type, null, bl, bl2);
    }

    public void search(String string, Type type, String string2, boolean bl, boolean bl2) {
        this.searchPanel.resetSearchResults();
        this.search(string, this.searchPanel, type, string2, bl, bl2, null, -1, -1, true, this.getSearchParam().getMaximumSearchResultsGUI());
    }

    public void search(String string, SearchListenner searchListenner, Type type, boolean bl, boolean bl2) {
        this.search(string, searchListenner, type, bl, bl2, null, -1, -1);
    }

    public void search(String string, SearchListenner searchListenner, Type type, boolean bl, boolean bl2, String string2, int n, int n2) {
        this.search(string, searchListenner, type, bl, bl2, string2, n, n2, true);
    }

    public void search(String string, SearchListenner searchListenner, Type type, boolean bl, boolean bl2, String string2, int n, int n2, boolean bl3) {
        this.search(string, searchListenner, type, bl, bl2, string2, n, n2, bl3, -1);
    }

    public void search(String string, SearchListenner searchListenner, Type type, boolean bl, boolean bl2, String string2, int n, int n2, boolean bl3, int n3) {
        this.search(string, searchListenner, type, null, bl, bl2, string2, n, n2, bl3, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String string, SearchListenner searchListenner, Type type, String string2, boolean bl, boolean bl2, String string3, int n, int n2, boolean bl3, int n3) {
        if (bl) {
            this.getSearchPanel().searchFocus();
            this.getSearchPanel().getRegExField().setText(string);
            this.getSearchPanel().setSearchType(type);
        }
        ExtensionSearch extensionSearch = this;
        synchronized (extensionSearch) {
            if (this.searchThread != null && this.searchThread.isAlive()) {
                this.searchThread.stopSearch();
                while (this.searchThread.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.searchThread = new SearchThread(string, type, string2, searchListenner, bl2, this.searchJustInScope, string3, n, n2, bl3, n3);
            this.searchThread.setCustomSearchers(this.customSearchers);
            this.searchThread.start();
        }
    }

    private ZapMenuItem getMenuSearch() {
        if (this.menuSearch == null) {
            this.menuSearch = new ZapMenuItem("menu.edit.search", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionSearch.this.searchPanel.searchFocus();
                }
            });
        }
        return this.menuSearch;
    }

    private ZapMenuItem getMenuNext() {
        if (this.menuNext == null) {
            this.menuNext = new ZapMenuItem("menu.edit.next", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionSearch.this.searchPanel.highlightNextResult();
                }
            });
        }
        return this.menuNext;
    }

    private ZapMenuItem getMenuPrev() {
        if (this.menuPrev == null) {
            this.menuPrev = new ZapMenuItem("menu.edit.previous");
            this.menuPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionSearch.this.searchPanel.highlightPrevResult();
                }
            });
        }
        return this.menuPrev;
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("search.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void setSearchJustInScope(boolean bl) {
        this.searchJustInScope = bl;
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    public static enum Type {
        All,
        URL,
        Request,
        Response,
        Header,
        Custom;

    }
}

