/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httpsessions.DialogAddToken;
import org.zaproxy.zap.extension.httpsessions.DialogModifyToken;
import org.zaproxy.zap.extension.httpsessions.HttpSessionToken;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsParam;
import org.zaproxy.zap.extension.httpsessions.OptionsHttpSessionsTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;

public class OptionsHttpSessionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox proxyOnlyCheckbox = null;
    private HttpSessionTokensMultipleOptionsPanel tokensOptionsPanel;
    private OptionsHttpSessionsTableModel defaultTokensModel = null;

    public OptionsHttpSessionsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("httpsessions.options.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel();
        jLabel.setText(Constant.messages.getString("httpsessions.options.label.tokens"));
        this.add((Component)jLabel, gridBagConstraints);
        this.tokensOptionsPanel = new HttpSessionTokensMultipleOptionsPanel(this.getDefaultTokensModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tokensOptionsPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        this.add((Component)this.getChkProxyOnly(), gridBagConstraints);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        HttpSessionsParam httpSessionsParam = optionsParam.getParamSet(HttpSessionsParam.class);
        this.getDefaultTokensModel().setTokens(httpSessionsParam.getDefaultTokens());
        this.getChkProxyOnly().setSelected(httpSessionsParam.isEnabledProxyOnly());
        this.tokensOptionsPanel.setRemoveWithoutConfirmation(!httpSessionsParam.isConfirmRemoveDefaultToken());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        HttpSessionsParam httpSessionsParam = optionsParam.getParamSet(HttpSessionsParam.class);
        httpSessionsParam.setDefaultTokens(this.getDefaultTokensModel().getTokens());
        httpSessionsParam.setEnabledProxyOnly(this.getChkProxyOnly().isSelected());
        httpSessionsParam.setConfirmRemoveDefaultToken(!this.tokensOptionsPanel.isRemoveWithoutConfirmation());
    }

    private OptionsHttpSessionsTableModel getDefaultTokensModel() {
        if (this.defaultTokensModel == null) {
            this.defaultTokensModel = new OptionsHttpSessionsTableModel();
        }
        return this.defaultTokensModel;
    }

    private JCheckBox getChkProxyOnly() {
        if (this.proxyOnlyCheckbox == null) {
            this.proxyOnlyCheckbox = new JCheckBox();
            this.proxyOnlyCheckbox.setText(Constant.messages.getString("httpsessions.options.label.proxyOnly"));
        }
        return this.proxyOnlyCheckbox;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.httpsessions";
    }

    private static class HttpSessionTokensMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<HttpSessionToken> {
        private static final long serialVersionUID = -512878859657091461L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("httpsessions.options.dialog.token.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("httpsessions.options.dialog.token.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.remove.checkbox.label");
        private DialogAddToken addDialog = null;
        private DialogModifyToken modifyDialog = null;
        private OptionsHttpSessionsTableModel model;

        public HttpSessionTokensMultipleOptionsPanel(OptionsHttpSessionsTableModel optionsHttpSessionsTableModel) {
            super(optionsHttpSessionsTableModel);
            this.model = optionsHttpSessionsTableModel;
            this.getTable().getColumnExt(0).setPreferredWidth(20);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public HttpSessionToken showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddToken(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setTokens(this.model.getElements());
            this.addDialog.setVisible(true);
            HttpSessionToken httpSessionToken = this.addDialog.getToken();
            this.addDialog.clear();
            return httpSessionToken;
        }

        @Override
        public HttpSessionToken showModifyDialogue(HttpSessionToken httpSessionToken) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyToken(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setTokens(this.model.getElements());
            this.modifyDialog.setToken(httpSessionToken);
            this.modifyDialog.setVisible(true);
            HttpSessionToken httpSessionToken2 = this.modifyDialog.getToken();
            this.modifyDialog.clear();
            if (!httpSessionToken2.equals(httpSessionToken)) {
                return httpSessionToken2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(HttpSessionToken httpSessionToken) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

