/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ListViewDragSupport;
import org.openide.explorer.view.ListViewDropSupport;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.ViewTooltips;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallbackSystemAction;

public class ListView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = -7540940974042262975L;
    private transient ExplorerManager manager;
    protected transient JList list;
    protected transient NodeListModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupSupport popupSupport;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient ListViewDragSupport dragSupport;
    transient ListViewDropSupport dropSupport;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    transient boolean listenerActive;

    public ListView() {
        this.initializeList();
        this.setDropTarget(DragDropUtilities.dragAndDropEnabled);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
    }

    private void initializeList() {
        this.model = this.createModel();
        this.list = this.createList();
        this.list.setModel(this.model);
        this.setViewportView(this.list);
        AbstractAction abstractAction = new GoUpAction();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(8, 0);
        this.list.registerKeyboardAction(abstractAction, keyStroke, 0);
        abstractAction = new EnterAction();
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(abstractAction, keyStroke, 0);
        this.managerListener = new Listener();
        this.popupSupport = new PopupSupport();
        this.list.getActionMap().put("org.openide.actions.PopupAction", this.popupSupport);
        this.list.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.list);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.popupAllowed ? Boolean.TRUE : Boolean.FALSE);
        objectOutput.writeObject(this.traversalAllowed ? Boolean.TRUE : Boolean.FALSE);
        objectOutput.writeObject(new Integer(this.getSelectionMode()));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)objectInput.readObject();
        this.traversalAllowed = (Boolean)objectInput.readObject();
        this.setSelectionMode((Integer)objectInput.readObject());
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean bl) {
        this.popupAllowed = bl;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean bl) {
        this.traversalAllowed = bl;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener actionListener) {
        this.defaultProcessor = actionListener;
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl == this.dragActive) {
            return;
        }
        this.dragActive = bl;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new ListViewDragSupport(this, this.list);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (bl == this.dropActive) {
            return;
        }
        this.dropActive = bl;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new ListViewDropSupport(this, this.list);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    protected JList createList() {
        NbList nbList = new NbList();
        nbList.setCellRenderer(new NodeRenderer());
        return nbList;
    }

    protected NodeListModel createModel() {
        return new NodeListModel();
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        if (nodeArray.length == 1 && this.manager.getRootContext().equals((Object)nodeArray[0])) {
            return true;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            VisualizerNode visualizerNode = VisualizerNode.getVisualizer(null, nodeArray[i]);
            if (this.model.getIndex(visualizerNode) != -1) continue;
            return false;
        }
        return true;
    }

    protected void showSelection(int[] nArray) {
        this.list.setSelectedIndices(nArray);
    }

    public void paint(Graphics graphics) {
        new GuardedActions(0, graphics);
    }

    protected void validateTree() {
        new GuardedActions(1, null);
    }

    public Dimension getPreferredSize() {
        return (Dimension)(ListView)this.new GuardedActions((int)5, null).ret;
    }

    public void doLayout() {
        new GuardedActions(2, null);
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.model.setNode(this.manager.getExploredContext());
            this.updateSelection();
        } else if (!this.listenerActive && this.manager != null) {
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            this.model.addListDataListener(this.managerListener);
            this.model.setNode(this.manager.getExploredContext());
            this.list.addMouseListener((MouseListener)((Object)this.popupSupport));
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        if (this.manager != null) {
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.removePropertyChangeListener(this.wlpc);
        }
        this.model.removeListDataListener(this.managerListener);
        this.list.removeMouseListener((MouseListener)((Object)this.popupSupport));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ListView.this.isDisplayable()) {
                    ListView.this.model.setNode(Node.EMPTY);
                }
            }
        });
    }

    public void requestFocus() {
        this.list.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.list.requestFocusInWindow();
    }

    final void performObjectAt(int n, int n2) {
        if (n < 0 || n >= this.model.getSize()) {
            return;
        }
        VisualizerNode visualizerNode = (VisualizerNode)this.model.getElementAt(n);
        Node node = visualizerNode.node;
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, n2));
            return;
        }
        Action action = node.getPreferredAction();
        if (action != null && (n2 & 2) == 0) {
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(node.getLookup());
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(node, 1001, ""));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    private void updateSelection() {
        new GuardedActions(6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectionImpl() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        int[] nArray = new int[nodeArray.length];
        int n = this.list.getFirstVisibleIndex();
        int n2 = this.list.getLastVisibleIndex();
        boolean bl = nArray.length > 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            VisualizerNode visualizerNode = VisualizerNode.getVisualizer(null, nodeArray[i]);
            nArray[i] = this.model.getIndex(visualizerNode);
            bl = bl && (nArray[i] < n || nArray[i] > n2);
        }
        if (this.listenerActive) {
            this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        }
        try {
            this.showSelection(nArray);
            if (bl) {
                this.list.ensureIndexIsVisible(nArray[0]);
            }
        }
        finally {
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
        }
    }

    void createPopup(int n, int n2, boolean bl) {
        Object object;
        JPopupMenu jPopupMenu;
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        if (bl) {
            jPopupMenu = Utilities.actionsToPopup((Action[])this.manager.getExploredContext().getActions(true), (Component)this);
        } else {
            object = NodeOp.findActions((Node[])this.manager.getSelectedNodes());
            jPopupMenu = Utilities.actionsToPopup((Action[])object, (Component)this);
        }
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            object = this.getViewport().getViewPosition();
            object.x = n - object.x;
            object.y = n2 - object.y;
            SwingUtilities.convertPointToScreen((Point)object, this);
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = Utilities.getUsableScreenBounds((GraphicsConfiguration)this.getGraphicsConfiguration());
            if (object.x + dimension.width > rectangle.x + rectangle.width) {
                object.x = rectangle.x + rectangle.width - dimension.width;
            }
            if (object.y + dimension.height > rectangle.y + rectangle.height) {
                object.y = rectangle.y + rectangle.height - dimension.height;
            }
            SwingUtilities.convertPointFromScreen((Point)object, this);
            jPopupMenu.show(this, object.x, object.y);
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListView.this.list.getSelectedIndex();
            ListView.this.performObjectAt(n, actionEvent.getModifiers());
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class GoUpAction
    extends AbstractAction {
        static final long serialVersionUID = 1599999335583246715L;

        public GoUpAction() {
            super("GoUpAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ListView.this.traversalAllowed) {
                Node node = ListView.this.manager.getExploredContext();
                if ((node = node.getParentNode()) != null) {
                    ListView.this.manager.setExploredContext(node, ListView.this.manager.getSelectedNodes());
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        Listener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && !ListView.this.selectionAccept(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                ListView.this.updateSelection();
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                ListView.this.model.setNode(ListView.this.manager.getExploredContext());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ListView.this.model.getSize();
            int[] nArray = ListView.this.list.getSelectedIndices();
            ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < n) {
                    Node node = Visualizer.findNode(ListView.this.model.getElementAt(nArray[i]));
                    if (node != ListView.this.manager.getRootContext() && node.getParentNode() == null) continue;
                    arrayList.add(node);
                    continue;
                }
                ListView.this.updateSelection();
                return;
            }
            Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
            ListView.this.manager.removePropertyChangeListener(ListView.this.wlpc);
            ListView.this.manager.removeVetoableChangeListener(ListView.this.wlvc);
            try {
                ListView.this.selectionChanged(nodeArray, ListView.this.manager);
            }
            catch (PropertyVetoException propertyVetoException) {
                ListView.this.updateSelection();
            }
            finally {
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
            }
        }
    }

    private final class PopupSupport
    extends MouseUtils.PopupMouseAdapter
    implements Action,
    Runnable {
        CallbackSystemAction csa;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                int n = ListView.this.list.locationToIndex(mouseEvent.getPoint());
                ListView.this.performObjectAt(n, mouseEvent.getModifiers());
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = ListView.this.list.locationToIndex(point);
            if (!ListView.this.list.isSelectedIndex(n)) {
                ListView.this.list.setSelectedIndex(n);
            }
            boolean bl = (rectangle = ListView.this.list.getCellBounds(n, n)) == null || !rectangle.contains(point);
            ListView.this.createPopup(mouseEvent.getX(), mouseEvent.getY(), bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int n;
            boolean bl = ListView.this.list.getSelectionMode() != 0;
            int n2 = n = bl ? ListView.this.list.getLeadSelectionIndex() : ListView.this.list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Point point = ListView.this.list.indexToLocation(n);
            if (point == null) {
                return;
            }
            ListView.this.createPopup(point.x, point.y, false);
        }

        public Object getValue(String string) {
            return null;
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isEnabled() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class NbList
    extends JList
    implements Autoscroll {
        static final long serialVersionUID = -7571829536335024077L;
        AutoscrollSupport support;
        int SEARCH_FIELD_PREFERRED_SIZE = 160;
        int SEARCH_FIELD_SPACE = 3;
        private String maxPrefix;
        private JTextField searchTextField = new JTextField(){

            public boolean isManagingFocus() {
                return true;
            }

            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    NbList.this.removeSearchField();
                    keyEvent.consume();
                    NbList.this.requestFocus();
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        };
        private final int heightOfTextField;
        private int originalScrollMode;
        private JPanel searchpanel;

        NbList() {
            this.heightOfTextField = this.searchTextField.getPreferredSize().height;
            this.searchpanel = null;
            this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            this.setupSearch();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            ViewTooltips.register(this);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ViewTooltips.unregister(this);
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            this.repaintSelection();
        }

        @Override
        public void paint(Graphics graphics) {
            new GuardedActions(0, graphics);
        }

        @Override
        protected void validateTree() {
            new GuardedActions(1, null);
        }

        @Override
        public Dimension getPreferredSize() {
            return (Dimension)(NbList)this.new GuardedActions((int)5, null).ret;
        }

        @Override
        public Point indexToLocation(int n) {
            return (Point)(NbList)this.new GuardedActions((int)7, (Object)Integer.valueOf((int)n)).ret;
        }

        @Override
        public int locationToIndex(Point point) {
            return (Integer)(NbList)this.new GuardedActions((int)8, (Object)point).ret;
        }

        @Override
        public Object[] getSelectedValues() {
            return (Object[])(NbList)this.new GuardedActions((int)9, null).ret;
        }

        private void repaintSelection() {
            if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess()) {
                int[] nArray = this.getSelectedIndices();
                if (nArray.length == 0) {
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    Rectangle rectangle = this.getCellBounds(nArray[i], nArray[i]);
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                new GuardedActions(3, null);
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return (String)(NbList)this.new GuardedActions((int)6, (Object)mouseEvent).ret;
        }

        final String getToolTipTextImpl(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent != null && (n = this.locationToIndex(point = mouseEvent.getPoint())) >= 0) {
                VisualizerNode visualizerNode = (VisualizerNode)ListView.this.model.getElementAt(n);
                String string = visualizerNode.getShortDescription();
                String string2 = visualizerNode.getDisplayName();
                if (string != null && !string.equals(string2)) {
                    return string;
                }
            }
            return null;
        }

        @Override
        public void autoscroll(Point point) {
            this.getSupport().autoscroll(point);
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerList();
            }
            return this.accessibleContext;
        }

        private void setupSearch() {
            KeyListener[] keyListenerArray = (KeyListener[])this.getListeners(KeyListener.class);
            for (int i = 0; i < keyListenerArray.length; ++i) {
                this.removeKeyListener(keyListenerArray[i]);
            }
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getModifiers();
                    int n2 = keyEvent.getKeyCode();
                    if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                        return;
                    }
                    char c = keyEvent.getKeyChar();
                    if (!Character.isISOControl(c) && n2 != 16) {
                        NbList.this.searchTextField.setText(String.valueOf(c));
                        NbList.this.displaySearchField();
                    }
                }
            });
            SearchFieldListener searchFieldListener = new SearchFieldListener();
            this.searchTextField.addKeyListener(searchFieldListener);
            this.searchTextField.addFocusListener(searchFieldListener);
            this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
        }

        private List<Integer> doSearch(String string) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = this.getSelectedIndex() == -1 ? 0 : this.getSelectedIndex();
            int n2 = this.getModel().getSize();
            if (n2 == 0) {
                return arrayList;
            }
            while (true) {
                n %= n2;
                if ((n = this.getNextMatch(string, n, Position.Bias.Forward)) == -1 || arrayList.contains(new Integer(n))) break;
                arrayList.add(n);
                String string2 = this.getModel().getElementAt(n).toString();
                if (this.maxPrefix == null) {
                    this.maxPrefix = string2;
                }
                this.maxPrefix = this.findMaxPrefix(this.maxPrefix, string2);
                ++n;
            }
            return arrayList;
        }

        private String findMaxPrefix(String string, String string2) {
            String string3 = null;
            int n = 0;
            while (string.regionMatches(true, 0, string2, 0, n)) {
                string3 = string.substring(0, n);
                ++n;
            }
            return string3;
        }

        private void prepareSearchPanel() {
            if (this.searchpanel == null) {
                this.searchpanel = new JPanel();
                JLabel jLabel = new JLabel(NbBundle.getMessage(TreeView.class, (String)"LBL_QUICKSEARCH"));
                this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
                this.searchpanel.add(jLabel);
                this.searchpanel.add(this.searchTextField);
                jLabel.setLabelFor(this.searchTextField);
                this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            }
        }

        private void displaySearchField() {
            if (this.getModel().getSize() > 0 && !this.searchTextField.isDisplayable()) {
                JViewport jViewport = ListView.this.getViewport();
                this.originalScrollMode = jViewport.getScrollMode();
                jViewport.setScrollMode(0);
                this.prepareSearchPanel();
                this.add(this.searchpanel);
                this.revalidate();
                this.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NbList.this.searchTextField.requestFocus();
                    }
                });
            }
        }

        @Override
        public void doLayout() {
            new GuardedActions(2, null);
        }

        final void doLayoutImpl() {
            super.doLayout();
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                Rectangle rectangle = this.getVisibleRect();
                int n = Math.min(rectangle.width - this.SEARCH_FIELD_SPACE * 2, this.SEARCH_FIELD_PREFERRED_SIZE - this.SEARCH_FIELD_SPACE);
                this.searchpanel.setBounds(Math.max(this.SEARCH_FIELD_SPACE, rectangle.x + rectangle.width - n), rectangle.y + this.SEARCH_FIELD_SPACE, Math.min(rectangle.width, n) - this.SEARCH_FIELD_SPACE, this.heightOfTextField);
            }
        }

        private void removeSearchField() {
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                this.remove(this.searchpanel);
                ListView.this.getViewport().setScrollMode(this.originalScrollMode);
                this.repaint(this.searchpanel.getBounds());
                this.requestFocus();
            }
        }

        private class SearchFieldListener
        extends KeyAdapter
        implements DocumentListener,
        FocusListener {
            private List results = new ArrayList();
            private int currentSelectionIndex;

            SearchFieldListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.searchForNode();
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    NbList.this.removeSearchField();
                    NbList.this.requestFocus();
                } else if (n == 38) {
                    --this.currentSelectionIndex;
                    this.displaySearchResult();
                    keyEvent.consume();
                } else if (n == 40) {
                    ++this.currentSelectionIndex;
                    this.displaySearchResult();
                    keyEvent.consume();
                } else if (n == 9) {
                    if (NbList.this.maxPrefix != null) {
                        NbList.this.searchTextField.setText(NbList.this.maxPrefix);
                    }
                    keyEvent.consume();
                } else if (n == 10) {
                    NbList.this.removeSearchField();
                    NbList.this.requestFocus();
                    NbList.this.dispatchEvent(keyEvent);
                }
            }

            private void searchForNode() {
                this.currentSelectionIndex = 0;
                this.results.clear();
                NbList.this.maxPrefix = null;
                String string = NbList.this.searchTextField.getText();
                if (string.length() > 0) {
                    this.results = NbList.this.doSearch(string);
                    this.displaySearchResult();
                }
            }

            private void displaySearchResult() {
                int n = this.results.size();
                if (n > 0) {
                    if (this.currentSelectionIndex < 0) {
                        this.currentSelectionIndex = n - 1;
                    } else if (this.currentSelectionIndex >= n) {
                        this.currentSelectionIndex = 0;
                    }
                    Integer n2 = (Integer)this.results.get(this.currentSelectionIndex);
                    ListView.this.list.setSelectedIndex(n2);
                    ListView.this.list.ensureIndexIsVisible(n2);
                } else {
                    ListView.this.list.clearSelection();
                }
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                NbList.this.removeSearchField();
            }
        }

        private class AccessibleExplorerList
        extends JList.AccessibleJList {
            AccessibleExplorerList() {
                super(NbList.this);
            }

            public String getAccessibleName() {
                return ListView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return ListView.this.getAccessibleContext().getAccessibleDescription();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GuardedActions
        implements Mutex.Action<Object> {
            private int type;
            private Object p1;
            final Object ret;

            public GuardedActions(int n, Object object) {
                this.type = n;
                this.p1 = object;
                this.ret = Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() ? this.run() : Children.MUTEX.readAccess((Mutex.Action)this);
            }

            public Object run() {
                switch (this.type) {
                    case 0: {
                        NbList.super.paint((Graphics)this.p1);
                        break;
                    }
                    case 1: {
                        NbList.super.validateTree();
                        break;
                    }
                    case 2: {
                        NbList.this.doLayoutImpl();
                        break;
                    }
                    case 3: {
                        NbList.this.repaintSelection();
                        break;
                    }
                    case 4: {
                        NbList.super.processEvent((AWTEvent)this.p1);
                        break;
                    }
                    case 5: {
                        return NbList.super.getPreferredSize();
                    }
                    case 6: {
                        return NbList.this.getToolTipTextImpl((MouseEvent)this.p1);
                    }
                    case 7: {
                        return NbList.super.indexToLocation((Integer)this.p1);
                    }
                    case 8: {
                        return NbList.super.locationToIndex((Point)this.p1);
                    }
                    case 9: {
                        return NbList.super.getSelectedValues();
                    }
                    case 10: {
                        Object[] objectArray = (Object[])this.p1;
                        return NbList.super.processKeyBinding((KeyStroke)objectArray[0], (KeyEvent)objectArray[1], (Integer)objectArray[2], (Boolean)objectArray[3]);
                    }
                    default: {
                        throw new IllegalStateException("type: " + this.type);
                    }
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GuardedActions
    implements Mutex.Action<Object> {
        private int type;
        private Object p1;
        final Object ret;

        public GuardedActions(int n, Object object) {
            this.type = n;
            this.p1 = object;
            this.ret = Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() ? this.run() : Children.MUTEX.readAccess((Mutex.Action)this);
        }

        public Object run() {
            switch (this.type) {
                case 0: {
                    ListView.super.paint((Graphics)this.p1);
                    break;
                }
                case 1: {
                    ListView.super.validateTree();
                    break;
                }
                case 2: {
                    ListView.super.doLayout();
                    break;
                }
                case 4: {
                    ListView.super.processEvent((AWTEvent)this.p1);
                    break;
                }
                case 5: {
                    return ListView.super.getPreferredSize();
                }
                case 6: {
                    ListView.this.updateSelectionImpl();
                    break;
                }
                default: {
                    throw new IllegalStateException("type: " + this.type);
                }
            }
            return null;
        }
    }
}

