/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtificialFeaturesProvider
implements UpdateProvider {
    private static final String UNSORTED_CATEGORY = NbBundle.getMessage(ArtificialFeaturesProvider.class, (String)"ArtificialFeaturesProvider_Unsorted_Category");
    private static final String LIBRARIES_CATEGORY = NbBundle.getMessage(ArtificialFeaturesProvider.class, (String)"ArtificialFeaturesProvider_Libraries_Category");
    private static final String BRIDGES_CATEGORY = NbBundle.getMessage(ArtificialFeaturesProvider.class, (String)"ArtificialFeaturesProvider_Bridges_Category");
    private static final String FEATURES_CATEGORY = NbBundle.getMessage(ArtificialFeaturesProvider.class, (String)"ArtificialFeaturesProvider_Features_Category");
    private final Collection<UpdateItem> originalItems;
    private static final Logger log = Logger.getLogger(ArtificialFeaturesProvider.class.getName());
    private static ArtificialFeaturesProvider DUMMY;

    public static ArtificialFeaturesProvider getDummy() {
        if (DUMMY == null) {
            DUMMY = new ArtificialFeaturesProvider(null);
        }
        return DUMMY;
    }

    public ArtificialFeaturesProvider(Collection<UpdateItem> collection) {
        this.originalItems = collection;
    }

    @Override
    public String getName() {
        return "artificial-module-provider";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    private static boolean generateArtificialFeatures() {
        String string = System.getProperty("autoupdate.services.generate.features");
        return string != null && Boolean.valueOf(string) != false;
    }

    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        if (!ArtificialFeaturesProvider.generateArtificialFeatures()) {
            return Collections.emptyMap();
        }
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        HashMap hashMap2 = new HashMap();
        for (UpdateItem object : this.originalItems) {
            Object object2;
            Object object3;
            ModuleItem moduleItem;
            UpdateItemImpl updateItemImpl = Utilities.getUpdateItemImpl(object);
            if (updateItemImpl instanceof InstalledModuleItem) {
                moduleItem = (InstalledModuleItem)updateItemImpl;
                object3 = (String)((InstalledModuleItem)moduleItem).getModuleInfo().getLocalizedAttribute("OpenIDE-Module-Display-Category");
                object2 = Utilities.toModule(((InstalledModuleItem)moduleItem).getModuleInfo().getCodeNameBase(), ((InstalledModuleItem)moduleItem).getModuleInfo().getSpecificationVersion());
                assert (object2 != null) : "Module found for " + ((InstalledModuleItem)moduleItem).getModuleInfo().getCodeNameBase() + ", " + ((InstalledModuleItem)moduleItem).getModuleInfo().getSpecificationVersion();
                if (object2.isAutoload() || object2.isFixed()) {
                    object3 = LIBRARIES_CATEGORY;
                    continue;
                }
                if (object2.isEager()) {
                    object3 = BRIDGES_CATEGORY;
                    continue;
                }
                if (object3 == null || ((String)object3).length() == 0) {
                    object3 = UNSORTED_CATEGORY;
                }
                if (!hashMap2.containsKey(object3)) {
                    hashMap2.put((String)object3, new HashSet());
                }
                ((Set)hashMap2.get(object3)).add(((InstalledModuleItem)moduleItem).getModuleInfo());
                continue;
            }
            if (!(updateItemImpl instanceof ModuleItem) || LIBRARIES_CATEGORY.equals(object3 = (String)(moduleItem = (ModuleItem)updateItemImpl).getModuleInfo().getLocalizedAttribute("OpenIDE-Module-Display-Category")) || BRIDGES_CATEGORY.equals(object3) || FEATURES_CATEGORY.equals(object3)) continue;
            if (object3 == null || ((String)object3).length() == 0) {
                object2 = (String)moduleItem.getModuleInfo().getLocalizedAttribute("OpenIDE-Module-Display-Category");
                object3 = object2 == null || ((String)object2).length() == 0 ? UNSORTED_CATEGORY : object2;
            }
            if (!hashMap2.containsKey(object3)) {
                hashMap2.put((String)object3, new HashSet());
            }
            ((Set)hashMap2.get(object3)).add(moduleItem.getModuleInfo());
        }
        Iterator<UpdateItem> iterator = hashMap2.keySet().iterator();
        if (iterator.hasNext()) {
            String string = (String)((Object)iterator.next());
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return hashMap;
    }

    @Override
    public boolean refresh(boolean bl) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static FeatureItem createFeatureItem(String string, Set<ModuleUpdateElementImpl> set, UpdateElementImpl updateElementImpl, String string2) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = "";
        for (ModuleUpdateElementImpl object22 : set) {
            object = object22.getModuleInfo();
            hashSet.add(object.getCodeName() + " > " + object.getSpecificationVersion());
            SpecificationVersion specificationVersion = object.getSpecificationVersion();
            string3 = ArtificialFeaturesProvider.addVersion(string3, specificationVersion);
        }
        Object object3 = updateElementImpl == null || updateElementImpl.getDescription() == null || updateElementImpl.getDescription().length() == 0 ? "" : updateElementImpl.getDescription();
        object3 = string2 == null || string2.length() == 0 ? object3 : (String)object3 + string2;
        String string4 = updateElementImpl == null || updateElementImpl.getDisplayName() == null || updateElementImpl.getDisplayName().length() == 0 ? string : updateElementImpl.getDisplayName();
        object = updateElementImpl == null || updateElementImpl.getSpecificationVersion() == null ? string3 : updateElementImpl.getSpecificationVersion().toString();
        return new FeatureItem(string, (String)object, hashSet, string4, (String)object3, null);
    }

    public static String createVersion(Collection<ModuleInfo> collection) {
        String string = "";
        for (ModuleInfo moduleInfo : collection) {
            SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
            string = ArtificialFeaturesProvider.addVersion(string, specificationVersion);
        }
        return string;
    }

    private static String addVersion(String string, SpecificationVersion specificationVersion) {
        int n;
        int[] nArray = ArtificialFeaturesProvider.getDigitsInVersion(string);
        int[] nArray2 = ArtificialFeaturesProvider.getDigitsInVersion(specificationVersion.toString());
        int n2 = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n2];
        for (int i = 0; i < nArray3.length; ++i) {
            assert (i < nArray.length || i < nArray2.length);
            n = 0;
            if (i < nArray.length) {
                n += nArray[i];
            }
            if (i < nArray2.length) {
                n += nArray2[i];
            }
            nArray3[i] = n;
        }
        StringBuilder stringBuilder = new StringBuilder(nArray3.length * 3 + 1);
        for (n = 0; n < nArray3.length; ++n) {
            if (n > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(nArray3[n]);
        }
        return stringBuilder.toString();
    }

    private static int[] getDigitsInVersion(String string) {
        if (string.length() == 0) {
            return new int[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens();
        assert (n % 2 != 0) : "Even number of pieces in a spec version: `" + string + "`";
        int[] nArray = new int[n / 2 + 1];
        int n2 = 0;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                try {
                    int n3 = Integer.parseInt(string2);
                    assert (n3 >= 0) : "Spec version component < 0: " + n3;
                    nArray[n2++] = n3;
                }
                catch (NumberFormatException numberFormatException) {
                    log.log(Level.INFO, "NumberFormatException while parsing " + string, numberFormatException);
                }
                continue;
            }
            assert (".".equals(string2)) : "Expected dot in spec version: `" + string + "'";
            bl = true;
        }
        return nArray;
    }

    @Override
    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.COMMUNITY;
    }
}

