/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.tm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.hibernate.test.tm.SimpleJtaTransactionManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJtaTransactionImpl
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(SimpleJtaTransactionImpl.class);
    private int status;
    private LinkedList synchronizations;
    private Connection connection;
    private final SimpleJtaTransactionManagerImpl jtaTransactionManager;

    public SimpleJtaTransactionImpl(SimpleJtaTransactionManagerImpl jtaTransactionManager) {
        this.jtaTransactionManager = jtaTransactionManager;
        this.status = 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        if (this.status == 1) {
            log.trace("on commit, status was marked for rollback-only");
            this.rollback();
        } else {
            Synchronization s;
            int i;
            this.status = 7;
            for (i = 0; i < this.synchronizations.size(); ++i) {
                s = (Synchronization)this.synchronizations.get(i);
                s.beforeCompletion();
            }
            this.status = 8;
            if (this.connection != null) {
                try {
                    this.connection.commit();
                    this.connection.close();
                }
                catch (SQLException sqle) {
                    this.status = 5;
                    throw new SystemException();
                }
            }
            this.status = 3;
            for (i = 0; i < this.synchronizations.size(); ++i) {
                s = (Synchronization)this.synchronizations.get(i);
                s.afterCompletion(this.status);
            }
            this.jtaTransactionManager.endCurrent(this);
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 4;
        if (this.connection != null) {
            try {
                this.connection.rollback();
                this.connection.close();
            }
            catch (SQLException sqle) {
                this.status = 5;
                throw new SystemException();
            }
        }
        for (int i = 0; i < this.synchronizations.size(); ++i) {
            Synchronization s = (Synchronization)this.synchronizations.get(i);
            s.afterCompletion(this.status);
        }
        this.jtaTransactionManager.endCurrent(this);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedList();
        }
        this.synchronizations.add(synchronization);
    }

    public void enlistConnection(Connection connection) {
        if (this.connection != null) {
            throw new IllegalStateException("Connection already registered");
        }
        this.connection = connection;
    }

    public Connection getEnlistedConnection() {
        return this.connection;
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
        return false;
    }
}

