/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.util.Stack;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import org.xml.sax.SAXException;

class XMLExternalReader
extends XMLReader {
    XMLReader prevReader;
    int startInput;
    int entityErrType = 1;
    XMLByteReader markupDepth;
    Stack cmGroupStack;

    XMLExternalReader(XMLReader xMLReader) {
        this.prevReader = xMLReader;
        this.dtd = xMLReader.dtd;
        this.input = xMLReader.input;
        this.currentBuffer = xMLReader.currentBuffer;
        this.currentPos = xMLReader.currentPos;
        this.inputArray = xMLReader.inputArray;
        this.inputPos = xMLReader.inputPos;
        this.currentInput = xMLReader.currentInput;
        this.startInput = xMLReader.currentInput;
        this.entResolver = xMLReader.entResolver;
        this.err = xMLReader.err;
        this.lexHandler = xMLReader.lexHandler;
        this.isStandalone = xMLReader.isStandalone;
        this.valMode = xMLReader.valMode;
        this.cmGroupStack = new Stack();
        this.input.setError(this.err);
    }

    void synchronize() {
        this.input = this.prevReader.input;
        this.currentBuffer = this.prevReader.currentBuffer;
        this.currentPos = this.prevReader.currentPos;
        this.currentInput = this.prevReader.currentInput;
        this.startInput = this.prevReader.currentInput;
        this.cmGroupStack.setSize(0);
    }

    XMLEntity getEntity(boolean bl) throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity;
        String string = super.scanQName();
        if (!super.tryRead(59)) {
            this.err.error1(100, 0, ";");
        }
        if ((xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl)) == null) {
            int n = 0;
            if (bl || !this.isStandalone) {
                n = this.valMode == 0 ? 2 : 1;
            }
            this.err.error1(250, n, string);
        }
        return xMLEntity;
    }

    boolean pushEntityRef() throws SAXException, IOException {
        if (super.tryRead(37)) {
            XMLEntity xMLEntity = this.getEntity(true);
            if (xMLEntity == null) {
                return false;
            }
            boolean bl = this.pushEntityRef(xMLEntity);
            this.skipWhiteSpace();
            return bl;
        }
        return false;
    }

    void checkEntityStart() throws SAXException, IOException {
        while (this.pushEntityRef()) {
        }
    }

    boolean popEntityRef() throws SAXException, IOException {
        if (this.startInput == this.currentInput) {
            return false;
        }
        boolean bl = this.skipWhiteSpace();
        if (this.isEOF()) {
            this.popXMLReader();
            this.push(32);
            return true;
        }
        if (bl) {
            this.push(32);
        }
        return false;
    }

    void checkEntityEnd() throws SAXException, IOException {
        while (this.popEntityRef()) {
        }
    }

    XMLExternalReader getExternalReader() {
        return this;
    }

    XMLReader getInternalReader() throws SAXException, IOException {
        this.popXMLReader();
        this.prevReader.input = this.input;
        this.prevReader.currentInput = this.currentInput;
        this.prevReader.currentPos = this.currentPos;
        this.prevReader.currentBuffer = this.currentBuffer;
        this.prevReader.externalReader = false;
        this.push(32);
        return this.prevReader;
    }

    public boolean checkParEntity() throws SAXException, IOException {
        try {
            if (this.currentBuffer[this.currentPos] == '%') {
                ++this.currentPos;
                if (this.skipWhiteSpace()) {
                    return true;
                }
                --this.currentPos;
                this.pushEntityRef();
                boolean bl = this.checkParEntity();
                this.checkEntityEnd();
                return bl;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.checkParEntity();
            }
            return false;
        }
    }

    public boolean tryRead(int n) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(n);
        this.checkEntityEnd();
        return bl;
    }

    public boolean tryRead(char[] cArray, int n, int n2) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(cArray, n, n2);
        this.checkEntityEnd();
        return bl;
    }

    boolean setMarkupDepth(int n) throws SAXException, IOException {
        boolean bl;
        int n2 = this.currentInput;
        this.checkEntityStart();
        if (n2 != this.currentInput) {
            this.entityErrType = 0;
        }
        if (bl = super.tryRead(n)) {
            this.markupDepth = this.input;
        }
        this.checkEntityEnd();
        return bl;
    }

    boolean setMarkupDepth(char[] cArray, int n, int n2) throws SAXException, IOException {
        boolean bl;
        int n3 = this.currentInput;
        this.checkEntityStart();
        if (n3 != this.currentInput) {
            this.entityErrType = 0;
        }
        if (bl = super.tryRead(cArray, n, n2)) {
            this.markupDepth = this.input;
        }
        this.checkEntityEnd();
        return bl;
    }

    boolean checkMarkupDepth(int n) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(n);
        if (bl && this.markupDepth != this.input && (this.entityErrType == 0 || this.valMode == 2)) {
            this.err.error1(100, this.entityErrType, "" + (char)n);
        }
        this.checkEntityEnd();
        return bl;
    }

    boolean checkMarkupDepth(char[] cArray, int n, int n2) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(cArray, n, n2);
        if (bl && this.markupDepth != this.input && (this.entityErrType == 0 || this.valMode == 2)) {
            this.err.error1(100, this.entityErrType, new String(cArray, n, n2));
        }
        this.checkEntityEnd();
        return bl;
    }

    boolean isCMGroupStart() throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(40);
        if (bl) {
            this.cmGroupStack.push(this.input);
        }
        this.checkEntityEnd();
        return bl;
    }

    boolean isCMGroupEnd() throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(41);
        if (bl) {
            XMLByteReader xMLByteReader = (XMLByteReader)this.cmGroupStack.pop();
            if (this.valMode == 2 && xMLByteReader != this.input) {
                this.err.error1(100, 1, ")");
            }
        }
        this.checkEntityEnd();
        return bl;
    }

    public String scanNmToken() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanNmToken();
        this.checkEntityEnd();
        return string;
    }

    public String scanName() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanName();
        this.checkEntityEnd();
        return string;
    }

    public String scanQName(String[] stringArray) throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanQName(stringArray);
        this.checkEntityEnd();
        return string;
    }

    public String scanQName() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanQName();
        this.checkEntityEnd();
        return string;
    }

    public char[] scanWhiteSpace(int[] nArray) throws SAXException, IOException {
        this.checkEntityStart();
        char[] cArray = super.scanWhiteSpace(nArray);
        this.checkEntityEnd();
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String scanEntityString(int n) throws SAXException, IOException {
        String string = "";
        while (true) {
            string = string.concat(super.scanEntityString(n));
            if (super.peek() == n) return string;
            if (super.tryRead(37)) {
                string = string.concat(this.scanEntityRefValue());
                continue;
            }
            if (this.isEOF()) return string;
        }
    }

    String scanEntityRefValue() throws XMLParseException, SAXException, IOException {
        String string = "";
        String string2 = super.scanQName();
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string2, true);
        if (!super.tryRead(59)) {
            this.err.error1(100, 0, ";");
        }
        if (xMLEntity == null) {
            this.err.error1(151, 1, string2);
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        if (!this.pushEntityRef(xMLEntity)) {
            return "";
        }
        while (true) {
            string = string.concat(super.scanEntityString(65535));
            if (super.tryRead(37)) {
                string = string.concat(this.scanEntityRefValue());
                continue;
            }
            if (this.isEOF()) break;
        }
        this.popXMLReader();
        return string;
    }

    public String scanQuotedString() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanQuotedString();
        this.checkEntityEnd();
        return string;
    }

    public void requireWhiteSpace() throws SAXException, IOException {
        if (!this.skipWhiteSpace() && !this.pushEntityRef()) {
            this.err.error0(190, 0);
        }
    }

    public int read() throws SAXException, IOException {
        this.checkEntityStart();
        int n = super.read();
        this.checkEntityEnd();
        return n;
    }

    public void skipIgnoreSection() throws SAXException, IOException {
        this.skipWhiteSpace();
        if (!super.tryRead(91)) {
            this.err.error1(205, 0, "[");
        }
        this.skipIgnoreSectionContent();
    }

    public void skipIgnoreSectionContent() throws SAXException, IOException {
        while (!this.isEOF()) {
            if (super.tryRead(XMLConstants.cCDATASTART, 0, 3)) {
                this.skipIgnoreSectionContent();
                continue;
            }
            if (super.tryRead(XMLConstants.cCDATAEND, 0, XMLConstants.cCDATAEND.length)) {
                this.checkEntityEnd();
                return;
            }
            ++this.currentPos;
        }
        this.err.error0(115, 0);
        this.err.error0(193, 0);
        this.err.flushErrors1();
        this.checkEntityEnd();
    }

    public void skipUntil(int n) throws SAXException, IOException {
        super.skipUntil(n);
        this.checkEntityEnd();
    }

    public void skipQName() throws SAXException, IOException {
        super.skipQName();
        this.checkEntityEnd();
    }

    void skipQuotedString() throws SAXException, IOException {
        super.skipQuotedString();
        this.checkEntityEnd();
    }

    public char[] scanComment(int[] nArray) throws SAXException, IOException {
        char[] cArray = super.scanComment(nArray);
        if (this.markupDepth != this.input && (this.entityErrType == 0 || this.valMode == 2)) {
            this.err.error1(100, this.entityErrType, "-->");
        }
        this.checkEntityEnd();
        return cArray;
    }

    public String scanPI() throws SAXException, IOException {
        String string = super.scanPI();
        if (this.markupDepth != this.input && (this.entityErrType == 0 || this.valMode == 2)) {
            this.err.error1(100, this.entityErrType, "?>");
        }
        this.checkEntityEnd();
        return string;
    }
}

