/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.xdb.servlet.ArrayEnumeration;
import oracle.xdb.servlet.XDBCookie;
import oracle.xdb.servlet.XDBPrincipal;
import oracle.xdb.servlet.XDBRequestStream;

public class XDBServletRequest
implements HttpServletRequest {
    private Hashtable attributes_ = new Hashtable();
    private Locale[] loclist_;

    static /* synthetic */ int access$0(XDBServletRequest $0) {
        return $0.get_nparams();
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes_.keys();
    }

    public native String getAuthType();

    public native String getCharacterEncoding();

    public native int getContentLength();

    public native String getContentType();

    public native String getContextPath();

    public Cookie[] getCookies() {
        int num = this.get_numcookies();
        Cookie[] cooklist = new XDBCookie[num];
        int i = 0;
        while (i < num) {
            cooklist[i] = new XDBCookie(i);
            ++i;
        }
        return cooklist;
    }

    public native long getDateHeader(String var1);

    public native String getHeader(String var1);

    public Enumeration getHeaderNames() {
        return new ArrayEnumeration(this.get_headernames("all"));
    }

    public Enumeration getHeaders(String name) {
        return new ArrayEnumeration(this.get_headervals(name));
    }

    public ServletInputStream getInputStream() {
        return new XDBRequestStream();
    }

    public native int getIntHeader(String var1);

    public Locale getLocale() {
        if (this.loclist_ == null) {
            this.makeLocaleList();
        }
        return this.loclist_[0];
    }

    public Enumeration getLocales() {
        if (this.loclist_ == null) {
            this.makeLocaleList();
        }
        return new ArrayEnumeration(this.loclist_);
    }

    public native String getMethod();

    public native String getParameter(String var1);

    public Enumeration getParameterNames() {
        return new ParamNames();
    }

    public native String[] getParameterValues(String var1);

    public native String getPathInfo();

    public native String getPathTranslated();

    public native String getProtocol();

    public native String getQueryString();

    public BufferedReader getReader() throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)((Object)new XDBRequestStream()), this.getCharacterEncoding());
        return new BufferedReader(r);
    }

    public String getRealPath(String path) {
        return null;
    }

    public native String getRemoteAddr();

    public native String getRemoteHost();

    public native String getRemoteUser();

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new RuntimeException("not implemented");
    }

    public native String getRequestURI();

    public native String getRequestedSessionId();

    public native String getScheme();

    public native String getServerName();

    public native int getServerPort();

    public native String getServletPath();

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public Principal getUserPrincipal() {
        return new XDBPrincipal(this.get_userid(), this.get_username());
    }

    private native String get_acceptcountry(int var1);

    private native String get_acceptlang(int var1);

    private native String[] get_headernames(String var1);

    private native String[] get_headervals(String var1);

    private native int get_nparams();

    private native int get_numacceptlang();

    private native int get_numcookies();

    private native String get_paramname(int var1);

    private native byte[] get_userid();

    private native String get_username();

    public native boolean isRequestedSessionIdFromCookie();

    public native boolean isRequestedSessionIdFromURL();

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isSecure() {
        return this.getScheme().equals("https");
    }

    public native boolean isUserInRole(String var1);

    private void makeLocaleList() {
        int numLocales = this.get_numacceptlang();
        if (numLocales < 1) {
            this.loclist_ = new Locale[1];
            this.loclist_[0] = Locale.getDefault();
            return;
        }
        this.loclist_ = new Locale[numLocales];
        int i = 0;
        while (i < this.loclist_.length) {
            String lang = this.get_acceptlang(i);
            String country = this.get_acceptcountry(i);
            if (country == null) {
                country = "";
            }
            this.loclist_[i] = new Locale(lang, country);
            ++i;
        }
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes_.put(name, o);
    }

    class ParamNames
    implements Enumeration {
        int index_ = 0;
        int nparams_ = XDBServletRequest.access$0(XDBServletRequest.this);

        ParamNames() {
        }

        public boolean hasMoreElements() {
            return this.index_ < this.nparams_;
        }

        public Object nextElement() {
            String o;
            if ((o = XDBServletRequest.this.get_paramname(this.index_++)) == null) {
                throw new NoSuchElementException();
            }
            return o;
        }
    }
}

