/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwingOutline
extends JScrollPane
implements GUIOutline {
    private boolean ignoreAlteredBookmark = false;
    private Map pageLookupTableViaTitle = new HashMap();
    private Map pageLookupTableViaNodeNumber = new HashMap();
    private Map pointLookupTable = new HashMap();
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;
    private boolean hasDuplicateTitles;

    public SwingOutline() {
        this.getViewport().add(new JLabel("No outline"));
    }

    public void reset(Node node) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        if (node != null) {
            this.hasDuplicateTitles = false;
            this.readChildNodes(node, this.top, 0);
        }
        this.tree = new JTree(this.top);
        if (node != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public int readChildNodes(Node node, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.top;
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            Element element = (Element)node2;
            String string = element.getAttribute("title");
            String string2 = element.getAttribute("page");
            String string3 = element.getAttribute("Dest");
            if (this.pageLookupTableViaTitle.containsKey(string)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(string, string2);
            }
            this.pageLookupTableViaNodeNumber.put(new Integer(n), string2);
            ++n;
            if (string3 != null && string3.indexOf("/XYZ") != -1) {
                String string4;
                object = new StringTokenizer(string3 = string3.substring(string3.indexOf("/XYZ") + 4), "[] ");
                String string5 = ((StringTokenizer)object).nextToken();
                if (string5.equals("null")) {
                    string5 = "0";
                }
                if ((string4 = ((StringTokenizer)object).nextToken()).equals("null")) {
                    string4 = "0";
                }
                this.pointLookupTable.put(string, new Point((int)Float.parseFloat(string5), (int)Float.parseFloat(string4)));
            }
            object = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add((MutableTreeNode)object);
            if (!node2.hasChildNodes()) continue;
            n = this.readChildNodes(node2, (DefaultMutableTreeNode)object, n);
        }
        return n;
    }

    public boolean isIgnoreAlteredBookmark() {
        return this.ignoreAlteredBookmark;
    }

    public String getPage(String string) {
        if (this.hasDuplicateTitles) {
            throw new RuntimeException("Bookmark " + string + " not unique");
        }
        return (String)this.pageLookupTableViaTitle.get(string);
    }

    public String getPageViaNodeNumber(int n) {
        return (String)this.pageLookupTableViaNodeNumber.get(new Integer(n));
    }

    public void selectBookmark() {
    }

    public Point getPoint(String string) {
        return (Point)this.pointLookupTable.get(string);
    }

    public Object getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

