/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.annotation;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.action.PDAdditionalActions;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;

public abstract class PDAnnotation
implements COSObjectable {
    public static final int FLAG_INVISIBLE = 1;
    public static final int FLAG_HIDDEN = 2;
    public static final int FLAG_PRINTED = 4;
    public static final int FLAG_NO_ZOOM = 8;
    public static final int FLAG_NO_ROTATE = 16;
    public static final int FLAG_NO_VIEW = 32;
    public static final int FLAG_READ_ONLY = 64;
    public static final int FLAG_LOCKED = 128;
    public static final int FLAG_TOGGLE_NO_VIEW = 256;
    private COSDictionary dictionary;

    public PDAnnotation() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("Annot"));
    }

    public PDAnnotation(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDRectangle getRectangle() {
        COSArray rectArray = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Rect"));
        PDRectangle rectangle = null;
        if (rectArray != null) {
            rectangle = new PDRectangle(rectArray);
        }
        return rectangle;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.dictionary.setItem(COSName.getPDFName("Rect"), (COSBase)rectangle.getCOSArray());
    }

    public int getAnnotationFlags() {
        return this.getDictionary().getInt("F", 0);
    }

    public void setAnnotationFlags(int flags) {
        this.getDictionary().setInt("F", flags);
    }

    public COSBase getCOSObject() {
        return this.getDictionary();
    }

    public String getAppearanceStream() {
        String retval = null;
        COSName name = (COSName)this.getDictionary().getDictionaryObject(COSName.getPDFName("AS"));
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setAppearanceStream(String as) {
        if (as == null) {
            this.getDictionary().removeItem(COSName.getPDFName("AS"));
        } else {
            this.getDictionary().setItem(COSName.getPDFName("AS"), (COSBase)COSName.getPDFName(as));
        }
    }

    public PDAppearanceDictionary getAppearance() {
        PDAppearanceDictionary ap = null;
        COSDictionary apDic = (COSDictionary)this.dictionary.getDictionaryObject(COSName.getPDFName("AP"));
        if (apDic != null) {
            ap = new PDAppearanceDictionary(apDic);
        }
        return ap;
    }

    public void setAppearance(PDAppearanceDictionary appearance) {
        COSDictionary ap = null;
        if (appearance != null) {
            ap = appearance.getDictionary();
        }
        this.dictionary.setItem(COSName.getPDFName("AP"), (COSBase)ap);
    }

    public boolean isInvisible() {
        return (this.getAnnotationFlags() & 1) == 1;
    }

    public void setInvisible(boolean invisible) {
        if (invisible) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 1);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 1);
        }
    }

    public boolean isHidden() {
        return (this.getAnnotationFlags() & 2) == 2;
    }

    public void setHidden(boolean hidden) {
        if (hidden) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 2);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 2);
        }
    }

    public boolean isPrinted() {
        return (this.getAnnotationFlags() & 4) == 4;
    }

    public void setPrinted(boolean printed) {
        if (printed) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 4);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 4);
        }
    }

    public boolean isNoZoom() {
        return (this.getAnnotationFlags() & 8) == 8;
    }

    public void setNoZoom(boolean noZoom) {
        if (noZoom) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 8);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 8);
        }
    }

    public boolean isNoRotate() {
        return (this.getAnnotationFlags() & 0x10) == 16;
    }

    public void setNoRotate(boolean noRotate) {
        if (noRotate) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 0x10);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 0x10);
        }
    }

    public boolean isNoView() {
        return (this.getAnnotationFlags() & 0x20) == 32;
    }

    public void setNoView(boolean noView) {
        if (noView) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 0x20);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 0x20);
        }
    }

    public boolean isReadOnly() {
        return (this.getAnnotationFlags() & 0x40) == 64;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 0x40);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 0x40);
        }
    }

    public boolean isLocked() {
        return (this.getAnnotationFlags() & 0x80) == 128;
    }

    public void setLocked(boolean locked) {
        if (locked) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 0x80);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 0x80);
        }
    }

    public boolean isToggleNoView() {
        return (this.getAnnotationFlags() & 0x100) == 256;
    }

    public void setToggleNoView(boolean toggleNoView) {
        if (toggleNoView) {
            this.setAnnotationFlags(this.getAnnotationFlags() | 0x100);
        } else {
            this.setAnnotationFlags(this.getAnnotationFlags() ^ 0x100);
        }
    }

    public PDAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.dictionary.getDictionaryObject("AA");
        PDAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDAdditionalActions actions) {
        this.dictionary.setItem("AA", (COSObjectable)actions);
    }
}

