/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ThrottleSettings {
    public static final int POLICY_NONE = 0;
    public static final int POLICY_ERROR = 1;
    public static final int POLICY_IGNORE = 2;
    public static final int POLICY_REPLACE = 3;
    public static final String POLICY_NONE_STRING = "NONE";
    public static final String POLICY_ERROR_STRING = "ERROR";
    public static final String POLICY_IGNORE_STRING = "IGNORE";
    public static final String POLICY_REPLACE_STRING = "REPLACE";
    public static final String ELEMENT_INBOUND = "throttle-inbound";
    public static final String ELEMENT_OUTBOUND = "throttle-outbound";
    public static final String ELEMENT_POLICY = "policy";
    public static final String ELEMENT_DEST_FREQ = "max-frequency";
    public static final String ELEMENT_CLIENT_FREQ = "max-client-frequency";
    private String destinationName;
    private int inClientMessagesPerSec = 0;
    private int inDestinationMessagesPerSec = 0;
    private int outClientMessagesPerSec;
    private int outDestinationMessagesPerSec = 0;
    private int inPolicy = 0;
    private int outPolicy = 0;

    public static int parsePolicy(String policy) {
        if (POLICY_NONE_STRING.equalsIgnoreCase(policy)) {
            return 0;
        }
        if (POLICY_IGNORE_STRING.equalsIgnoreCase(policy)) {
            return 2;
        }
        if (POLICY_ERROR_STRING.equalsIgnoreCase(policy)) {
            return 1;
        }
        if (POLICY_REPLACE_STRING.equalsIgnoreCase(policy)) {
            return 3;
        }
        ConfigurationException ex = new ConfigurationException();
        ex.setMessage("Unsupported throttle policy '" + policy + "'");
        throw ex;
    }

    public boolean isClientThrottleEnabled() {
        return this.getIncomingClientFrequency() > 0 || this.getOutgoingClientFrequency() > 0;
    }

    public boolean isDestinationThrottleEnabled() {
        return this.getIncomingDestinationFrequency() > 0 || this.getOutgoingDestinationFrequency() > 0;
    }

    public int getInboundPolicy() {
        return this.inPolicy;
    }

    public void setInboundPolicy(int inPolicy) {
        if (inPolicy == 3) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The REPLACE throttle policy applies to outbound throttling only");
            throw ex;
        }
        this.inPolicy = inPolicy;
    }

    public int getOutboundPolicy() {
        return this.outPolicy;
    }

    public void setOutboundPolicy(int outPolicy) {
        this.outPolicy = outPolicy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public int getIncomingClientFrequency() {
        return this.inClientMessagesPerSec;
    }

    public void setIncomingClientFrequency(int n) {
        if (this.inDestinationMessagesPerSec > 0 && n > this.inDestinationMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The incoming client frequency '" + n + "' cannot be more than the incoming destination frequency '" + this.inDestinationMessagesPerSec + "'");
            throw ex;
        }
        this.inClientMessagesPerSec = n;
    }

    public int getIncomingDestinationFrequency() {
        return this.inDestinationMessagesPerSec;
    }

    public void setIncomingDestinationFrequency(int n) {
        if (n < this.inClientMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The incoming destination frequency '" + n + "' cannot be less than the incoming client frequency '" + this.inClientMessagesPerSec + "'");
            throw ex;
        }
        this.inDestinationMessagesPerSec = n;
    }

    public int getOutgoingClientFrequency() {
        return this.outClientMessagesPerSec;
    }

    public void setOutgoingClientFrequency(int n) {
        if (this.outDestinationMessagesPerSec > 0 && n > this.outDestinationMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The outgoing client frequency '" + n + "' cannot be more than the outgoing destination frequency '" + this.outDestinationMessagesPerSec + "'");
            throw ex;
        }
        this.outClientMessagesPerSec = n;
    }

    public int getOutgoingDestinationFrequency() {
        return this.outDestinationMessagesPerSec;
    }

    public void setOutgoingDestinationFrequency(int n) {
        if (n < this.outClientMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The outgoing destination frequency '" + n + "' cannot be less than the outgoing client frequency '" + this.outClientMessagesPerSec + "'");
            throw ex;
        }
        this.outDestinationMessagesPerSec = n;
    }
}

