/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.ffmpegnative;

import com.sun.media.BasicCodec;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sourceforge.jffmpeg.CodecManager;
import net.sourceforge.jffmpeg.ffmpegnative.BitRateAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.BitRateShapingAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.CompatibilityAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.CpuLoadMgtAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.FrameProcessingAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.FrameRateAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.H263Adapter;
import net.sourceforge.jffmpeg.ffmpegnative.KeyFrameAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.PacketSizeAdapter;
import net.sourceforge.jffmpeg.ffmpegnative.QualityAdapter;

public class NativeEncoder
extends BasicCodec {
    private static final String PLUGIN_NAME = "FFMPEG Encoder";
    private static final int DEF_WIDTH = 352;
    private static final int DEF_HEIGHT = 288;
    private static final int INPUT_BUFFER_PADDING_SIZE = 8;
    private static final Format[] defOutputFormats = new Format[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
    private int inputYuvLength;
    private int outputH263Length;
    private Control[] controls = null;
    private static final int MIN_BIT_RATE = 20000;
    private static final int MAX_BIT_RATE = 1000000;
    protected int bitRate = 128000;
    protected boolean goSouth = false;
    protected int framesBehind = 0;
    protected int framesDropped = 0;
    private static final float MIN_FRAME_RATE = 1.0f;
    private static final float MAX_FRAME_RATE = 30.0f;
    protected float sourceFrameRate = 0.0f;
    protected float targetFrameRate = 10.0f;
    protected int frameDecimation = 1;
    private int frames2Skip = 0;
    protected int keyFrameInterval = 10;
    protected float quality = 4.0f;
    protected static final int MIN_RTP_MTU = 320;
    protected static final int MAX_RTP_MTU = 1348;
    protected int targetPacketSize = 984;
    private static final int MAX_PAYLOAD_SIZE = 2048;
    protected boolean resetRequired = false;
    private boolean rtpActive = false;
    private long seqNum = 0L;
    private long frameNum = 0L;
    private TimeBase masterTimeBase = new SystemTimeBase();
    private long lastFrameTime = 0L;
    protected boolean shapingActive = true;
    private long lastPacketTime;
    private long lastPacketBits;
    protected boolean compatibility = false;
    protected boolean cpuActive = false;
    protected long targetFrameTime;
    public int peer = 0;
    public boolean inputDone = true;
    public int outputSize = 0;
    private static boolean nativeLibraryLoaded = false;

    private native boolean open_encoder(String var1, int var2, int var3, int var4, int var5, int var6, float var7, boolean var8, int var9, boolean var10);

    private native boolean close_encoder(int var1);

    protected native boolean set_frameRate(int var1, int var2);

    protected native boolean set_quality(int var1, float var2);

    protected native boolean set_rtpPayloadSize(int var1, int var2);

    protected native boolean set_compatibility(int var1, boolean var2);

    private native boolean convert(int var1, Object var2, long var3, int var5, int var6, int var7, Object var8, long var9, int var11);

    public boolean isCodecAvailable() {
        return nativeLibraryLoaded;
    }

    public NativeEncoder() {
        this.inputFormats = new Format[]{new YUVFormat(2)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public void finalize() {
    }

    private Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        this.outputFormats = new VideoFormat[]{new VideoFormat("h263", dimension, -1, Format.byteArray, videoFormat.getFrameRate()), new VideoFormat("h263/rtp", dimension, -1, Format.byteArray, videoFormat.getFrameRate())};
        return this.outputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return defOutputFormats;
        }
        if (!(format instanceof VideoFormat) || null == NativeEncoder.matches((Format)format, (Format[])this.inputFormats)) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(format);
    }

    public Format setInputFormat(Format format) {
        YUVFormat yUVFormat;
        if (!(format instanceof VideoFormat) || null == NativeEncoder.matches((Format)format, (Format[])this.inputFormats)) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(352, 288);
        }
        if ((yUVFormat = (YUVFormat)videoFormat).getOffsetU() > yUVFormat.getOffsetV()) {
            return null;
        }
        int n = dimension.width;
        int n2 = n / 2;
        int n3 = n * dimension.height;
        int n4 = n3 + n2 * dimension.height / 2;
        this.inputYuvLength = (n + n2) * dimension.height;
        this.sourceFrameRate = videoFormat.getFrameRate();
        this.frameDecimation = this.targetFrameRate < this.sourceFrameRate ? (int)(this.sourceFrameRate / this.targetFrameRate) : 1;
        this.inputFormat = new YUVFormat(dimension, this.inputYuvLength + 8, Format.byteArray, this.sourceFrameRate, 2, n, n2, 0, n3, n4);
        return this.inputFormat;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == NativeEncoder.matches((Format)format, (Format[])this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            Dimension dimension2 = ((VideoFormat)this.inputFormat).getSize();
            dimension = dimension2 == null ? new Dimension(352, 288) : dimension2;
        }
        this.rtpActive = this.isRTPFormat((Format)videoFormat);
        this.outputH263Length = this.rtpActive ? 2048 : dimension.width * dimension.height;
        this.targetFrameRate = videoFormat.getFrameRate();
        this.frameDecimation = this.targetFrameRate < this.sourceFrameRate ? (int)(this.sourceFrameRate / this.targetFrameRate) : 1;
        this.targetFrameTime = 1250000000L / (long)this.targetFrameRate;
        this.outputFormat = new VideoFormat(videoFormat.getEncoding(), dimension, this.outputH263Length, Format.byteArray, videoFormat.getFrameRate());
        return this.outputFormat;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        long l;
        long l2;
        long l3;
        boolean bl;
        Format format;
        int n;
        if (this.inputDone) {
            if (this.isEOM(buffer)) {
                this.propagateEOM(buffer2);
                this.reset();
                return 0;
            }
            if (buffer.isDiscard()) {
                buffer2.setDiscard(true);
                this.reset();
                return 0;
            }
            ++this.frames2Skip;
            if (this.frames2Skip < this.frameDecimation) {
                buffer2.setOffset(0);
                buffer2.setLength(0);
                buffer2.setFormat(this.outputFormat);
                return 4;
            }
            this.frames2Skip = 0;
            if (this.frameNum > 0L) {
                long l4 = this.masterTimeBase.getNanoseconds() - this.lastFrameTime + 1L;
                n = (int)(1000000000L / l4);
                this.set_frameRate(this.peer, Math.max(n, (int)this.targetFrameRate) + 1);
                if (this.cpuActive && l4 > this.targetFrameTime) {
                    this.framesBehind += (int)(l4 / this.targetFrameTime);
                }
            }
            this.lastFrameTime = this.masterTimeBase.getNanoseconds();
            if (this.framesBehind > 0) {
                --this.framesBehind;
                ++this.framesDropped;
                buffer2.setOffset(0);
                buffer2.setLength(0);
                buffer2.setFormat(this.outputFormat);
                return 4;
            }
            if (this.goSouth) {
                ++this.framesDropped;
                buffer2.setOffset(0);
                buffer2.setLength(0);
                buffer2.setFormat(this.outputFormat);
                return 4;
            }
        }
        if ((format = buffer.getFormat()) != this.inputFormat && !format.matches(this.inputFormat)) {
            this.setInputFormat(format);
        }
        if (buffer.getLength() < 10) {
            buffer2.setDiscard(true);
            this.reset();
            return 0;
        }
        int n2 = buffer.getOffset();
        n = buffer.getLength();
        byte[] byArray = (byte[])buffer.getData();
        int n3 = byArray.length;
        Object object = this.getInputData(buffer);
        long l5 = this.getNativeData(object);
        Object object2 = this.getOutputData(buffer2);
        if (object2 == null || buffer2.getFormat() != this.outputFormat || !buffer2.getFormat().equals((Object)this.outputFormat)) {
            buffer2.setLength(this.outputH263Length);
            buffer2.setFormat(this.outputFormat);
        }
        if (!(bl = this.convert(this.peer, object, l5, n3, n2, n, object2 = this.validateData(buffer2, this.outputH263Length, true), l3 = this.getNativeData(object2), this.outputH263Length))) {
            return 1;
        }
        buffer2.setOffset(0);
        buffer2.setLength(this.outputSize);
        if (this.rtpActive) {
            buffer2.setSequenceNumber(this.seqNum);
        }
        if (this.shapingActive && (l2 = 1000000000L * this.lastPacketBits / (long)this.bitRate) > (l = this.masterTimeBase.getNanoseconds() - this.lastPacketTime)) {
            try {
                ((Object)((Object)this)).wait(l2 - l);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.lastPacketTime = this.masterTimeBase.getNanoseconds();
        this.lastPacketBits = this.outputSize * 8;
        if (!this.inputDone) {
            ++this.seqNum;
            return 2;
        }
        if (this.rtpActive) {
            int n4 = buffer2.getFlags();
            buffer2.setFlags(n4 | 0x800);
        }
        ++this.seqNum;
        ++this.frameNum;
        this.reset();
        return 0;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (!this.opened) {
            super.open();
            if (this.inputFormat == null) {
                throw new ResourceUnavailableException("No input format selected");
            }
            if (this.outputFormat == null) {
                throw new ResourceUnavailableException("No output format selected");
            }
            Dimension dimension = ((VideoFormat)this.inputFormat).getSize();
            if (!this.open_encoder(this.outputFormat.getEncoding(), dimension.width, dimension.height, this.bitRate, (int)this.targetFrameRate, this.keyFrameInterval, this.quality, this.bitRate < 1000000, this.compatibility ? this.targetPacketSize : this.targetPacketSize - 128, this.compatibility)) {
                throw new ResourceUnavailableException("Couldn't open codec for " + this.inputFormat.toString());
            }
            this.resetRequired = false;
        }
    }

    public synchronized void close() {
        if (this.opened) {
            this.close_encoder(this.peer);
            super.close();
        }
    }

    public synchronized void reset() {
        if (this.resetRequired && this.opened) {
            try {
                this.close();
                this.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    private boolean isRTPFormat(Format format) {
        return format.getEncoding().equals("h263/rtp");
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[]{new H263Adapter(this, false, false, false, false, false, 0, 1000, false), new BitRateAdapter(this, this.bitRate, 20000, 1000000, true), new FrameProcessingAdapter(this), new FrameRateAdapter(this, this.targetFrameRate, 1.0f, 30.0f, true), new KeyFrameAdapter(this, this.keyFrameInterval, true), new QualityAdapter(this, (31.0f - this.quality) / 27.0f, 0.0f, 1.0f, false, true), new PacketSizeAdapter(this, this.targetPacketSize, true), new BitRateShapingAdapter(this), new CompatibilityAdapter(this), new CpuLoadMgtAdapter(this)};
        }
        return this.controls;
    }

    static {
        CodecManager codecManager = new CodecManager();
        String string = codecManager.getNativeLibraryName();
        if (string == null) {
            string = "jffmpeg";
        }
        try {
            System.loadLibrary(string);
            nativeLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            nativeLibraryLoaded = false;
        }
    }
}

