/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.UPX;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class StyleDescription
implements HDFType {
    private static final int PARAGRAPH_STYLE = 1;
    private static final int CHARACTER_STYLE = 2;
    private int _istd;
    private int _baseLength;
    private short _infoShort;
    private static BitField _sti = new BitField(4095);
    private static BitField _fScratch = new BitField(4096);
    private static BitField _fInvalHeight = new BitField(8192);
    private static BitField _fHasUpe = new BitField(16384);
    private static BitField _fMassCopy = new BitField(32768);
    private short _infoShort2;
    private static BitField _styleTypeCode = new BitField(15);
    private static BitField _baseStyle = new BitField(65520);
    private short _infoShort3;
    private static BitField _numUPX = new BitField(15);
    private static BitField _nextStyle = new BitField(65520);
    private short _bchUpe;
    private short _infoShort4;
    private static BitField _fAutoRedef = new BitField(1);
    private static BitField _fHidden = new BitField(2);
    UPX[] _upxs;
    String _name;
    ParagraphProperties _pap;
    CharacterProperties _chp;

    public StyleDescription() {
    }

    public StyleDescription(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        this._baseLength = n;
        int n4 = n2 + n;
        this._infoShort = LittleEndian.getShort(byArray, n2);
        this._infoShort2 = LittleEndian.getShort(byArray, n2 += 2);
        this._infoShort3 = LittleEndian.getShort(byArray, n2 += 2);
        this._bchUpe = LittleEndian.getShort(byArray, n2 += 2);
        this._infoShort4 = LittleEndian.getShort(byArray, n2 += 2);
        n2 += 2;
        short s = 0;
        int n5 = 1;
        if (bl) {
            s = LittleEndian.getShort(byArray, n4);
            n5 = 2;
            n4 += 2;
        } else {
            s = byArray[n4];
        }
        try {
            this._name = new String(byArray, n4, s * n5, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n6 = n3 = (s + 1) * n5 + n4;
        int n7 = _numUPX.getValue(this._infoShort3);
        this._upxs = new UPX[n7];
        for (int i = 0; i < n7; ++i) {
            short s2 = LittleEndian.getShort(byArray, n6);
            byte[] byArray2 = new byte[s2];
            System.arraycopy(byArray, n6 += 2, byArray2, 0, s2);
            this._upxs[i] = new UPX(byArray2);
            n6 += s2;
            if (s2 % 2 != 1) continue;
            ++n6;
        }
    }

    public int getBaseStyle() {
        return _baseStyle.getValue(this._infoShort2);
    }

    public byte[] getCHPX() {
        switch (_styleTypeCode.getValue(this._infoShort2)) {
            case 1: {
                if (this._upxs.length > 1) {
                    return this._upxs[1].getUPX();
                }
                return null;
            }
            case 2: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public byte[] getPAPX() {
        switch (_styleTypeCode.getValue(this._infoShort2)) {
            case 1: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public ParagraphProperties getPAP() {
        return this._pap;
    }

    public CharacterProperties getCHP() {
        return this._chp;
    }

    void setPAP(ParagraphProperties paragraphProperties) {
        this._pap = paragraphProperties;
    }

    void setCHP(CharacterProperties characterProperties) {
        this._chp = characterProperties;
    }

    public byte[] toByteArray() {
        int n;
        int n2 = this._baseLength + 2 + (this._name.length() + 1) * 2;
        n2 += this._upxs[0].size() + 2;
        for (int i = 1; i < this._upxs.length; ++i) {
            n2 += this._upxs[i - 1].size() % 2;
            n2 += this._upxs[i].size() + 2;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        LittleEndian.putShort(byArray, n3, this._infoShort);
        LittleEndian.putShort(byArray, n3 += 2, this._infoShort2);
        LittleEndian.putShort(byArray, n3 += 2, this._infoShort3);
        LittleEndian.putShort(byArray, n3 += 2, this._bchUpe);
        LittleEndian.putShort(byArray, n3 += 2, this._infoShort4);
        n3 = this._baseLength;
        char[] cArray = this._name.toCharArray();
        LittleEndian.putShort(byArray, this._baseLength, (short)cArray.length);
        n3 += 2;
        for (n = 0; n < cArray.length; ++n) {
            LittleEndian.putShort(byArray, n3, (short)cArray[n]);
            n3 += 2;
        }
        n3 += 2;
        for (n = 0; n < this._upxs.length; ++n) {
            short s = (short)this._upxs[n].size();
            LittleEndian.putShort(byArray, n3, s);
            System.arraycopy(this._upxs[n].getUPX(), 0, byArray, n3 += 2, s);
            n3 += s + s % 2;
        }
        return byArray;
    }

    public boolean equals(Object object) {
        StyleDescription styleDescription = (StyleDescription)object;
        if (styleDescription._infoShort == this._infoShort && styleDescription._infoShort2 == this._infoShort2 && styleDescription._infoShort3 == this._infoShort3 && styleDescription._bchUpe == this._bchUpe && styleDescription._infoShort4 == this._infoShort4 && this._name.equals(styleDescription._name)) {
            return Arrays.equals(this._upxs, styleDescription._upxs);
        }
        return false;
    }
}

