/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

public class CpuTimes {
    private final long userMillis;
    private final long systemMillis;
    private final long idleMillis;

    public CpuTimes(long userMillis, long systemMillis, long idleMillis) {
        this.userMillis = userMillis;
        this.systemMillis = systemMillis;
        this.idleMillis = idleMillis;
    }

    public long getUserMillis() {
        return this.userMillis;
    }

    public long getSystemMillis() {
        return this.systemMillis;
    }

    public long getIdleMillis() {
        return this.idleMillis;
    }

    public long getTotalMillis() {
        return this.userMillis + this.systemMillis + this.idleMillis;
    }

    public float getCpuUsage(CpuTimes previous) {
        if (this.getIdleMillis() == previous.getIdleMillis()) {
            return 1.0f;
        }
        return 1.0f - (float)(this.getIdleMillis() - previous.getIdleMillis()) / (float)(this.getTotalMillis() - previous.getTotalMillis());
    }
}

