/* radare - LGPL - Copyright 2009-2010 pancake<@nopcode.org> */

/* This vapi has been manually generated by me */
[Compact]
[CCode (cheader_filename="r_hash.h", cprefix="r_hash_", cname="struct r_hash_t", free_function="r_hash_free")]
public class Radare.RHash {
	[CCode (cprefix="R_HASH_")]
	[Flags]
	public enum Algorithm {
		ALL = 0,
		MD5 = 1,
		SHA1 = 2,
		SHA256 = 4,
		SHA384 = 8,
		SHA512 = 16,
	}

	[CCode (cprefix="R_HASH_SIZE_", cname="int")]
	public enum Size {
		MD4 = 16,
		MD5 = 16,
		SHA1 = 16,
		SHA256 = 32,
		SHA384 = 64,
		SHA512 = 64,
	}
	public RHash(bool rst, int bits);

	/* checksum */
	public static uint16 crc16(uint16 crc, uint8 *buf, uint64 len);
	public static uint32 crc32(uint8 *buf, uint64 len);
	public static uint16 xor(uint8 *buf, uint64 len);
	public static uint32 xorpair(uint8 *buf, uint64 len);
	public static uint8 parity(uint8 *buf, uint64 len);
	public static uint8 mod255(uint8 *buf, uint64 len);

	/* analitics */
	public static uint8 hamdist(uint8 *buf, uint64 len);
	public static double entropy(uint8 *buf, uint64 len);
	public static int pcprint(uint8 *buf, uint64 len);

	/* methods */
	//public RHash(bool rst);
	public uint8 *do_md4(uint8 *input, uint32 len);
	public uint8 *do_md5(uint8 *input, uint32 len);
	public uint8 *do_sha1(uint8 *input, uint32 len);
	public uint8 *do_sha256(uint8 *input, uint32 len);
	public uint8 *do_sha384(uint8 *input, uint32 len);
	public uint8 *do_sha512(uint8 *input, uint32 len);
}
