/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.common.Topic$;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StateChangeLogMerger$
implements Logging {
    public static final StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        StateChangeLogMerger$ stateChangeLogMerger$ = this;
        synchronized (stateChangeLogMerger$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> x$1) {
        this.files = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> x$1) {
        this.partitions = x$1;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date x$1) {
        this.startDate = x$1;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date x$1) {
        this.endDate = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"start timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"0000-00-00 00:00:00,000", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"end timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"9999-12-31 23:59:59,999", (Object[])new String[0]);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool for merging the log files from several brokers to reconnstruct a unified history of what happened.");
        }
        if (!(options = parser.parse(args)).has((OptionSpec)filesOpt) && !options.has((OptionSpec)regexOpt) || options.has((OptionSpec)filesOpt) && options.has((OptionSpec)regexOpt)) {
            System.err.println(new StringBuilder().append((Object)"Provide arguments to exactly one of the two options \"").append((Object)filesOpt).append((Object)"\" or \"").append((Object)regexOpt).append((Object)"\"").toString());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (options.has((OptionSpec)partitionsOpt) && !options.has((OptionSpec)topicOpt)) {
            System.err.println(new StringBuilder().append((Object)"The option \"").append((Object)topicOpt).append((Object)"\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (options.has((OptionSpec)filesOpt)) {
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)filesOpt)).split(",")).toList()));
        } else if (options.has((OptionSpec)regexOpt)) {
            String regex = (String)options.valueOf((OptionSpec)regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex = new Regex(regex.substring(fileNameIndex), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dirName).listFiles()).filter((Function1)new Serializable(fileNameRegex){
                public static final long serialVersionUID = 0L;
                private final Regex fileNameRegex$1;

                public final boolean apply(File f) {
                    Option option = this.fileNameRegex$1.findFirstIn((CharSequence)f.getName());
                    None$ none$ = None$.MODULE$;
                    return option != null ? !option.equals(none$) : none$ != null;
                }
                {
                    this.fileNameRegex$1 = fileNameRegex$1;
                }
            })).map((Function1)new Serializable(dirName){
                public static final long serialVersionUID = 0L;
                private final String dirName$1;

                public final String apply(File x$1) {
                    return new StringBuilder().append((Object)this.dirName$1).append((Object)"/").append((Object)x$1.getName()).toString();
                }
                {
                    this.dirName$1 = dirName$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList()));
        }
        if (options.has((OptionSpec)topicOpt)) {
            this.topic_$eq((String)options.valueOf((OptionSpec)topicOpt));
        }
        if (options.has((OptionSpec)partitionsOpt)) {
            this.partitions_$eq((List<Object>)((List)Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)partitionsOpt)).split(",")).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                }
            }, List$.MODULE$.canBuildFrom())));
            Iterable<Object> duplicatePartitions = Utils$.MODULE$.duplicates(this.partitions());
            if (duplicatePartitions.nonEmpty()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("The list of partitions contains repeated entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                System.exit(1);
            }
        }
        this.startDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)startTimeOpt)).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)endTimeOpt)).replace('\"', ' ').trim()));
        PriorityQueue pqueue = new PriorityQueue((Ordering)StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output = new BufferedOutputStream(System.out, 0x100000);
        List lineIterators = (List)this.files().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<String> apply(String x$3) {
                return Source$.MODULE$.fromFile(x$3, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            }
        }, List$.MODULE$.canBuildFrom());
        ObjectRef lines = new ObjectRef((Object)Nil$.MODULE$);
        lineIterators.foreach((Function1)new Serializable(lines){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lines$1;

            public final void apply(Iterator<String> itr) {
                StateChangeLogMerger.LineIterator lineItr = StateChangeLogMerger$.MODULE$.getNextLine(itr);
                if (!lineItr.isEmpty()) {
                    this.lines$1.elem = ((List)this.lines$1.elem).$colon$colon((Object)lineItr);
                }
            }
            {
                this.lines$1 = lines$1;
            }
        });
        if (!((List)lines.elem).isEmpty()) {
            pqueue.enqueue((Seq)((List)lines.elem));
        }
        while (true) {
            void var16_16;
            void var15_15;
            if (pqueue.isEmpty()) {
                ((OutputStream)output).flush();
                return;
            }
            StateChangeLogMerger.LineIterator lineItr = (StateChangeLogMerger.LineIterator)var15_15.dequeue();
            var16_16.write(new StringBuilder().append((Object)lineItr.line()).append((Object)"\n").toString().getBytes());
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            var15_15.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        while (itr != null && itr.hasNext()) {
            BoxedUnit boxedUnit;
            Option option;
            block5: {
                BoxedUnit boxedUnit2;
                block11: {
                    block6: {
                        block10: {
                            BoxedUnit boxedUnit3;
                            Option option2;
                            block7: {
                                block9: {
                                    Regex.Match matcher;
                                    String nextLine;
                                    block8: {
                                        nextLine = (String)itr.next();
                                        option = this.dateRegex().findFirstIn((CharSequence)nextLine);
                                        if (!(option instanceof Some)) break block5;
                                        Some some = (Some)option;
                                        String d = (String)some.x();
                                        Date date = this.dateFormat().parse(d);
                                        if (!date.equals(this.startDate()) && !date.after(this.startDate()) || !date.equals(this.endDate()) && !date.before(this.endDate())) break block6;
                                        option2 = this.topicPartitionRegex().findFirstMatchIn((CharSequence)nextLine);
                                        if (!(option2 instanceof Some)) break block7;
                                        Some some2 = (Some)option2;
                                        matcher = (Regex.Match)some2.x();
                                        if (this.topic() == null) break block8;
                                        String string = this.topic();
                                        String string2 = matcher.group(1);
                                        if (string != null ? !string.equals(string2) : string2 != null) break block9;
                                    }
                                    if (this.partitions().isEmpty() || this.partitions().contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt()))) {
                                        return new StateChangeLogMerger.LineIterator(nextLine, itr);
                                    }
                                }
                                boxedUnit3 = BoxedUnit.UNIT;
                                break block10;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                        break block11;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            None$ none$ = None$.MODULE$;
            Option option4 = option;
            if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError((Object)option);
            boxedUnit = BoxedUnit.UNIT;
        }
        return new StateChangeLogMerger.LineIterator();
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex(new StringBuilder().append((Object)"\\[(").append((Object)Topic$.MODULE$.legalChars()).append((Object)"+),( )*([0-9]+)\\]").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.topic = null;
        this.partitions = Nil$.MODULE$;
        this.startDate = null;
        this.endDate = null;
    }
}

