/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u0017\u0013\u0011%q#\u0001\u0004de\u0016\fG/\u001a\u000b\u00051\u0001b\u0013\u0007\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005\u0019a.[8\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u0011\u0016\u0001\u0004\u0011\u0013!D8gMN,GoQ8v]R,'\u000f\u0005\u0002$U5\tAE\u0003\u0002&M\u00051\u0011\r^8nS\u000eT!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002*9\u0005!Q\u000f^5m\u0013\tYCE\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDQ!L\u000bA\u00029\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005!y\u0013B\u0001\u0019\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u00033+\u0001\u00071'\u0001\u0005nKN\u001c\u0018mZ3t!\riAGN\u0005\u0003k9\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tAq'\u0003\u00029\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002\u001e\n\t\u0003Y\u0014A\u00033fG>l\u0007O]3tgR\u0019A(!!\u0011\u0005!id\u0001\u0002\u0006\u0003\u0001y\u001a2!P C!\tA\u0001)\u0003\u0002B\u0005\tQQ*Z:tC\u001e,7+\u001a;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011!B;uS2\u001c\u0018BA$E\u0005\u001daunZ4j]\u001eD\u0001\"S\u001f\u0003\u0006\u0004%\tAS\u0001\u0007EV4g-\u001a:\u0016\u0003aA\u0001\u0002T\u001f\u0003\u0002\u0003\u0006I\u0001G\u0001\bEV4g-\u001a:!\u0011\u0015\u0019R\b\"\u0001O)\tat\nC\u0003J\u001b\u0002\u0007\u0001\u0004C\u0004R{\u0001\u0007I\u0011\u0002*\u0002+MD\u0017\r\u001c7poZ\u000bG.\u001b3CsR,7i\\;oiV\t1\u000b\u0005\u0002\u000e)&\u0011QK\u0004\u0002\u0004\u0013:$\bbB,>\u0001\u0004%I\u0001W\u0001\u001ag\"\fG\u000e\\8x-\u0006d\u0017\u000e\u001a\"zi\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011QBW\u0005\u00037:\u0011A!\u00168ji\"9QLVA\u0001\u0002\u0004\u0019\u0016a\u0001=%c!1q,\u0010Q!\nM\u000bac\u001d5bY2|wOV1mS\u0012\u0014\u0015\u0010^3D_VtG\u000f\t\u0005\u0006'u\"\t!\u0019\u000b\u0004y\t\u001c\u0007\"B\u0017a\u0001\u0004q\u0003\"\u0002\u001aa\u0001\u0004\u0019\u0004\"B\n>\t\u0003)G\u0003\u0002\u001fgO\"DQ!\f3A\u00029BQ!\t3A\u0002\tBQA\r3A\u0002MBQaE\u001f\u0005\u0002)$\"\u0001P6\t\u000bIJ\u0007\u0019A\u001a\t\u000b5lD\u0011\u0001&\u0002\u0013\u001d,GOQ;gM\u0016\u0014\b\"B8>\t\u0013\u0011\u0016!E:iC2dwn\u001e,bY&$')\u001f;fg\")\u0011/\u0010C\u0001e\u00069qO]5uKR{G#B*tw\u0006\u0005\u0001\"\u0002;q\u0001\u0004)\u0018aB2iC:tW\r\u001c\t\u0003mfl\u0011a\u001e\u0006\u0003qj\t\u0001b\u00195b]:,Gn]\u0005\u0003u^\u0014AcR1uQ\u0016\u0014\u0018N\\4CsR,7\t[1o]\u0016d\u0007\"\u0002?q\u0001\u0004i\u0018AB8gMN,G\u000f\u0005\u0002\u000e}&\u0011qP\u0004\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u0004A\u0004\raU\u0001\u0005g&TX\rC\u0004\u0002\bu\"\t%!\u0003\u0002\u0011%$XM]1u_J,\"!a\u0003\u0011\r\u00055\u0011QDA\u0012\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\u0019a$o\\8u}%\tq\"C\u0002\u0002\u001c9\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005ma\u0002E\u0002\t\u0003KI1!a\n\u0003\u0005AiUm]:bO\u0016\fe\u000eZ(gMN,G\u000fC\u0004\u0002,u\"\t!!\u0003\u0002\u001fMD\u0017\r\u001c7po&#XM]1u_JDq!a\f>\t\u0013\t\t$\u0001\tj]R,'O\\1m\u0013R,'/\u0019;peR!\u00111BA\u001a\u0011)\t)$!\f\u0011\u0002\u0003\u0007\u0011qG\u0001\nSN\u001c\u0006.\u00197m_^\u00042!DA\u001d\u0013\r\tYD\u0004\u0002\b\u0005>|G.Z1o\u0011!\ty$\u0010C\u0001\t\u0005\u0005\u0013!D1tg&<gn\u00144gg\u0016$8\u000fF\u0003=\u0003\u0007\n)\u0005\u0003\u0004\"\u0003{\u0001\rA\t\u0005\b\u0003\u000f\ni\u00041\u0001/\u0003\u0015\u0019w\u000eZ3d\u0011\u0019\tY%\u0010C\u0001%\u0006Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u0019\ty%\u0010C\u0001%\u0006Qa/\u00197jI\nKH/Z:\t\u000f\u0005MS\b\"\u0011\u0002V\u00051Q-];bYN$B!a\u000e\u0002X!A\u0011\u0011LA)\u0001\u0004\tY&A\u0003pi\",'\u000fE\u0002\u000e\u0003;J1!a\u0018\u000f\u0005\r\te.\u001f\u0005\b\u0003GjD\u0011IA3\u0003!A\u0017m\u001d5D_\u0012,G#A*\t\u0013\u0005%T(%A\u0005\n\u0005-\u0014AG5oi\u0016\u0014h.\u00197Ji\u0016\u0014\u0018\r^8sI\u0011,g-Y;mi\u0012\nTCAA7U\u0011\t9$a\u001c,\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001f\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\n)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQaA\u001dA\u0002YB\u0001\"!\"\n\t\u0003!\u0011qQ\u0001\roJLG/Z'fgN\fw-\u001a\u000b\b3\u0006%\u00151RAG\u0011\u0019I\u00151\u0011a\u00011!11!a!A\u0002YBa\u0001`AB\u0001\u0004i\b")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static ByteBufferMessageSet decompress(Message message) {
        return ByteBufferMessageSet$.MODULE$.decompress(message);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int x$1) {
        this.shallowValidByteCount = x$1;
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            int bytes = 0;
            Iterator<MessageAndOffset> iter = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
            while (iter.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iter.next();
                bytes += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            this.shallowValidByteCount_$eq(bytes);
        }
        return this.shallowValidByteCount();
    }

    @Override
    public int writeTo(GatheringByteChannel channel, long offset, int size2) {
        int written;
        this.buffer().mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer())) {
        }
        this.buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(this.kafka$message$ByteBufferMessageSet$$internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
    }

    public Iterator<MessageAndOffset> kafka$message$ByteBufferMessageSet$$internalIterator(boolean isShallow) {
        return new IteratorTemplate<MessageAndOffset>(this, isShallow){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer x$1) {
                this.topIter = x$1;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> x$1) {
                this.innerIter = x$1;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long offset = this.topIter().getLong();
                int size2 = this.topIter().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append((Object)BoxesRunTime.boxToInteger((int)size2)).append((Object)")").toString());
                }
                if (this.topIter().remaining() < size2) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.topIter().slice();
                message.limit(size2);
                this.topIter().position(this.topIter().position() + size2);
                Message newMessage = new Message(message);
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                } else {
                    MessageAndOffset messageAndOffset2;
                    CompressionCodec compressionCodec = newMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset2 = new MessageAndOffset(newMessage, offset);
                    } else {
                        ByteBufferMessageSet qual$1 = ByteBufferMessageSet$.MODULE$.decompress(newMessage);
                        boolean x$3 = qual$1.kafka$message$ByteBufferMessageSet$$internalIterator$default$1();
                        this.innerIter_$eq(qual$1.kafka$message$ByteBufferMessageSet$$internalIterator(x$3));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset2 = this.makeNext();
                    }
                    messageAndOffset = messageAndOffset2;
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : (MessageAndOffset)this.innerIter().next());
            }
            {
                this.isShallow$1 = isShallow$1;
                this.topIter = $outer.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    public boolean kafka$message$ByteBufferMessageSet$$internalIterator$default$1() {
        return false;
    }

    public ByteBufferMessageSet assignOffsets(AtomicLong offsetCounter, CompressionCodec codec) {
        ByteBufferMessageSet byteBufferMessageSet;
        CompressionCodec compressionCodec = codec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            this.buffer().mark();
            for (int position = 0; position < this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead(); position += MessageSet$.MODULE$.LogOverhead() + this.buffer().getInt()) {
                this.buffer().position(position);
                this.buffer().putLong(offsetCounter.getAndIncrement());
            }
            this.buffer().reset();
            byteBufferMessageSet = this;
        } else {
            Iterator messages = this.kafka$message$ByteBufferMessageSet$$internalIterator(false).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Message apply(MessageAndOffset x$2) {
                    return x$2.message();
                }
            });
            byteBufferMessageSet = new ByteBufferMessageSet(codec, offsetCounter, (Seq<Message>)messages.toBuffer());
        }
        return byteBufferMessageSet;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ByteBufferMessageSet) {
            ByteBufferMessageSet byteBufferMessageSet = (ByteBufferMessageSet)object;
            bl = this.buffer().equals(byteBufferMessageSet.buffer());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer) {
        this.buffer = buffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new AtomicLong(0L), compressionCodec, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, AtomicLong offsetCounter, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(offsetCounter, compressionCodec, messages));
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, new AtomicLong(0L), messages);
    }
}

