/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;

public abstract class ResourceException
extends IOException {
    public abstract RaiseException newRaiseException(Ruby var1);

    static class IOError
    extends ResourceException {
        private final IOException ioe;

        IOError(IOException ioe) {
            this.ioe = ioe;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime) {
            return runtime.newIOErrorFromException(this.ioe);
        }
    }

    static class PermissionDenied
    extends ErrnoException {
        public PermissionDenied(String path2) {
            super("EACCES", path2);
        }
    }

    static class NotFound
    extends ErrnoException {
        public NotFound(String path2) {
            super("ENOENT", path2);
        }
    }

    static class FileExists
    extends ErrnoException {
        public FileExists(String path2) {
            super("EEXIST", path2);
        }
    }

    static class FileIsDirectory
    extends ErrnoException {
        public FileIsDirectory(String path2) {
            super("EISDIR", path2);
        }
    }

    static abstract class ErrnoException
    extends ResourceException {
        private final String path;
        private final String errnoClass;

        protected ErrnoException(String errnoClass, String path2) {
            this.errnoClass = errnoClass;
            this.path = path2;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime) {
            return runtime.newRaiseException(runtime.getErrno().getClass(this.errnoClass), this.path);
        }
    }
}

