/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class IfNode
extends Node {
    private final Node condition;
    private final Node thenBody;
    private final Node elseBody;

    public IfNode(ISourcePosition position, Node condition, Node thenBody, Node elseBody) {
        super(position);
        assert (condition != null) : "condition is not null";
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.IFNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.condition, this.thenBody, this.elseBody);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        ISourcePosition position = this.getPosition();
        context.setFileAndLine(position.getFile(), position.getStartLine());
        IRubyObject result2 = this.condition.interpret(runtime, context, self2, aBlock);
        if (result2.isTrue()) {
            return this.thenBody == null ? runtime.getNil() : this.thenBody.interpret(runtime, context, self2, aBlock);
        }
        return this.elseBody == null ? runtime.getNil() : this.elseBody.interpret(runtime, context, self2, aBlock);
    }
}

