/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.verifytest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.sdk.verifytest.TestPermutation;

public class VerifiedTest {
    private String testClass;
    private String testName;
    private Map<String, TestPermutation> permutationsByKey = new HashMap<String, TestPermutation>();
    private List<TestPermutation> unkeyedPermutations = new ArrayList<TestPermutation>();

    public VerifiedTest(String testClass, String testName) {
        this.testName = testName;
        this.testClass = testClass;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public boolean hasGroups() {
        Collection<TestPermutation> permutations = this.getPermutations();
        return permutations != null && permutations.size() > 0 && permutations.iterator().next().getGroup() != null;
    }

    public Set<String> getGroups() {
        HashSet<String> returnSet = new HashSet<String>();
        for (TestPermutation permutation : this.getPermutations()) {
            if (permutation.getGroup() == null) continue;
            returnSet.add(permutation.getGroup());
        }
        return returnSet;
    }

    public String getTestName() {
        return this.testName;
    }

    public Collection<TestPermutation> getPermutations() {
        ArrayList<TestPermutation> returnList = new ArrayList<TestPermutation>();
        returnList.addAll(this.permutationsByKey.values());
        returnList.addAll(this.unkeyedPermutations);
        return Collections.unmodifiableCollection(returnList);
    }

    public TestPermutation getPermutation(String key) {
        if (!this.permutationsByKey.containsKey(key)) {
            this.rebuildPermutationsByKey();
        }
        return this.permutationsByKey.get(key);
    }

    public TestPermutation addPermutation(TestPermutation permutation) {
        String key = permutation.getKey();
        if (key.equals("")) {
            this.unkeyedPermutations.add(permutation);
        } else {
            this.permutationsByKey.put(key, permutation);
        }
        return permutation;
    }

    public void replacePermutation(TestPermutation permutation) {
        this.removePermutation(permutation.getKey());
        this.addPermutation(permutation);
    }

    public void removePermutation(String key) {
        TestPermutation permutation = this.getPermutation(key);
        if (permutation != null) {
            this.permutationsByKey.remove(permutation.getKey());
        }
    }

    private void rebuildPermutationsByKey() {
        ArrayList<TestPermutation> newUnkeyed = new ArrayList<TestPermutation>();
        for (TestPermutation permutation : this.unkeyedPermutations) {
            if (permutation.getKey().equals("")) {
                newUnkeyed.add(permutation);
                continue;
            }
            this.permutationsByKey.put(permutation.getKey(), permutation);
        }
        this.unkeyedPermutations = newUnkeyed;
    }
}

