/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.logging.LogFactory;
import liquibase.precondition.ErrorPrecondition;
import liquibase.precondition.FailedPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.util.StringUtils;

public class ValidatingVisitor
implements ChangeSetVisitor {
    private List<ChangeSet> invalidMD5Sums = new ArrayList<ChangeSet>();
    private List<FailedPrecondition> failedPreconditions = new ArrayList<FailedPrecondition>();
    private List<ErrorPrecondition> errorPreconditions = new ArrayList<ErrorPrecondition>();
    private Set<ChangeSet> duplicateChangeSets = new HashSet<ChangeSet>();
    private List<SetupException> setupExceptions = new ArrayList<SetupException>();
    private List<Throwable> changeValidationExceptions = new ArrayList<Throwable>();
    private ValidationErrors validationErrors = new ValidationErrors();
    private Warnings warnings = new Warnings();
    private Set<String> seenChangeSets = new HashSet<String>();
    private Map<String, RanChangeSet> ranIndex = new HashMap<String, RanChangeSet>();
    private Database database;

    public ValidatingVisitor(List<RanChangeSet> ranChangeSets) {
        for (RanChangeSet changeSet : ranChangeSets) {
            this.ranIndex.put(changeSet.toString(), changeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Database database, DatabaseChangeLog changeLog) {
        this.database = database;
        PreconditionContainer preconditions = changeLog.getPreconditions();
        try {
            if (preconditions == null) {
                return;
            }
            preconditions.check(database, changeLog, null);
        }
        catch (PreconditionFailedException e) {
            LogFactory.getLogger().debug("Precondition Failed: " + e.getMessage(), e);
            this.failedPreconditions.addAll(e.getFailedPreconditions());
        }
        catch (PreconditionErrorException e) {
            LogFactory.getLogger().debug("Precondition Error: " + e.getMessage(), e);
            this.errorPreconditions.addAll(e.getErrorPreconditions());
        }
        finally {
            try {
                if (database.getConnection() != null) {
                    database.rollback();
                }
            }
            catch (DatabaseException e) {
                LogFactory.getLogger().warning("Error rolling back after precondition check", e);
            }
        }
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    private RanChangeSet findChangeSet(ChangeSet changeSet) {
        RanChangeSet result = this.ranIndex.get(changeSet.toString(false));
        if (result == null) {
            for (RanChangeSet ranChangeSet : this.ranIndex.values()) {
                if (!ranChangeSet.getId().equalsIgnoreCase(changeSet.getId()) || !ranChangeSet.getAuthor().equalsIgnoreCase(changeSet.getAuthor())) continue;
                String changeSetPath = this.normalizePath(changeSet.getFilePath());
                String ranChangeSetPath = this.normalizePath(ranChangeSet.getChangeLog());
                if (!ranChangeSetPath.equalsIgnoreCase(changeSetPath) && !ranChangeSetPath.endsWith(changeSetPath) && !changeSetPath.endsWith(ranChangeSetPath)) continue;
                result = ranChangeSet;
            }
        }
        return result;
    }

    private String normalizePath(String filePath) {
        return filePath.replaceFirst("^classpath:", "");
    }

    @Override
    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        String changeSetString;
        RanChangeSet ranChangeSet = this.findChangeSet(changeSet);
        boolean ran = ranChangeSet != null;
        boolean shouldValidate = !ran || changeSet.shouldRunOnChange() || changeSet.shouldAlwaysRun();
        for (Change change : changeSet.getChanges()) {
            try {
                change.finishInitialization();
            }
            catch (SetupException se) {
                this.setupExceptions.add(se);
            }
            if (!shouldValidate) continue;
            this.warnings.addAll(change.warn(database));
            try {
                ValidationErrors foundErrors = change.validate(database);
                if (foundErrors == null || !foundErrors.hasErrors()) continue;
                if (changeSet.getOnValidationFail().equals((Object)ChangeSet.ValidationFailOption.MARK_RAN)) {
                    LogFactory.getLogger().info("Skipping changeSet " + changeSet + " due to validation error(s): " + StringUtils.join(foundErrors.getErrorMessages(), ", "));
                    changeSet.setValidationFailed(true);
                    continue;
                }
                this.validationErrors.addAll(foundErrors, changeSet);
            }
            catch (Throwable e) {
                this.changeValidationExceptions.add(e);
            }
        }
        if (ranChangeSet != null && !changeSet.isCheckSumValid(ranChangeSet.getLastCheckSum()) && !changeSet.shouldRunOnChange()) {
            this.invalidMD5Sums.add(changeSet);
        }
        if (this.seenChangeSets.contains(changeSetString = changeSet.toString(false))) {
            this.duplicateChangeSets.add(changeSet);
        } else {
            this.seenChangeSets.add(changeSetString);
        }
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public List<FailedPrecondition> getFailedPreconditions() {
        return this.failedPreconditions;
    }

    public List<ErrorPrecondition> getErrorPreconditions() {
        return this.errorPreconditions;
    }

    public Set<ChangeSet> getDuplicateChangeSets() {
        return this.duplicateChangeSets;
    }

    public List<SetupException> getSetupExceptions() {
        return this.setupExceptions;
    }

    public List<Throwable> getChangeValidationExceptions() {
        return this.changeValidationExceptions;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public boolean validationPassed() {
        return this.invalidMD5Sums.size() == 0 && this.failedPreconditions.size() == 0 && this.errorPreconditions.size() == 0 && this.duplicateChangeSets.size() == 0 && this.changeValidationExceptions.size() == 0 && this.setupExceptions.size() == 0 && !this.validationErrors.hasErrors();
    }

    public Database getDatabase() {
        return this.database;
    }
}

