/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.uno.UnoRuntime;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public final class ThreadId {
    private static final String PREFIX = "java:" + UnoRuntime.getUniqueKey() + ":";
    private static BigInteger count = BigInteger.ZERO;
    private final byte[] id;
    private int hash = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadId createFresh() {
        BigInteger bigInteger;
        String string = PREFIX;
        synchronized (string) {
            bigInteger = count;
            count = count.add(BigInteger.ONE);
        }
        try {
            return new ThreadId((PREFIX + bigInteger).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("this cannot happen: " + unsupportedEncodingException);
        }
    }

    public ThreadId(byte[] byArray) {
        this.id = byArray;
    }

    public boolean equals(Object object) {
        return object instanceof ThreadId && Arrays.equals(this.id, ((ThreadId)object).id);
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = 1;
            for (int i = 0; i < this.id.length; ++i) {
                n = 31 * n + this.id[i];
            }
            this.hash = n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ThreadId:");
        for (int i = 0; i < this.id.length; ++i) {
            String string = Integer.toHexString(this.id[i] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public byte[] getBytes() {
        return this.id;
    }
}

