/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3g;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.postgresql.jdbc3g.AbstractJdbc3gConnection;
import org.postgresql.jdbc3g.Jdbc3gCallableStatement;
import org.postgresql.jdbc3g.Jdbc3gDatabaseMetaData;
import org.postgresql.jdbc3g.Jdbc3gPreparedStatement;
import org.postgresql.jdbc3g.Jdbc3gStatement;
import org.postgresql.util.HostSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdbc3gConnection
extends AbstractJdbc3gConnection
implements Connection {
    public Jdbc3gConnection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        super(hostSpecs, user, database, info, url);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        Jdbc3gStatement s = new Jdbc3gStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        s.setPrepareThreshold(this.getPrepareThreshold());
        return s;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        Jdbc3gPreparedStatement s = new Jdbc3gPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        s.setPrepareThreshold(this.getPrepareThreshold());
        return s;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        Jdbc3gCallableStatement s = new Jdbc3gCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        s.setPrepareThreshold(this.getPrepareThreshold());
        return s;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new Jdbc3gDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.setTypeMapImpl(map);
    }
}

