/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.jcs.utils.struct.SingleLinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDisk {
    private static final Log log = LogFactory.getLog(BlockDisk.class);
    public static final byte HEADER_SIZE_BYTES = 4;
    private static final int DEFAULT_BLOCK_SIZE_BYTES = 4096;
    private final int blockSizeBytes;
    private final AtomicInteger numberOfBlocks = new AtomicInteger(0);
    private final SingleLinkedList<Integer> emptyBlocks = new SingleLinkedList();
    private final IElementSerializer elementSerializer;
    private final String filepath;
    private final FileChannel fc;
    private final AtomicLong putBytes = new AtomicLong(0L);
    private final AtomicLong putCount = new AtomicLong(0L);

    public BlockDisk(File file, IElementSerializer iElementSerializer) throws IOException {
        this(file, 4096, iElementSerializer);
    }

    public BlockDisk(File file, int n) throws IOException {
        this(file, n, new StandardSerializer());
    }

    public BlockDisk(File file, int n, IElementSerializer iElementSerializer) throws IOException {
        this.filepath = file.getAbsolutePath();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.filepath, "rw");
        this.fc = randomAccessFile.getChannel();
        this.numberOfBlocks.set((int)Math.ceil(1.0f * (float)this.fc.size() / (float)n));
        if (log.isInfoEnabled()) {
            log.info("Constructing BlockDisk, blockSizeBytes [" + n + "]");
        }
        this.blockSizeBytes = n;
        this.elementSerializer = iElementSerializer;
    }

    private int[] allocateBlocks(int n) {
        assert (n >= 1);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = this.emptyBlocks.takeFirst();
            if (n2 == null) {
                n2 = this.numberOfBlocks.getAndIncrement();
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    protected int[] write(Serializable serializable) throws IOException {
        byte[] byArray = this.elementSerializer.serialize(serializable);
        if (log.isDebugEnabled()) {
            log.debug("write, total pre-chunking data.length = " + byArray.length);
        }
        this.putBytes.addAndGet(byArray.length);
        this.putCount.incrementAndGet();
        int n = this.calculateTheNumberOfBlocksNeeded(byArray);
        if (log.isDebugEnabled()) {
            log.debug("numBlocksNeeded = " + n);
        }
        int[] nArray = this.allocateBlocks(n);
        int n2 = 0;
        int n3 = this.blockSizeBytes - 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < n; ++i) {
            byteBuffer.clear();
            int n4 = Math.min(n3, byArray.length - n2);
            byteBuffer.putInt(n4);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, n2, n4);
            long l = this.calculateByteOffsetForBlockAsLong(nArray[i]);
            byteBuffer.flip();
            int n5 = this.fc.write(byteBuffer, l);
            assert (n5 == 4);
            n5 = this.fc.write(byteBuffer2, l + 4L);
            assert (n5 == n4);
            n2 += n4;
        }
        return nArray;
    }

    protected byte[][] getBlockChunks(byte[] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        if (n == 1) {
            byArrayArray[0] = byArray;
        } else {
            int n2 = this.blockSizeBytes - 4;
            int n3 = byArray.length;
            int n4 = 0;
            for (int n5 = 0; n5 < n; n5 = (int)((short)(n5 + 1))) {
                int n6 = Math.min(n2, n3 - n4);
                byte[] byArray2 = new byte[n6];
                System.arraycopy(byArray, n4, byArray2, 0, n6);
                byArrayArray[n5] = byArray2;
                n4 += n6;
            }
        }
        return byArrayArray;
    }

    protected <T extends Serializable> T read(int[] nArray) throws IOException, ClassNotFoundException {
        byte[] byArray = null;
        if (nArray.length == 1) {
            byArray = this.readBlock(nArray[0]);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.getBlockSizeBytes());
            for (int n = 0; n < nArray.length; n = (int)((short)(n + 1))) {
                byte[] byArray2 = this.readBlock(nArray[n]);
                byteArrayOutputStream.write(byArray2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("read, total post combination data.length = " + byArray.length);
        }
        return (T)((Serializable)this.elementSerializer.deSerialize(byArray, null));
    }

    private byte[] readBlock(int n) throws IOException {
        int n2 = 0;
        String string = null;
        boolean bl = false;
        long l = this.fc.size();
        long l2 = this.calculateByteOffsetForBlockAsLong(n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.fc.read(byteBuffer, l2);
        byteBuffer.flip();
        n2 = byteBuffer.getInt();
        if (l2 + (long)n2 > l) {
            bl = true;
            string = "Record " + l2 + " exceeds file length.";
        }
        if (bl) {
            log.warn("\n The file is corrupt: \n " + string);
            throw new IOException("The File Is Corrupt, need to reset");
        }
        byteBuffer = ByteBuffer.allocate(n2);
        this.fc.read(byteBuffer, l2 + 4L);
        byteBuffer.flip();
        return byteBuffer.array();
    }

    protected void freeBlocks(int[] nArray) {
        if (nArray != null) {
            for (int n = 0; n < nArray.length; n = (int)((short)(n + 1))) {
                this.emptyBlocks.addLast(nArray[n]);
            }
        }
    }

    @Deprecated
    protected int calculateByteOffsetForBlock(int n) {
        return n * this.blockSizeBytes;
    }

    protected long calculateByteOffsetForBlockAsLong(int n) {
        return (long)n * (long)this.blockSizeBytes;
    }

    protected int calculateTheNumberOfBlocksNeeded(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.blockSizeBytes - 4;
        if (n <= n2) {
            return 1;
        }
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    protected long length() throws IOException {
        return this.fc.size();
    }

    protected void close() throws IOException {
        this.fc.close();
    }

    protected synchronized void reset() throws IOException {
        this.numberOfBlocks.set(0);
        this.emptyBlocks.clear();
        this.fc.truncate(0L);
        this.fc.force(true);
    }

    protected int getNumberOfBlocks() {
        return this.numberOfBlocks.get();
    }

    protected int getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    protected long getAveragePutSizeBytes() {
        long l = this.putCount.get();
        if (l == 0L) {
            return 0L;
        }
        return this.putBytes.get() / l;
    }

    protected int getEmptyBlocks() {
        return this.emptyBlocks.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nBlock Disk ");
        stringBuilder.append("\n  Filepath [" + this.filepath + "]");
        stringBuilder.append("\n  NumberOfBlocks [" + this.numberOfBlocks.get() + "]");
        stringBuilder.append("\n  BlockSizeBytes [" + this.blockSizeBytes + "]");
        stringBuilder.append("\n  Put Bytes [" + this.putBytes + "]");
        stringBuilder.append("\n  Put Count [" + this.putCount + "]");
        stringBuilder.append("\n  Average Size [" + this.getAveragePutSizeBytes() + "]");
        stringBuilder.append("\n  Empty Blocks [" + this.getEmptyBlocks() + "]");
        try {
            stringBuilder.append("\n  Length [" + this.length() + "]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    protected String getFilePath() {
        return this.filepath;
    }
}

