/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.VerificationFailure;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class VerifyNodeRepositoryAction
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    public VerifyNodeRepositoryAction(Settings settings, TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService) {
        super(settings);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        transportService.registerRequestHandler(ACTION_NAME, VerifyNodeRepositoryRequest.class, "same", new VerifyNodeRepositoryRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler(ACTION_NAME);
    }

    public void verify(String repository, String verificationToken, final ActionListener<RepositoriesService.VerifyResponse> listener) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        DiscoveryNode localNode = discoNodes.localNode();
        ObjectContainer<DiscoveryNode> masterAndDataNodes = discoNodes.masterAndDataNodes().values();
        final ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (ObjectCursor cursor : masterAndDataNodes) {
            DiscoveryNode node = (DiscoveryNode)cursor.value;
            nodes.add(node);
        }
        final CopyOnWriteArrayList<VerificationFailure> errors = new CopyOnWriteArrayList<VerificationFailure>();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        for (final DiscoveryNode node : nodes) {
            if (node.equals(localNode)) {
                try {
                    this.doVerify(repository, verificationToken);
                }
                catch (Throwable t) {
                    this.logger.warn("[{}] failed to verify repository", t, repository);
                    errors.add(new VerificationFailure(node.id(), t));
                }
                if (counter.decrementAndGet() != 0) continue;
                this.finishVerification(listener, nodes, errors);
                continue;
            }
            this.transportService.sendRequest(node, ACTION_NAME, new VerifyNodeRepositoryRequest(repository, verificationToken), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    errors.add(new VerificationFailure(node.id(), exp));
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }
            });
        }
    }

    public void finishVerification(ActionListener<RepositoriesService.VerifyResponse> listener, List<DiscoveryNode> nodes, CopyOnWriteArrayList<VerificationFailure> errors) {
        listener.onResponse(new RepositoriesService.VerifyResponse(nodes.toArray(new DiscoveryNode[nodes.size()]), errors.toArray(new VerificationFailure[errors.size()])));
    }

    private void doVerify(String repository, String verificationToken) {
        IndexShardRepository blobStoreIndexShardRepository = this.repositoriesService.indexShardRepository(repository);
        blobStoreIndexShardRepository.verify(verificationToken);
    }

    class VerifyNodeRepositoryRequestHandler
    extends TransportRequestHandler<VerifyNodeRepositoryRequest> {
        VerifyNodeRepositoryRequestHandler() {
        }

        @Override
        public void messageReceived(VerifyNodeRepositoryRequest request, TransportChannel channel) throws Exception {
            try {
                VerifyNodeRepositoryAction.this.doVerify(request.repository, request.verificationToken);
            }
            catch (Exception ex) {
                VerifyNodeRepositoryAction.this.logger.warn("[{}] failed to verify repository", ex, request.repository);
                throw ex;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class VerifyNodeRepositoryRequest
    extends TransportRequest {
        private String repository;
        private String verificationToken;

        public VerifyNodeRepositoryRequest() {
        }

        VerifyNodeRepositoryRequest(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }
    }
}

