/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ProcessStats
implements Streamable,
ToXContent {
    long timestamp = -1L;
    long openFileDescriptors = -1L;
    long maxFileDescriptors = -1L;
    Cpu cpu = null;
    Mem mem = null;

    ProcessStats() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public long getMaxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.PROCESS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.field(Fields.OPEN_FILE_DESCRIPTORS, this.openFileDescriptors);
        builder.field(Fields.MAX_FILE_DESCRIPTORS, this.maxFileDescriptors);
        if (this.cpu != null) {
            builder.startObject(Fields.CPU);
            builder.field(Fields.PERCENT, (int)this.cpu.percent);
            builder.timeValueField(Fields.TOTAL_IN_MILLIS, Fields.TOTAL, this.cpu.total);
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.TOTAL_VIRTUAL_IN_BYTES, Fields.TOTAL_VIRTUAL, this.mem.totalVirtual);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ProcessStats readProcessStats(StreamInput in) throws IOException {
        ProcessStats stats = new ProcessStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.openFileDescriptors = in.readLong();
        this.maxFileDescriptors = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeLong(this.openFileDescriptors);
        out.writeLong(this.maxFileDescriptors);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable {
        short percent = (short)-1;
        long total = -1L;

        Cpu() {
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            out.writeLong(this.total);
        }

        public short getPercent() {
            return this.percent;
        }

        public TimeValue getTotal() {
            return new TimeValue(this.total);
        }
    }

    public static class Mem
    implements Streamable {
        long totalVirtual = -1L;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.totalVirtual = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalVirtual);
        }

        public ByteSizeValue getTotalVirtual() {
            return new ByteSizeValue(this.totalVirtual);
        }
    }

    static final class Fields {
        static final XContentBuilderString PROCESS = new XContentBuilderString("process");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString OPEN_FILE_DESCRIPTORS = new XContentBuilderString("open_file_descriptors");
        static final XContentBuilderString MAX_FILE_DESCRIPTORS = new XContentBuilderString("max_file_descriptors");
        static final XContentBuilderString CPU = new XContentBuilderString("cpu");
        static final XContentBuilderString PERCENT = new XContentBuilderString("percent");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_MILLIS = new XContentBuilderString("total_in_millis");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString TOTAL_VIRTUAL = new XContentBuilderString("total_virtual");
        static final XContentBuilderString TOTAL_VIRTUAL_IN_BYTES = new XContentBuilderString("total_virtual_in_bytes");

        Fields() {
        }
    }
}

