/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.morelikethis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.elasticsearch.action.termvectors.MultiTermVectorsItemResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.search.internal.SearchContext;

public class MoreLikeThisFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public MoreLikeThisFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public Fields[] fetch(List<MoreLikeThisQueryBuilder.Item> items) throws IOException {
        return MoreLikeThisFetchService.getFieldsFor(this.fetchResponse(items, SearchContext.current()));
    }

    public MultiTermVectorsResponse fetchResponse(List<MoreLikeThisQueryBuilder.Item> items, SearchContext searchContext) throws IOException {
        MultiTermVectorsRequest request = new MultiTermVectorsRequest();
        for (MoreLikeThisQueryBuilder.Item item : items) {
            request.add(item.toTermVectorsRequest());
        }
        request.copyContextAndHeadersFrom(searchContext);
        return this.client.multiTermVectors(request).actionGet();
    }

    public static Fields[] getFieldsFor(MultiTermVectorsResponse responses) throws IOException {
        ArrayList<Fields> likeFields = new ArrayList<Fields>();
        for (MultiTermVectorsItemResponse response : responses) {
            TermVectorsResponse getResponse;
            if (response.isFailed() || !(getResponse = response.getResponse()).isExists()) continue;
            likeFields.add(getResponse.getFields());
        }
        return likeFields.toArray(Fields.EMPTY_ARRAY);
    }
}

