/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;

public class ClusterName
implements Streamable {
    public static final String SETTING = "cluster.name";
    public static final ClusterName DEFAULT = new ClusterName("elasticsearch".intern());
    private String value;

    public static ClusterName clusterNameFromSettings(Settings settings) {
        return new ClusterName(settings.get(SETTING, DEFAULT.value()));
    }

    private ClusterName() {
    }

    public ClusterName(String value) {
        this.value = value.intern();
    }

    public String value() {
        return this.value;
    }

    public static ClusterName readClusterName(StreamInput in) throws IOException {
        ClusterName clusterName = new ClusterName();
        clusterName.readFrom(in);
        return clusterName;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.value = in.readString().intern();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterName that = (ClusterName)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "Cluster [" + this.value + "]";
    }
}

