/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChildTaskActionRequest;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeAction<Request extends MasterNodeRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private static final ClusterStateObserver.ChangePredicate masterNodeChangedPredicate = new ClusterStateObserver.ChangePredicate(){

        @Override
        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
            return newState.nodes().masterNodeId() != null && newState != previousState;
        }

        @Override
        public boolean apply(ClusterChangedEvent event) {
            return event.nodesDelta().masterNodeChanged();
        }
    };
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    final String executor;

    protected TransportMasterNodeAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.executor = this.executor();
    }

    protected abstract String executor();

    protected abstract Response newResponse();

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws Exception;

    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.masterOperation(request, state, listener);
    }

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        this.logger.warn("attempt to execute a master node operation without task", new Object[0]);
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, task, request, listener).start();
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private final Task task;
        private final ClusterStateObserver.ChangePredicate retryableOrNoBlockPredicate = new ClusterStateObserver.ValidationPredicate(){

            @Override
            protected boolean validate(ClusterState newState) {
                ClusterBlockException blockException = AsyncSingleAction.this.this$0.checkBlock(AsyncSingleAction.this.request, newState);
                return blockException == null || !blockException.retryable();
            }
        };
        final /* synthetic */ TransportMasterNodeAction this$0;

        AsyncSingleAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            if (task != null) {
                ((ChildTaskActionRequest)request).setParentTask(this$0.clusterService.localNode().getId(), task.getId());
            }
            if (!(listener instanceof ThreadedActionListener)) {
                listener = new ThreadedActionListener(((TransportMasterNodeAction)this$0).logger, ((TransportMasterNodeAction)this$0).threadPool, "listener", listener);
            }
            this.listener = listener;
        }

        public void start() {
            this.observer = new ClusterStateObserver(this.this$0.clusterService, ((MasterNodeRequest)this.request).masterNodeTimeout(), this.this$0.logger);
            this.doStart();
        }

        protected void doStart() {
            ClusterState clusterState = this.observer.observedState();
            final DiscoveryNodes nodes = clusterState.nodes();
            if (nodes.localNodeMaster() || this.this$0.localExecute(this.request)) {
                ClusterBlockException blockException = this.this$0.checkBlock(this.request, clusterState);
                if (blockException != null) {
                    if (!blockException.retryable()) {
                        this.listener.onFailure(blockException);
                    } else {
                        this.this$0.logger.trace("can't execute due to a cluster block, retrying", blockException, new Object[0]);
                        this.retry(blockException, this.retryableOrNoBlockPredicate);
                    }
                } else {
                    final ActionListener delegate = new ActionListener<Response>(){

                        @Override
                        public void onResponse(Response response) {
                            AsyncSingleAction.this.listener.onResponse(response);
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            if (t instanceof NotMasterException) {
                                AsyncSingleAction.this.this$0.logger.debug("master could not publish cluster state or stepped down before publishing action [{}], scheduling a retry", t, AsyncSingleAction.this.this$0.actionName);
                                AsyncSingleAction.this.retry(t, masterNodeChangedPredicate);
                            } else {
                                AsyncSingleAction.this.listener.onFailure(t);
                            }
                        }
                    };
                    this.this$0.taskManager.registerChildTask(this.task, nodes.getLocalNodeId());
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new ActionRunnable(delegate){

                        @Override
                        protected void doRun() throws Exception {
                            AsyncSingleAction.this.this$0.masterOperation(AsyncSingleAction.this.task, AsyncSingleAction.this.request, AsyncSingleAction.this.this$0.clusterService.state(), delegate);
                        }
                    });
                }
            } else if (nodes.masterNode() == null) {
                this.this$0.logger.debug("no known master node, scheduling a retry", new Object[0]);
                this.retry(null, masterNodeChangedPredicate);
            } else {
                this.this$0.taskManager.registerChildTask(this.task, nodes.masterNode().getId());
                this.this$0.transportService.sendRequest(nodes.masterNode(), this.this$0.actionName, (TransportRequest)this.request, new ActionListenerResponseHandler<Response>(this.listener){

                    @Override
                    public Response newInstance() {
                        return AsyncSingleAction.this.this$0.newResponse();
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException) {
                            AsyncSingleAction.this.this$0.logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", AsyncSingleAction.this.this$0.actionName, nodes.masterNode(), exp.getDetailedMessage());
                            AsyncSingleAction.this.retry(cause, masterNodeChangedPredicate);
                        } else {
                            AsyncSingleAction.this.listener.onFailure(exp);
                        }
                    }
                });
            }
        }

        private void retry(final Throwable failure, ClusterStateObserver.ChangePredicate changePredicate) {
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart();
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.this$0.logger.debug("timed out while retrying [{}] after failure (timeout [{}])", failure, AsyncSingleAction.this.this$0.actionName, timeout);
                    AsyncSingleAction.this.listener.onFailure(new MasterNotDiscoveredException(failure));
                }
            }, changePredicate);
        }
    }
}

