/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.put;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DelegatingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutIndexedScriptAction
extends HandledTransportAction<PutIndexedScriptRequest, PutIndexedScriptResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportPutIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/write/script/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutIndexedScriptRequest.class);
        this.scriptService = scriptService;
    }

    @Override
    protected void doExecute(PutIndexedScriptRequest request, ActionListener<PutIndexedScriptResponse> listener) {
        this.scriptService.putScriptToIndex(request, (ActionListener<IndexResponse>)new DelegatingActionListener<IndexResponse, PutIndexedScriptResponse>(listener){

            @Override
            public PutIndexedScriptResponse getDelegatedFromInstigator(IndexResponse indexResponse) {
                return new PutIndexedScriptResponse(indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.isCreated());
            }
        });
    }
}

