/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.WebResource;

public class StaticWebDeployableObjectAdapterUtil {
    private static final String[] extensionsToExclude = new String[]{"sql", "xmi"};
    static String INFO_DIRECTORY = "WEB-INF";
    static /* synthetic */ Class class$0;

    public static IModuleArtifact getModuleObject(Object obj) {
        IProject project;
        IResource resource = null;
        if (obj instanceof IResource) {
            resource = (IResource)obj;
            project = ProjectUtilities.getProject((Object)resource);
            if (project != null && !StaticWebDeployableObjectAdapterUtil.hasInterestedComponents(project)) {
                return null;
            }
        } else if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject) {
            project = (IProject)resource;
            if (StaticWebDeployableObjectAdapterUtil.hasInterestedComponents(project)) {
                return new WebResource(StaticWebDeployableObjectAdapterUtil.getModule(project), (IPath)new Path(""));
            }
            return null;
        }
        project = ProjectUtilities.getProject((Object)resource);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        IPath rootPath = comp.getRootFolder().getProjectRelativePath();
        IPath resourcePath = resource.getProjectRelativePath();
        if (resourcePath.matchingFirstSegments(rootPath) != rootPath.segmentCount()) {
            return null;
        }
        if ((resourcePath = resourcePath.removeFirstSegments(rootPath.segmentCount())).segmentCount() > 1 && resourcePath.segment(0).equals(INFO_DIRECTORY)) {
            return null;
        }
        if (StaticWebDeployableObjectAdapterUtil.shouldExclude(resource)) {
            return null;
        }
        return new WebResource(StaticWebDeployableObjectAdapterUtil.getModule(project), resourcePath);
    }

    private static boolean shouldExclude(IResource resource) {
        String fileExt = resource.getFileExtension();
        int i = 0;
        while (i < extensionsToExclude.length) {
            String extension = extensionsToExclude[i];
            if (extension.equalsIgnoreCase(fileExt)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static IModule getModule(IProject project) {
        if (StaticWebDeployableObjectAdapterUtil.hasInterestedComponents(project)) {
            return ServerUtil.getModule((IProject)project);
        }
        return null;
    }

    protected static boolean hasInterestedComponents(IProject project) {
        return StaticWebDeployableObjectAdapterUtil.isProjectOfType(project, "wst.web");
    }

    protected static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }
}

