/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;

public class NamedElementOperations
extends ElementOperations {
    protected static final String LABEL_KEY_PREFIX = "_label_";

    protected NamedElementOperations() {
    }

    public static boolean validateHasNoQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateHasQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateVisibilityNeedsOwnership(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (namedElement.getNamespace() == null && namedElement.eIsSet((EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 6, UMLPlugin.INSTANCE.getString("_UI_NamedElement_VisibilityNeedsOwnership_diagnostic", NamedElementOperations.getMessageSubstitutions((Map)context, (Object)namedElement)), new Object[]{namedElement}));
            }
        }
        return result;
    }

    public static Dependency createDependency(NamedElement namedElement, NamedElement supplier) {
        Package package_ = namedElement.getNearestPackage();
        if (package_ == null) {
            throw new IllegalStateException();
        }
        if (supplier == null) {
            throw new IllegalArgumentException(String.valueOf(supplier));
        }
        Dependency dependency = (Dependency)package_.createPackagedElement(null, UMLPackage.Literals.DEPENDENCY);
        dependency.getClients().add((Object)namedElement);
        dependency.getSuppliers().add((Object)supplier);
        return dependency;
    }

    public static String getLabel(NamedElement namedElement) {
        return namedElement.getLabel(true);
    }

    public static String getLabel(NamedElement namedElement, boolean localize) {
        String qualifiedName = namedElement.getQualifiedName();
        return NamedElementOperations.getString((EObject)namedElement, (String)(LABEL_KEY_PREFIX + NamedElementOperations.getValidJavaIdentifier((String)(NamedElementOperations.isEmpty((String)qualifiedName) ? "" : qualifiedName.replace(':', '_')))), (String)namedElement.getName(), (boolean)localize);
    }

    public static String getQualifiedName(NamedElement namedElement) {
        return NamedElementOperations.getQualifiedName(namedElement, namedElement.separator());
    }

    protected static EList allNamespaces(NamedElement namedElement, EList allNamespaces) {
        Namespace namespace = namedElement.getNamespace();
        if (namespace != null && allNamespaces.add((Object)namespace)) {
            NamedElementOperations.allNamespaces(namespace, allNamespaces);
        }
        return allNamespaces;
    }

    public static EList allNamespaces(NamedElement namedElement) {
        return ECollections.unmodifiableEList((EList)NamedElementOperations.allNamespaces(namedElement, (EList)new UniqueEList.FastCompare()));
    }

    public static boolean isDistinguishableFrom(NamedElement namedElement, NamedElement n, Namespace ns) {
        EClass eClass = namedElement.eClass();
        EClass nEClass = n.eClass();
        if (nEClass.isSuperTypeOf(eClass) || eClass.isSuperTypeOf(nEClass)) {
            EList namesOfN = ns.getNamesOfMember(n);
            Iterator namesOfMember = ns.getNamesOfMember(namedElement).iterator();
            while (namesOfMember.hasNext()) {
                if (!namesOfN.contains(namesOfMember.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static String separator(NamedElement namedElement) {
        return "::";
    }

    public static EList allOwningPackages(NamedElement namedElement) {
        UniqueEList.FastCompare allOwningPackages = new UniqueEList.FastCompare();
        while ((namedElement = (NamedElement)NamedElementOperations.getOwningElement(namedElement, UMLPackage.Literals.PACKAGE, true)) != null) {
            allOwningPackages.add((Object)namedElement);
        }
        return ECollections.unmodifiableEList((EList)allOwningPackages);
    }
}

