/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;

public class RubyBrowsingContentProvider
extends StandardRubyElementContentProvider
implements IElementChangedListener {
    private RubyBrowsingPart fBrowsingPart;
    private StructuredViewer fViewer;
    private int fReadsInDisplayThread;
    private Object fInput;

    public RubyBrowsingContentProvider(boolean bl, RubyBrowsingPart rubyBrowsingPart) {
        super(bl);
        this.fBrowsingPart = rubyBrowsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        RubyCore.addElementChangedListener((IElementChangedListener)this);
    }

    public boolean hasChildren(Object object) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(object);
            Object var2_3 = null;
            this.finishedReadInDisplayThread();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.finishedReadInDisplayThread();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getChildren(Object object) {
        Object[] objectArray;
        block14: {
            Object[] objectArray2;
            block13: {
                Object[] objectArray3;
                block12: {
                    Object[] objectArray4;
                    block11: {
                        if (!this.exists(object)) {
                            return NO_CHILDREN;
                        }
                        this.startReadInDisplayThread();
                        try {
                            try {
                                if (object instanceof Collection) {
                                    Collection collection = (Collection)object;
                                    if (collection.isEmpty()) {
                                        Object[] objectArray5 = NO_CHILDREN;
                                        Object var6_10 = null;
                                        this.finishedReadInDisplayThread();
                                        return objectArray5;
                                    }
                                    Object[] objectArray6 = new Object[]{};
                                    Iterator iterator = ((Collection)object).iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) break;
                                        Object[] objectArray7 = this.getChildren(iterator.next());
                                        if (objectArray7 == NO_CHILDREN) continue;
                                        objectArray6 = RubyBrowsingContentProvider.concatenate(objectArray6, objectArray7);
                                    }
                                    Object[] objectArray8 = objectArray6;
                                    Object var6_11 = null;
                                    this.finishedReadInDisplayThread();
                                    return objectArray8;
                                }
                                if (this.fProvideMembers && object instanceof IType) {
                                    objectArray4 = this.getChildren((IType)object);
                                    break block11;
                                }
                                if (this.fProvideMembers && object instanceof ISourceReference && object instanceof IParent) {
                                    objectArray3 = super.getChildren(object);
                                    break block12;
                                }
                                if (object instanceof IRubyProject) {
                                    objectArray2 = this.getRubyTypes((IRubyProject)object);
                                    break block13;
                                }
                                objectArray = super.getChildren(object);
                                break block14;
                            }
                            catch (RubyModelException rubyModelException) {
                                Object[] objectArray9 = NO_CHILDREN;
                                Object var6_16 = null;
                                this.finishedReadInDisplayThread();
                                return objectArray9;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_17 = null;
                            this.finishedReadInDisplayThread();
                            throw throwable;
                        }
                    }
                    Object var6_12 = null;
                    this.finishedReadInDisplayThread();
                    return objectArray4;
                }
                Object var6_13 = null;
                this.finishedReadInDisplayThread();
                return objectArray3;
            }
            Object var6_14 = null;
            this.finishedReadInDisplayThread();
            return objectArray2;
        }
        Object var6_15 = null;
        this.finishedReadInDisplayThread();
        return objectArray;
    }

    private Object[] getChildren(IType iType) throws RubyModelException {
        IRubyScript iRubyScript = iType.getRubyScript();
        if (iType.getDeclaringType() != null) {
            return iType.getChildren();
        }
        IRubyElement[] iRubyElementArray = iRubyScript.getChildren();
        ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>(iRubyElementArray.length);
        int n = 0;
        while (n < iRubyElementArray.length) {
            if (iRubyElementArray[n] instanceof IImportContainer) {
                arrayList.add(iRubyElementArray[n]);
            }
            ++n;
        }
        arrayList.addAll(Arrays.asList(iType.getChildren()));
        return arrayList.toArray();
    }

    private Object[] getRubyTypes(IRubyProject iRubyProject) throws RubyModelException {
        Object[] objectArray = this.getRubyScripts(iRubyProject);
        ArrayList<IType> arrayList = new ArrayList<IType>();
        int n = 0;
        while (n < objectArray.length) {
            IRubyScript iRubyScript = (IRubyScript)objectArray[n];
            IType[] iTypeArray = iRubyScript.getTypes();
            int n2 = 0;
            while (n2 < iTypeArray.length) {
                arrayList.add(iTypeArray[n2]);
                ++n2;
            }
            ++n;
        }
        return RubyBrowsingContentProvider.concatenate(arrayList.toArray(), new Object[0]);
    }

    protected Object[] getRubyScripts(IRubyProject iRubyProject) throws RubyModelException {
        if (!iRubyProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        return iRubyProject.getRubyScripts();
    }

    private boolean isDisplayThread() {
        Control control = this.fViewer.getControl();
        if (control == null) {
            return false;
        }
        Display display = Display.getCurrent();
        return display != null && display.equals(control.getDisplay());
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            object2 = !collection.isEmpty() ? collection.iterator().next() : null;
        }
        this.fInput = object2;
    }

    public void dispose() {
        super.dispose();
        RubyCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected Object internalGetParent(Object object) {
        if (object instanceof IRubyProject) {
            return ((IRubyProject)object).getRubyModel();
        }
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            IRubyElement iRubyElement = RubyCore.create((IResource)iContainer);
            if (iRubyElement != null) {
                return iRubyElement;
            }
            return iContainer;
        }
        if (object instanceof IRubyElement) {
            return ((IRubyElement)object).getParent();
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (RubyModelException rubyModelException) {
            RubyPlugin.log(rubyModelException.getStatus());
        }
    }

    protected void processDelta(IRubyElementDelta iRubyElementDelta) throws RubyModelException {
        int n = iRubyElementDelta.getKind();
        int n2 = iRubyElementDelta.getFlags();
        IRubyElement iRubyElement = iRubyElementDelta.getElement();
        boolean bl = this.fBrowsingPart.isValidElement(iRubyElement);
        if (!this.getProvideWorkingCopy() && iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy()) {
            return;
        }
        if (iRubyElement != null && iRubyElement.getElementType() == 2 && !this.isOnClassPath((IRubyScript)iRubyElement)) {
            return;
        }
        if ((n2 & 0x400) != 0 || (n2 & 0x200) != 0) {
            this.postRefresh(null);
            return;
        }
        if (n == 2) {
            Object object = this.internalGetParent(iRubyElement);
            if (bl) {
                if (iRubyElement instanceof IRubyScript && !((IRubyScript)iRubyElement).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy()) {
                    if (this.getProvideWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (object instanceof IRubyScript && this.getProvideWorkingCopy() && !((IRubyScript)object).isWorkingCopy()) {
                    if (iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy() && object != null && object.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(iRubyElement);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(iRubyElement, this.fInput)) {
                if (iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(RubyModelUtil.toOriginal((IRubyElement)this.fInput));
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(iRubyElement)) {
                this.postRefresh(null);
            }
            return;
        }
        if (n == 1 && iRubyElementDelta.getMovedFromElement() != null && iRubyElement instanceof IRubyScript) {
            return;
        }
        if (n == 1) {
            if (bl) {
                Object object = this.internalGetParent(iRubyElement);
                if (iRubyElement instanceof IRubyScript && !((IRubyScript)iRubyElement).isWorkingCopy()) {
                    this.postAdd(object, ((IRubyScript)iRubyElement).getTypes());
                } else if (!(object instanceof IRubyScript) || !this.getProvideWorkingCopy() || ((IRubyScript)object).isWorkingCopy()) {
                    if (iRubyElement instanceof IRubyScript && ((IRubyScript)iRubyElement).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(object, iRubyElement);
                    }
                }
            } else if (this.fInput == null) {
                IRubyElement iRubyElement2 = this.fBrowsingPart.findInputForRubyElement(iRubyElement);
                if (iRubyElement2 != null) {
                    this.postAdjustInputAndSetSelection(iRubyElement);
                }
            } else if (iRubyElement instanceof IType && this.fBrowsingPart.isValidInput(iRubyElement)) {
                IRubyElement iRubyElement3 = iRubyElement.getAncestor(2);
                IRubyElement iRubyElement4 = ((IRubyElement)this.fInput).getAncestor(2);
                if (iRubyElement3 != null && iRubyElement4 != null && iRubyElement3.equals(iRubyElement4)) {
                    this.postAdjustInputAndSetSelection(iRubyElement);
                }
            }
            return;
        }
        if (n == 4) {
            if (this.fInput != null && this.fInput.equals(iRubyElement) && (n2 & 8) != 0 && (n2 & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (bl && (n2 & 2) != 0) {
                this.postUpdateIcon(iRubyElement);
            }
        }
        if (this.isClassPathChange(iRubyElementDelta)) {
            this.postRefresh(null);
        }
        IRubyElementDelta[] iRubyElementDeltaArray = iRubyElementDelta.getAffectedChildren();
        int n3 = 0;
        while (n3 < iRubyElementDeltaArray.length) {
            this.processDelta(iRubyElementDeltaArray[n3]);
            ++n3;
        }
    }

    private boolean isOnClassPath(IRubyScript iRubyScript) throws RubyModelException {
        IRubyProject iRubyProject = iRubyScript.getRubyProject();
        if (iRubyProject == null || !iRubyProject.exists()) {
            return false;
        }
        return iRubyProject.isOnLoadpath(iRubyScript);
    }

    private void postUpdateIcon(final IRubyElement iRubyElement) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    RubyBrowsingContentProvider.this.fViewer.update((Object)iRubyElement, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object object, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    RubyBrowsingContentProvider.this.fViewer.refresh(object, bl);
                }
            }
        });
    }

    private void postRefresh(Object object) {
        this.postRefresh(object, false);
    }

    private void postAdd(Object object, Object object2) {
        this.postAdd(object, new Object[]{object2});
    }

    private void postAdd(final Object object, final Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    Object[] objectArray2 = RubyBrowsingContentProvider.this.getNewElements(objectArray);
                    if (RubyBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (RubyBrowsingContentProvider.this.fViewer.testFindItem(object) == null) {
                            Object object2 = ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).getInput();
                            if (object2 != null) {
                                ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).add(object2, objectArray2);
                            }
                        } else {
                            ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).add(object, objectArray2);
                        }
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)RubyBrowsingContentProvider.this.fViewer).add(objectArray2);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)RubyBrowsingContentProvider.this.fViewer).add(objectArray2);
                    }
                    if (RubyBrowsingContentProvider.this.fViewer.testFindItem(objectArray[0]) != null) {
                        RubyBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(objectArray[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] objectArray) {
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.fViewer.testFindItem(object) == null) {
                arrayList.add(object);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    private void postRemove(Object object) {
        this.postRemove(new Object[]{object});
    }

    private void postRemove(final Object[] objectArray) {
        if (objectArray.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (RubyBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).remove(objectArray);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)RubyBrowsingContentProvider.this.fViewer).remove(objectArray);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)RubyBrowsingContentProvider.this.fViewer).remove(objectArray);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    RubyBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(object);
                    control.setRedraw(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control == null) return;
        if (control.isDisposed()) return;
        this.fBrowsingPart.setProcessSelectionEvents(false);
        try {
            if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                control.getDisplay().syncExec(runnable);
            } else {
                control.getDisplay().asyncExec(runnable);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            return;
        }
    }
}

