/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpClientFactory;
import org.apache.commons.vfs.provider.http.HttpFileNameParser;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class HttpFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public HttpFileProvider() {
        this.setFileNameParser(HttpFileNameParser.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClient = HttpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()))), fileSystemOptions);
        }
        finally {
            UserAuthenticatorUtils.cleanup(authData);
        }
        return new HttpFileSystem(rootName, httpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return HttpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

