/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class InvocationWeaver
implements Opcodes {
    private static final String INVOCATION_INTERFACE = "com/googlecode/d2j/tools/jar/MethodInvocation";
    private static final String DEFAULT_RET_TYPE = "Ld/$$$/j;";
    private static final String DEFAULT_DESC = "(L;)Ld/$$$/j;";
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final String BASE_INVOCATION_TYPE_FMT = "d2j/gen/MI_%03d";
    List<Callback> callbacks = new ArrayList<Callback>();
    int currentInvocationIdx = 0;
    private MtdInfo key = new MtdInfo();
    private Remapper remapper = new Remapper(){

        public String mapDesc(String desc) {
            if (desc.length() == 1) {
                return desc;
            }
            String nDesc = (String)InvocationWeaver.this.clzDescMap.get(desc);
            return nDesc == null ? desc : nDesc;
        }
    };
    private Set<String> ignores = new HashSet<String>();
    private Map<String, String> clzDescMap = new HashMap<String, String>();
    private Map<MtdInfo, MtdInfo> mtdMap = new HashMap<MtdInfo, MtdInfo>();

    private static void box(Type arg, MethodVisitor mv) {
        switch (arg.getSort()) {
            case 9: 
            case 10: {
                return;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Floag", "valueOf", "(F)Ljava/lang/Floag;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 0: {
                mv.visitInsn(1);
            }
        }
    }

    private static void unBox(Type orgRet, Type nRet, MethodVisitor mv) {
        if (orgRet.equals((Object)nRet)) {
            return;
        }
        if (orgRet.getSort() == 0) {
            mv.visitInsn(nRet.getSize() == 1 ? 87 : 88);
        }
        if (nRet.getSort() != 10) {
            throw new RuntimeException("invalid ret type:" + nRet);
        }
        switch (orgRet.getSort()) {
            case 9: 
            case 10: {
                mv.visitTypeInsn(192, orgRet.getInternalName());
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F");
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J");
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D");
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B");
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Number");
                mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S");
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            }
        }
    }

    private byte[] wave0(byte[] data) throws IOException {
        final ClassWriter cw = new ClassWriter(1);
        new ClassReader(data).accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, this.remapper){
            Map<MtdInfo, MtdInfo> toCreate;
            String clzName;
            {
                super($anonymous0, $anonymous1);
                this.toCreate = new HashMap<MtdInfo, MtdInfo>();
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.clzName = name;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        MtdInfo mapTo = InvocationWeaver.this.findTargetMethod(owner, name, desc);
                        if (mapTo != null) {
                            boolean isStatic = opcode == 184;
                            Type orgRet = Type.getReturnType((String)desc);
                            Object[] orgArgs = Type.getArgumentTypes((String)desc);
                            Type nRet = Type.getReturnType((String)mapTo.desc);
                            Object[] nArgs = Type.getArgumentTypes((String)mapTo.desc);
                            if (orgRet.getSort() != 0 && nRet.getSort() == 0) {
                                throw new RuntimeException("can't cast " + nRet + " to " + orgRet);
                            }
                            if (nArgs.length == 1 && nArgs[0].getInternalName().equals(InvocationWeaver.INVOCATION_INTERFACE)) {
                                MtdInfo t = new MtdInfo();
                                t.owner = owner;
                                t.name = name;
                                t.desc = desc;
                                MtdInfo n = this.newMethodA(opcode, t, mapTo);
                                super.visitMethodInsn(184, clzName, n.name, n.desc);
                            } else {
                                if (isStatic) {
                                    if (!Arrays.deepEquals(orgArgs, nArgs)) {
                                        throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                    }
                                } else {
                                    if (nArgs.length != orgArgs.length + 1) {
                                        throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                    }
                                    if (orgArgs.length > 0) {
                                        int i = 0;
                                        while (i < orgArgs.length) {
                                            if (!orgArgs[i].equals(nArgs[i + 1])) {
                                                throw new RuntimeException("arguments not equal: " + owner + "." + name + desc + " <> " + mapTo.owner + "." + mapTo.name + mapTo.desc);
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                super.visitMethodInsn(184, mapTo.owner, mapTo.name, mapTo.desc);
                                InvocationWeaver.unBox(orgRet, nRet, this.mv);
                            }
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }
                    }

                    private MtdInfo newMethodA(int opcode, MtdInfo t, MtdInfo mapTo) {
                        int start;
                        MtdInfo n = toCreate.get(t);
                        if (n != null) {
                            return n;
                        }
                        n = new MtdInfo();
                        n.owner = t.owner;
                        n.name = String.valueOf(t.name) + "$$$_A_";
                        String nDesc = t.desc;
                        boolean hasThis = opcode != 184;
                        Type[] args = Type.getArgumentTypes((String)t.desc);
                        Type ret = Type.getReturnType((String)t.desc);
                        if (hasThis) {
                            ArrayList<Type> ts = new ArrayList<Type>(5);
                            ts.add(Type.getObjectType((String)t.owner));
                            ts.addAll(Arrays.asList(args));
                            nDesc = Type.getMethodDescriptor((Type)ret, (Type[])ts.toArray(new Type[ts.size()]));
                        }
                        n.desc = nDesc;
                        toCreate.put(t, n);
                        MethodVisitor mv = cw.visitMethod(4106, n.name, n.desc, null, null);
                        mv.visitCode();
                        mv.visitTypeInsn(187, InvocationWeaver.this.getCurrentInvocationName());
                        mv.visitInsn(89);
                        if (hasThis) {
                            mv.visitVarInsn(25, 0);
                            start = 1;
                        } else {
                            mv.visitInsn(1);
                            start = 0;
                        }
                        mv.visitLdcInsn((Object)args.length);
                        mv.visitTypeInsn(189, "java/lang/Object");
                        int i = 0;
                        while (i < args.length) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)i);
                            mv.visitVarInsn(args[i].getOpcode(21), i + start);
                            InvocationWeaver.box(args[i], mv);
                            mv.visitInsn(83);
                            ++i;
                        }
                        int nextIdx = (this).InvocationWeaver.this.callbacks.size();
                        mv.visitLdcInsn((Object)nextIdx);
                        mv.visitMethodInsn(183, InvocationWeaver.this.getCurrentInvocationName(), "<init>", "(Ljava/lang/Object;[Ljava/lang/Object;I)V");
                        mv.visitMethodInsn(184, mapTo.owner, mapTo.name, mapTo.desc);
                        InvocationWeaver.unBox(ret, Type.getReturnType((String)mapTo.desc), mv);
                        mv.visitInsn(ret.getOpcode(172));
                        mv.visitMaxs(-1, -1);
                        mv.visitEnd();
                        Callback cb = new Callback();
                        cb.idx = nextIdx;
                        cb.callback = this.newMethodCallback(opcode, t);
                        cb.target = t;
                        cb.isSpecial = opcode == 183;
                        cb.isStatic = opcode == 184;
                        (this).InvocationWeaver.this.callbacks.add(cb);
                        return n;
                    }

                    private MtdInfo newMethodCallback(int opcode, MtdInfo t) {
                        int start;
                        MtdInfo n = new MtdInfo();
                        n.owner = className;
                        n.name = String.valueOf(t.name) + "$$$$_callback";
                        n.desc = opcode == 183 || opcode == 184 ? "([Ljava/lang/Object;)Ljava/lang/Object;" : "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
                        MethodVisitor mv = cw.visitMethod(opcode == 183 ? 1 : 9, n.name, n.desc, null, null);
                        mv.visitCode();
                        if (opcode != 184) {
                            mv.visitVarInsn(25, 0);
                            if (opcode != 183) {
                                mv.visitTypeInsn(192, t.owner);
                            }
                            start = 1;
                        } else {
                            start = 0;
                        }
                        Type[] args = Type.getArgumentTypes((String)t.desc);
                        int i = 0;
                        while (i < args.length) {
                            mv.visitVarInsn(25, start);
                            mv.visitLdcInsn((Object)i);
                            mv.visitInsn(50);
                            InvocationWeaver.unBox(args[i], OBJECT_TYPE, mv);
                            ++i;
                        }
                        mv.visitMethodInsn(opcode, t.owner, t.name, t.desc);
                        Type ret = Type.getReturnType((String)t.desc);
                        InvocationWeaver.box(ret, mv);
                        mv.visitInsn(176);
                        mv.visitMaxs(-1, -1);
                        mv.visitEnd();
                        return n;
                    }
                };
            }
        }, 8);
        return cw.toByteArray();
    }

    private MtdInfo findTargetMethod(String owner, String name, String desc) {
        this.key.name = name;
        this.key.owner = owner;
        this.key.desc = desc;
        MtdInfo v = this.mtdMap.get(this.key);
        if (v != null) {
            return v;
        }
        this.key.desc = Type.getMethodDescriptor((Type)Type.getType((String)DEFAULT_RET_TYPE), (Type[])Type.getArgumentTypes((String)desc));
        v = this.mtdMap.get(this.key);
        if (v != null) {
            return v;
        }
        this.key.desc = DEFAULT_DESC;
        v = this.mtdMap.get(this.key);
        return v;
    }

    public void wave(Path from, final Path to) throws IOException {
        BaseCmd.walkJarOrDir((Path)from, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

            public void visitFile(Path file, Path relative) throws IOException {
                block17: {
                    String name = relative.toString();
                    Path targetPath = to.resolve(relative);
                    BaseCmd.createParentDirectories((Path)targetPath);
                    if (name.endsWith(".class")) {
                        String clzName = name.substring(0, name.length() - ".class".length());
                        if (InvocationWeaver.this.ignores.contains(clzName)) {
                            Files.copy(file, targetPath, new CopyOption[0]);
                        } else {
                            byte[] out = InvocationWeaver.this.wave0(Files.readAllBytes(file));
                            Files.write(targetPath, out, new OpenOption[0]);
                        }
                    } else if (name.startsWith("META-INF/")) {
                        if (name.equals("META-INF/MANIFEST.MF")) {
                            Throwable throwable = null;
                            Object var6_9 = null;
                            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                                Manifest mf = new Manifest(in);
                                mf.getMainAttributes().put(new Attributes.Name("X-NOTICE"), "Modified");
                                mf.getEntries().clear();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                mf.write(baos);
                                baos.flush();
                                Files.write(targetPath, baos.toByteArray(), new OpenOption[0]);
                                break block17;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        if (!(name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".SF") || name.endsWith(".ECDSA"))) {
                            Files.copy(file, targetPath, new CopyOption[0]);
                        }
                    } else {
                        Files.copy(file, targetPath, new CopyOption[0]);
                    }
                }
            }
        });
        if (this.callbacks.size() > 0) {
            String type = this.getCurrentInvocationName();
            byte[] data = this.buildInvocationClz(type);
            Path target = to.resolve(String.valueOf(type) + ".class");
            BaseCmd.createParentDirectories((Path)target);
            Files.write(target, data, new OpenOption[0]);
            this.nextInvocationName();
        }
    }

    private byte[] buildInvocationClz(String typeName) {
        MtdInfo m;
        Callback cb;
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 1, typeName, null, "java/lang/Object", new String[]{INVOCATION_INTERFACE});
        cw.visitField(18, "thiz", "Ljava/lang/Object;", null, null).visitEnd();
        cw.visitField(18, "args", "[Ljava/lang/Object;", null, null).visitEnd();
        cw.visitField(18, "idx", "I", null, null).visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Object;[Ljava/lang/Object;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, typeName, "thiz", "Ljava/lang/Object;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, typeName, "args", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 3);
        mv.visitFieldInsn(181, typeName, "idx", "I");
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getMethodOwner", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        Label def = new Label();
        Label[] labels = new Label[this.callbacks.size()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = new Label();
            ++i;
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        i = 0;
        while (i < labels.length) {
            mv.visitLabel(labels[i]);
            cb = this.callbacks.get(i);
            m = cb.target;
            mv.visitLdcInsn((Object)("L" + m.owner + ";"));
            mv.visitInsn(176);
            ++i;
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getMethodName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        def = new Label();
        labels = new Label[this.callbacks.size()];
        i = 0;
        while (i < labels.length) {
            labels[i] = new Label();
            ++i;
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        i = 0;
        while (i < labels.length) {
            mv.visitLabel(labels[i]);
            cb = this.callbacks.get(i);
            m = cb.target;
            mv.visitLdcInsn((Object)m.name);
            mv.visitInsn(176);
            ++i;
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getMethodDesc", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        def = new Label();
        labels = new Label[this.callbacks.size()];
        i = 0;
        while (i < labels.length) {
            labels[i] = new Label();
            ++i;
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        i = 0;
        while (i < labels.length) {
            mv.visitLabel(labels[i]);
            cb = this.callbacks.get(i);
            m = cb.target;
            mv.visitLdcInsn((Object)m.desc);
            mv.visitInsn(176);
            ++i;
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getArguments", "()[Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getThis", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "proceed", "()Ljava/lang/Object;", null, new String[]{"java/lang/Throwable"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, typeName, "idx", "I");
        def = new Label();
        labels = new Label[this.callbacks.size()];
        i = 0;
        while (i < labels.length) {
            labels[i] = new Label();
            ++i;
        }
        mv.visitTableSwitchInsn(0, this.callbacks.size() - 1, def, labels);
        i = 0;
        while (i < labels.length) {
            mv.visitLabel(labels[i]);
            cb = this.callbacks.get(i);
            m = cb.callback;
            if (cb.isStatic) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(184, m.owner, m.name, m.desc);
            } else if (cb.isSpecial) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
                mv.visitTypeInsn(192, m.owner);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(182, m.owner, m.name, m.desc);
            } else {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "thiz", "Ljava/lang/Object;");
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, typeName, "args", "[Ljava/lang/Object;");
                mv.visitMethodInsn(184, m.owner, m.name, m.desc);
            }
            Type ret = Type.getReturnType((String)m.desc);
            InvocationWeaver.box(ret, mv);
            mv.visitInsn(ret.getOpcode(172));
            ++i;
        }
        mv.visitLabel(def);
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"invalid idx");
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        return cw.toByteArray();
    }

    public InvocationWeaver withConfig(Path is) throws IOException {
        return this.withConfig(Files.readAllLines(is, StandardCharsets.UTF_8));
    }

    public InvocationWeaver withConfig(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            ArrayList<String> list = new ArrayList<String>();
            String ln = r.readLine();
            while (ln != null) {
                list.add(ln);
                ln = r.readLine();
            }
            return this.withConfig(list);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public InvocationWeaver withConfig(List<String> lines) throws IOException {
        for (String ln : lines) {
            if ("".equals(ln) || ln.startsWith("#")) continue;
            switch (ln.charAt(0)) {
                case 'I': 
                case 'i': {
                    this.ignores.add(ln.substring(2));
                    break;
                }
                case 'C': 
                case 'c': {
                    int index = ln.lastIndexOf(61);
                    if (index <= 0) break;
                    String key = this.toInternal(ln.substring(2, index));
                    String value = this.toInternal(ln.substring(index + 1));
                    this.clzDescMap.put(key, value);
                    this.ignores.add(value);
                    break;
                }
                case 'R': 
                case 'r': {
                    int index = ln.lastIndexOf(61);
                    if (index <= 0) break;
                    String key = ln.substring(2, index);
                    String value = ln.substring(index + 1);
                    MtdInfo mi = this.buildMethodInfo(key);
                    index = value.indexOf(46);
                    MtdInfo mtdValue = new MtdInfo();
                    mtdValue.owner = this.toInternal(value.substring(0, index));
                    int index2 = value.indexOf(40, index);
                    mtdValue.name = value.substring(index + 1, index2);
                    mtdValue.desc = value.substring(index2);
                    this.mtdMap.put(mi, mtdValue);
                }
            }
        }
        return this;
    }

    private String toInternal(String key) {
        if (key.endsWith(";")) {
            key = key.substring(1, key.length() - 1);
        }
        return key;
    }

    private MtdInfo buildMethodInfo(String value) {
        int index = value.indexOf(46);
        MtdInfo mtdValue = new MtdInfo();
        mtdValue.owner = this.toInternal(value.substring(0, index));
        int index2 = value.indexOf(40, index);
        if (index2 >= 0) {
            mtdValue.name = value.substring(index + 1, index2);
            int index3 = value.indexOf(41);
            mtdValue.desc = index3 == value.length() - 1 ? String.valueOf(value.substring(index2)) + DEFAULT_RET_TYPE : value.substring(index2);
        } else {
            mtdValue.name = value.substring(index + 1);
            mtdValue.desc = DEFAULT_DESC;
        }
        return mtdValue;
    }

    public String getCurrentInvocationName() {
        return String.format(BASE_INVOCATION_TYPE_FMT, this.currentInvocationIdx);
    }

    private void nextInvocationName() {
        ++this.currentInvocationIdx;
        this.callbacks.clear();
    }

    static class Callback {
        int idx;
        MtdInfo callback;
        MtdInfo target;
        boolean isSpecial;
        boolean isStatic;

        Callback() {
        }
    }

    public static class MtdInfo {
        public String desc;
        public String name;
        public String owner;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MtdInfo mtdInfo = (MtdInfo)o;
            if (!this.desc.equals(mtdInfo.desc)) {
                return false;
            }
            if (!this.name.equals(mtdInfo.name)) {
                return false;
            }
            return this.owner.equals(mtdInfo.owner);
        }

        public int hashCode() {
            int result = this.desc.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.owner.hashCode();
            return result;
        }
    }
}

