/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileOnCompletion<T>
implements Synchronization {
    private final Logger log = LoggerFactory.getLogger(GenericFileOnCompletion.class);
    private GenericFileEndpoint<T> endpoint;
    private GenericFileOperations<T> operations;
    private ExceptionHandler exceptionHandler;
    private GenericFile<T> file;
    private String absoluteFileName;

    public GenericFileOnCompletion(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations, GenericFile<T> file, String absoluteFileName) {
        this.endpoint = endpoint;
        this.operations = operations;
        this.file = file;
        this.absoluteFileName = absoluteFileName;
        this.exceptionHandler = endpoint.getOnCompletionExceptionHandler();
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), this.getClass());
        }
    }

    @Override
    public void onComplete(Exchange exchange) {
        this.onCompletion(exchange);
    }

    @Override
    public void onFailure(Exchange exchange) {
        this.onCompletion(exchange);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompletion(Exchange exchange) {
        GenericFileProcessStrategy<T> processStrategy = this.endpoint.getGenericFileProcessStrategy();
        this.log.debug("Done processing file: {} using exchange: {}", this.file, (Object)exchange);
        boolean committed = false;
        try {
            boolean failed = exchange.isFailed();
            if (!failed) {
                this.processStrategyCommit(processStrategy, exchange, this.file);
                committed = true;
            }
        }
        finally {
            if (!committed) {
                this.processStrategyRollback(processStrategy, exchange, this.file);
            }
            this.endpoint.getInProgressRepository().remove(this.absoluteFileName);
        }
    }

    protected void processStrategyCommit(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.endpoint.isIdempotent().booleanValue()) {
            String key = this.absoluteFileName;
            if (this.endpoint.getIdempotentKey() != null) {
                Exchange dummy = this.endpoint.createExchange(file);
                key = this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
            }
            if (key != null) {
                this.endpoint.getIdempotentRepository().add(key);
            }
        }
        this.handleDoneFile(exchange);
        try {
            this.log.trace("Commit file strategy: {} for file: {}", processStrategy, file);
            processStrategy.commit(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException("Error during commit", exchange, e);
        }
    }

    protected void processStrategyRollback(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("Rollback file strategy: " + processStrategy + " for file: " + file);
        }
        if (this.endpoint.getMoveFailed() != null) {
            this.handleDoneFile(exchange);
        }
        try {
            processStrategy.rollback(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException("Error during rollback", exchange, e);
        }
    }

    protected void handleDoneFile(Exchange exchange) {
        boolean complete = exchange.getProperty("CamelBatchComplete", false, Boolean.class);
        if (this.endpoint.getDoneFileName() != null && !this.endpoint.isNoop()) {
            String doneFileName = this.endpoint.createDoneFileName(this.absoluteFileName);
            ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
            if (this.endpoint.getDoneFileName().indexOf("{file:name") > 0 || complete) {
                try {
                    boolean deleted = this.operations.deleteFile(doneFileName);
                    this.log.trace("Done file: {} was deleted: {}", (Object)doneFileName, (Object)deleted);
                    if (!deleted) {
                        this.log.warn("Done file: " + doneFileName + " could not be deleted");
                    }
                }
                catch (Exception e) {
                    this.handleException("Error deleting done file: " + doneFileName, exchange, e);
                }
            }
        }
    }

    protected void handleException(String message, Exchange exchange, Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(message, exchange, newt);
    }

    public String toString() {
        return "GenericFileOnCompletion";
    }
}

