package Date::Manip::TZ::asdama00;
# Copyright (c) 2008-2013 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 30 12:40:08 EST 2012
#    Data version: tzdata2012j
#    Code version: tzcode2012j

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::asdama00 - Support for the Asia/Damascus time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.39';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,25,12],'+02:25:12',[2,25,12],
          'LMT',0,[1919,12,31,21,34,47],[1919,12,31,23,59,59],
          '0001010200:00:00','0001010202:25:12','1919123121:34:47','1919123123:59:59' ],
     ],
   1919 =>
     [
        [ [1919,12,31,21,34,48],[1919,12,31,23,34,48],'+02:00:00',[2,0,0],
          'EET',0,[1920,4,17,23,59,59],[1920,4,18,1,59,59],
          '1919123121:34:48','1919123123:34:48','1920041723:59:59','1920041801:59:59' ],
     ],
   1920 =>
     [
        [ [1920,4,18,0,0,0],[1920,4,18,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1920,10,2,22,59,59],[1920,10,3,1,59,59],
          '1920041800:00:00','1920041803:00:00','1920100222:59:59','1920100301:59:59' ],
        [ [1920,10,2,23,0,0],[1920,10,3,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1921,4,16,23,59,59],[1921,4,17,1,59,59],
          '1920100223:00:00','1920100301:00:00','1921041623:59:59','1921041701:59:59' ],
     ],
   1921 =>
     [
        [ [1921,4,17,0,0,0],[1921,4,17,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1921,10,1,22,59,59],[1921,10,2,1,59,59],
          '1921041700:00:00','1921041703:00:00','1921100122:59:59','1921100201:59:59' ],
        [ [1921,10,1,23,0,0],[1921,10,2,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1922,4,15,23,59,59],[1922,4,16,1,59,59],
          '1921100123:00:00','1921100201:00:00','1922041523:59:59','1922041601:59:59' ],
     ],
   1922 =>
     [
        [ [1922,4,16,0,0,0],[1922,4,16,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1922,9,30,22,59,59],[1922,10,1,1,59,59],
          '1922041600:00:00','1922041603:00:00','1922093022:59:59','1922100101:59:59' ],
        [ [1922,9,30,23,0,0],[1922,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1923,4,14,23,59,59],[1923,4,15,1,59,59],
          '1922093023:00:00','1922100101:00:00','1923041423:59:59','1923041501:59:59' ],
     ],
   1923 =>
     [
        [ [1923,4,15,0,0,0],[1923,4,15,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1923,10,6,22,59,59],[1923,10,7,1,59,59],
          '1923041500:00:00','1923041503:00:00','1923100622:59:59','1923100701:59:59' ],
        [ [1923,10,6,23,0,0],[1923,10,7,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1962,4,28,23,59,59],[1962,4,29,1,59,59],
          '1923100623:00:00','1923100701:00:00','1962042823:59:59','1962042901:59:59' ],
     ],
   1962 =>
     [
        [ [1962,4,29,0,0,0],[1962,4,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1962,9,30,22,59,59],[1962,10,1,1,59,59],
          '1962042900:00:00','1962042903:00:00','1962093022:59:59','1962100101:59:59' ],
        [ [1962,9,30,23,0,0],[1962,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1963,4,30,23,59,59],[1963,5,1,1,59,59],
          '1962093023:00:00','1962100101:00:00','1963043023:59:59','1963050101:59:59' ],
     ],
   1963 =>
     [
        [ [1963,5,1,0,0,0],[1963,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1963,9,29,22,59,59],[1963,9,30,1,59,59],
          '1963050100:00:00','1963050103:00:00','1963092922:59:59','1963093001:59:59' ],
        [ [1963,9,29,23,0,0],[1963,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1964,4,30,23,59,59],[1964,5,1,1,59,59],
          '1963092923:00:00','1963093001:00:00','1964043023:59:59','1964050101:59:59' ],
     ],
   1964 =>
     [
        [ [1964,5,1,0,0,0],[1964,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1964,9,30,22,59,59],[1964,10,1,1,59,59],
          '1964050100:00:00','1964050103:00:00','1964093022:59:59','1964100101:59:59' ],
        [ [1964,9,30,23,0,0],[1964,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1965,4,30,23,59,59],[1965,5,1,1,59,59],
          '1964093023:00:00','1964100101:00:00','1965043023:59:59','1965050101:59:59' ],
     ],
   1965 =>
     [
        [ [1965,5,1,0,0,0],[1965,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1965,9,29,22,59,59],[1965,9,30,1,59,59],
          '1965050100:00:00','1965050103:00:00','1965092922:59:59','1965093001:59:59' ],
        [ [1965,9,29,23,0,0],[1965,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1966,4,23,23,59,59],[1966,4,24,1,59,59],
          '1965092923:00:00','1965093001:00:00','1966042323:59:59','1966042401:59:59' ],
     ],
   1966 =>
     [
        [ [1966,4,24,0,0,0],[1966,4,24,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1966,9,30,22,59,59],[1966,10,1,1,59,59],
          '1966042400:00:00','1966042403:00:00','1966093022:59:59','1966100101:59:59' ],
        [ [1966,9,30,23,0,0],[1966,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1967,4,30,23,59,59],[1967,5,1,1,59,59],
          '1966093023:00:00','1966100101:00:00','1967043023:59:59','1967050101:59:59' ],
     ],
   1967 =>
     [
        [ [1967,5,1,0,0,0],[1967,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1967,9,30,22,59,59],[1967,10,1,1,59,59],
          '1967050100:00:00','1967050103:00:00','1967093022:59:59','1967100101:59:59' ],
        [ [1967,9,30,23,0,0],[1967,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1968,4,30,23,59,59],[1968,5,1,1,59,59],
          '1967093023:00:00','1967100101:00:00','1968043023:59:59','1968050101:59:59' ],
     ],
   1968 =>
     [
        [ [1968,5,1,0,0,0],[1968,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1968,9,30,22,59,59],[1968,10,1,1,59,59],
          '1968050100:00:00','1968050103:00:00','1968093022:59:59','1968100101:59:59' ],
        [ [1968,9,30,23,0,0],[1968,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1969,4,30,23,59,59],[1969,5,1,1,59,59],
          '1968093023:00:00','1968100101:00:00','1969043023:59:59','1969050101:59:59' ],
     ],
   1969 =>
     [
        [ [1969,5,1,0,0,0],[1969,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1969,9,30,22,59,59],[1969,10,1,1,59,59],
          '1969050100:00:00','1969050103:00:00','1969093022:59:59','1969100101:59:59' ],
        [ [1969,9,30,23,0,0],[1969,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1970,4,30,23,59,59],[1970,5,1,1,59,59],
          '1969093023:00:00','1969100101:00:00','1970043023:59:59','1970050101:59:59' ],
     ],
   1970 =>
     [
        [ [1970,5,1,0,0,0],[1970,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1970,9,30,22,59,59],[1970,10,1,1,59,59],
          '1970050100:00:00','1970050103:00:00','1970093022:59:59','1970100101:59:59' ],
        [ [1970,9,30,23,0,0],[1970,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1971,4,30,23,59,59],[1971,5,1,1,59,59],
          '1970093023:00:00','1970100101:00:00','1971043023:59:59','1971050101:59:59' ],
     ],
   1971 =>
     [
        [ [1971,5,1,0,0,0],[1971,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1971,9,30,22,59,59],[1971,10,1,1,59,59],
          '1971050100:00:00','1971050103:00:00','1971093022:59:59','1971100101:59:59' ],
        [ [1971,9,30,23,0,0],[1971,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1972,4,30,23,59,59],[1972,5,1,1,59,59],
          '1971093023:00:00','1971100101:00:00','1972043023:59:59','1972050101:59:59' ],
     ],
   1972 =>
     [
        [ [1972,5,1,0,0,0],[1972,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1972,9,30,22,59,59],[1972,10,1,1,59,59],
          '1972050100:00:00','1972050103:00:00','1972093022:59:59','1972100101:59:59' ],
        [ [1972,9,30,23,0,0],[1972,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1973,4,30,23,59,59],[1973,5,1,1,59,59],
          '1972093023:00:00','1972100101:00:00','1973043023:59:59','1973050101:59:59' ],
     ],
   1973 =>
     [
        [ [1973,5,1,0,0,0],[1973,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1973,9,30,22,59,59],[1973,10,1,1,59,59],
          '1973050100:00:00','1973050103:00:00','1973093022:59:59','1973100101:59:59' ],
        [ [1973,9,30,23,0,0],[1973,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1974,4,30,23,59,59],[1974,5,1,1,59,59],
          '1973093023:00:00','1973100101:00:00','1974043023:59:59','1974050101:59:59' ],
     ],
   1974 =>
     [
        [ [1974,5,1,0,0,0],[1974,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1974,9,30,22,59,59],[1974,10,1,1,59,59],
          '1974050100:00:00','1974050103:00:00','1974093022:59:59','1974100101:59:59' ],
        [ [1974,9,30,23,0,0],[1974,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1975,4,30,23,59,59],[1975,5,1,1,59,59],
          '1974093023:00:00','1974100101:00:00','1975043023:59:59','1975050101:59:59' ],
     ],
   1975 =>
     [
        [ [1975,5,1,0,0,0],[1975,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1975,9,30,22,59,59],[1975,10,1,1,59,59],
          '1975050100:00:00','1975050103:00:00','1975093022:59:59','1975100101:59:59' ],
        [ [1975,9,30,23,0,0],[1975,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1976,4,30,23,59,59],[1976,5,1,1,59,59],
          '1975093023:00:00','1975100101:00:00','1976043023:59:59','1976050101:59:59' ],
     ],
   1976 =>
     [
        [ [1976,5,1,0,0,0],[1976,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1976,9,30,22,59,59],[1976,10,1,1,59,59],
          '1976050100:00:00','1976050103:00:00','1976093022:59:59','1976100101:59:59' ],
        [ [1976,9,30,23,0,0],[1976,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1977,4,30,23,59,59],[1977,5,1,1,59,59],
          '1976093023:00:00','1976100101:00:00','1977043023:59:59','1977050101:59:59' ],
     ],
   1977 =>
     [
        [ [1977,5,1,0,0,0],[1977,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1977,8,31,22,59,59],[1977,9,1,1,59,59],
          '1977050100:00:00','1977050103:00:00','1977083122:59:59','1977090101:59:59' ],
        [ [1977,8,31,23,0,0],[1977,9,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1978,4,30,23,59,59],[1978,5,1,1,59,59],
          '1977083123:00:00','1977090101:00:00','1978043023:59:59','1978050101:59:59' ],
     ],
   1978 =>
     [
        [ [1978,5,1,0,0,0],[1978,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1978,8,31,22,59,59],[1978,9,1,1,59,59],
          '1978050100:00:00','1978050103:00:00','1978083122:59:59','1978090101:59:59' ],
        [ [1978,8,31,23,0,0],[1978,9,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1983,4,8,23,59,59],[1983,4,9,1,59,59],
          '1978083123:00:00','1978090101:00:00','1983040823:59:59','1983040901:59:59' ],
     ],
   1983 =>
     [
        [ [1983,4,9,0,0,0],[1983,4,9,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1983,9,30,22,59,59],[1983,10,1,1,59,59],
          '1983040900:00:00','1983040903:00:00','1983093022:59:59','1983100101:59:59' ],
        [ [1983,9,30,23,0,0],[1983,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1984,4,8,23,59,59],[1984,4,9,1,59,59],
          '1983093023:00:00','1983100101:00:00','1984040823:59:59','1984040901:59:59' ],
     ],
   1984 =>
     [
        [ [1984,4,9,0,0,0],[1984,4,9,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1984,9,30,22,59,59],[1984,10,1,1,59,59],
          '1984040900:00:00','1984040903:00:00','1984093022:59:59','1984100101:59:59' ],
        [ [1984,9,30,23,0,0],[1984,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1986,2,15,23,59,59],[1986,2,16,1,59,59],
          '1984093023:00:00','1984100101:00:00','1986021523:59:59','1986021601:59:59' ],
     ],
   1986 =>
     [
        [ [1986,2,16,0,0,0],[1986,2,16,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1986,10,8,22,59,59],[1986,10,9,1,59,59],
          '1986021600:00:00','1986021603:00:00','1986100822:59:59','1986100901:59:59' ],
        [ [1986,10,8,23,0,0],[1986,10,9,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1987,2,28,23,59,59],[1987,3,1,1,59,59],
          '1986100823:00:00','1986100901:00:00','1987022823:59:59','1987030101:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,1,0,0,0],[1987,3,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1987,10,30,22,59,59],[1987,10,31,1,59,59],
          '1987030100:00:00','1987030103:00:00','1987103022:59:59','1987103101:59:59' ],
        [ [1987,10,30,23,0,0],[1987,10,31,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1988,3,14,23,59,59],[1988,3,15,1,59,59],
          '1987103023:00:00','1987103101:00:00','1988031423:59:59','1988031501:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,15,0,0,0],[1988,3,15,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1988,10,30,22,59,59],[1988,10,31,1,59,59],
          '1988031500:00:00','1988031503:00:00','1988103022:59:59','1988103101:59:59' ],
        [ [1988,10,30,23,0,0],[1988,10,31,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1989,3,30,23,59,59],[1989,3,31,1,59,59],
          '1988103023:00:00','1988103101:00:00','1989033023:59:59','1989033101:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,31,0,0,0],[1989,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1989,9,30,22,59,59],[1989,10,1,1,59,59],
          '1989033100:00:00','1989033103:00:00','1989093022:59:59','1989100101:59:59' ],
        [ [1989,9,30,23,0,0],[1989,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1990,3,31,23,59,59],[1990,4,1,1,59,59],
          '1989093023:00:00','1989100101:00:00','1990033123:59:59','1990040101:59:59' ],
     ],
   1990 =>
     [
        [ [1990,4,1,0,0,0],[1990,4,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1990,9,29,22,59,59],[1990,9,30,1,59,59],
          '1990040100:00:00','1990040103:00:00','1990092922:59:59','1990093001:59:59' ],
        [ [1990,9,29,23,0,0],[1990,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1991,3,31,21,59,59],[1991,3,31,23,59,59],
          '1990092923:00:00','1990093001:00:00','1991033121:59:59','1991033123:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,31,22,0,0],[1991,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1991,9,30,20,59,59],[1991,9,30,23,59,59],
          '1991033122:00:00','1991040101:00:00','1991093020:59:59','1991093023:59:59' ],
        [ [1991,9,30,21,0,0],[1991,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1992,4,7,21,59,59],[1992,4,7,23,59,59],
          '1991093021:00:00','1991093023:00:00','1992040721:59:59','1992040723:59:59' ],
     ],
   1992 =>
     [
        [ [1992,4,7,22,0,0],[1992,4,8,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1992,9,30,20,59,59],[1992,9,30,23,59,59],
          '1992040722:00:00','1992040801:00:00','1992093020:59:59','1992093023:59:59' ],
        [ [1992,9,30,21,0,0],[1992,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1993,3,25,21,59,59],[1993,3,25,23,59,59],
          '1992093021:00:00','1992093023:00:00','1993032521:59:59','1993032523:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,25,22,0,0],[1993,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1993,9,24,20,59,59],[1993,9,24,23,59,59],
          '1993032522:00:00','1993032601:00:00','1993092420:59:59','1993092423:59:59' ],
        [ [1993,9,24,21,0,0],[1993,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1994,3,31,21,59,59],[1994,3,31,23,59,59],
          '1993092421:00:00','1993092423:00:00','1994033121:59:59','1994033123:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,31,22,0,0],[1994,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1994,9,30,20,59,59],[1994,9,30,23,59,59],
          '1994033122:00:00','1994040101:00:00','1994093020:59:59','1994093023:59:59' ],
        [ [1994,9,30,21,0,0],[1994,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1995,3,31,21,59,59],[1995,3,31,23,59,59],
          '1994093021:00:00','1994093023:00:00','1995033121:59:59','1995033123:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,31,22,0,0],[1995,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1995,9,30,20,59,59],[1995,9,30,23,59,59],
          '1995033122:00:00','1995040101:00:00','1995093020:59:59','1995093023:59:59' ],
        [ [1995,9,30,21,0,0],[1995,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,3,31,21,59,59],[1996,3,31,23,59,59],
          '1995093021:00:00','1995093023:00:00','1996033121:59:59','1996033123:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,31,22,0,0],[1996,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1996,9,30,20,59,59],[1996,9,30,23,59,59],
          '1996033122:00:00','1996040101:00:00','1996093020:59:59','1996093023:59:59' ],
        [ [1996,9,30,21,0,0],[1996,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1997,3,30,21,59,59],[1997,3,30,23,59,59],
          '1996093021:00:00','1996093023:00:00','1997033021:59:59','1997033023:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,30,22,0,0],[1997,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1997,9,30,20,59,59],[1997,9,30,23,59,59],
          '1997033022:00:00','1997033101:00:00','1997093020:59:59','1997093023:59:59' ],
        [ [1997,9,30,21,0,0],[1997,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1998,3,29,21,59,59],[1998,3,29,23,59,59],
          '1997093021:00:00','1997093023:00:00','1998032921:59:59','1998032923:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,29,22,0,0],[1998,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1998,9,30,20,59,59],[1998,9,30,23,59,59],
          '1998032922:00:00','1998033001:00:00','1998093020:59:59','1998093023:59:59' ],
        [ [1998,9,30,21,0,0],[1998,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1999,3,31,21,59,59],[1999,3,31,23,59,59],
          '1998093021:00:00','1998093023:00:00','1999033121:59:59','1999033123:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,31,22,0,0],[1999,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1999,9,30,20,59,59],[1999,9,30,23,59,59],
          '1999033122:00:00','1999040101:00:00','1999093020:59:59','1999093023:59:59' ],
        [ [1999,9,30,21,0,0],[1999,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2000,3,31,21,59,59],[2000,3,31,23,59,59],
          '1999093021:00:00','1999093023:00:00','2000033121:59:59','2000033123:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,31,22,0,0],[2000,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2000,9,30,20,59,59],[2000,9,30,23,59,59],
          '2000033122:00:00','2000040101:00:00','2000093020:59:59','2000093023:59:59' ],
        [ [2000,9,30,21,0,0],[2000,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2001,3,31,21,59,59],[2001,3,31,23,59,59],
          '2000093021:00:00','2000093023:00:00','2001033121:59:59','2001033123:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,31,22,0,0],[2001,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2001,9,30,20,59,59],[2001,9,30,23,59,59],
          '2001033122:00:00','2001040101:00:00','2001093020:59:59','2001093023:59:59' ],
        [ [2001,9,30,21,0,0],[2001,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2002,3,31,21,59,59],[2002,3,31,23,59,59],
          '2001093021:00:00','2001093023:00:00','2002033121:59:59','2002033123:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,31,22,0,0],[2002,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2002,9,30,20,59,59],[2002,9,30,23,59,59],
          '2002033122:00:00','2002040101:00:00','2002093020:59:59','2002093023:59:59' ],
        [ [2002,9,30,21,0,0],[2002,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2003,3,31,21,59,59],[2003,3,31,23,59,59],
          '2002093021:00:00','2002093023:00:00','2003033121:59:59','2003033123:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,31,22,0,0],[2003,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2003,9,30,20,59,59],[2003,9,30,23,59,59],
          '2003033122:00:00','2003040101:00:00','2003093020:59:59','2003093023:59:59' ],
        [ [2003,9,30,21,0,0],[2003,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2004,3,31,21,59,59],[2004,3,31,23,59,59],
          '2003093021:00:00','2003093023:00:00','2004033121:59:59','2004033123:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,31,22,0,0],[2004,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2004,9,30,20,59,59],[2004,9,30,23,59,59],
          '2004033122:00:00','2004040101:00:00','2004093020:59:59','2004093023:59:59' ],
        [ [2004,9,30,21,0,0],[2004,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2005,3,31,21,59,59],[2005,3,31,23,59,59],
          '2004093021:00:00','2004093023:00:00','2005033121:59:59','2005033123:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,31,22,0,0],[2005,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2005,9,30,20,59,59],[2005,9,30,23,59,59],
          '2005033122:00:00','2005040101:00:00','2005093020:59:59','2005093023:59:59' ],
        [ [2005,9,30,21,0,0],[2005,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2006,3,31,21,59,59],[2006,3,31,23,59,59],
          '2005093021:00:00','2005093023:00:00','2006033121:59:59','2006033123:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,31,22,0,0],[2006,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2006,9,21,20,59,59],[2006,9,21,23,59,59],
          '2006033122:00:00','2006040101:00:00','2006092120:59:59','2006092123:59:59' ],
        [ [2006,9,21,21,0,0],[2006,9,21,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2007,3,29,21,59,59],[2007,3,29,23,59,59],
          '2006092121:00:00','2006092123:00:00','2007032921:59:59','2007032923:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,29,22,0,0],[2007,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2007,11,1,20,59,59],[2007,11,1,23,59,59],
          '2007032922:00:00','2007033001:00:00','2007110120:59:59','2007110123:59:59' ],
        [ [2007,11,1,21,0,0],[2007,11,1,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2008,4,3,21,59,59],[2008,4,3,23,59,59],
          '2007110121:00:00','2007110123:00:00','2008040321:59:59','2008040323:59:59' ],
     ],
   2008 =>
     [
        [ [2008,4,3,22,0,0],[2008,4,4,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2008,10,31,20,59,59],[2008,10,31,23,59,59],
          '2008040322:00:00','2008040401:00:00','2008103120:59:59','2008103123:59:59' ],
        [ [2008,10,31,21,0,0],[2008,10,31,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2009,3,26,21,59,59],[2009,3,26,23,59,59],
          '2008103121:00:00','2008103123:00:00','2009032621:59:59','2009032623:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,26,22,0,0],[2009,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2009,10,29,20,59,59],[2009,10,29,23,59,59],
          '2009032622:00:00','2009032701:00:00','2009102920:59:59','2009102923:59:59' ],
        [ [2009,10,29,21,0,0],[2009,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2010,4,1,21,59,59],[2010,4,1,23,59,59],
          '2009102921:00:00','2009102923:00:00','2010040121:59:59','2010040123:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,1,22,0,0],[2010,4,2,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2010,10,28,20,59,59],[2010,10,28,23,59,59],
          '2010040122:00:00','2010040201:00:00','2010102820:59:59','2010102823:59:59' ],
        [ [2010,10,28,21,0,0],[2010,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2011,3,31,21,59,59],[2011,3,31,23,59,59],
          '2010102821:00:00','2010102823:00:00','2011033121:59:59','2011033123:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,31,22,0,0],[2011,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2011,10,27,20,59,59],[2011,10,27,23,59,59],
          '2011033122:00:00','2011040101:00:00','2011102720:59:59','2011102723:59:59' ],
        [ [2011,10,27,21,0,0],[2011,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,3,29,21,59,59],[2012,3,29,23,59,59],
          '2011102721:00:00','2011102723:00:00','2012032921:59:59','2012032923:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,29,22,0,0],[2012,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2012,10,25,20,59,59],[2012,10,25,23,59,59],
          '2012032922:00:00','2012033001:00:00','2012102520:59:59','2012102523:59:59' ],
        [ [2012,10,25,21,0,0],[2012,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2013,3,28,21,59,59],[2013,3,28,23,59,59],
          '2012102521:00:00','2012102523:00:00','2013032821:59:59','2013032823:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,28,22,0,0],[2013,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2013,10,24,20,59,59],[2013,10,24,23,59,59],
          '2013032822:00:00','2013032901:00:00','2013102420:59:59','2013102423:59:59' ],
        [ [2013,10,24,21,0,0],[2013,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2014,3,27,21,59,59],[2014,3,27,23,59,59],
          '2013102421:00:00','2013102423:00:00','2014032721:59:59','2014032723:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,27,22,0,0],[2014,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2014,10,30,20,59,59],[2014,10,30,23,59,59],
          '2014032722:00:00','2014032801:00:00','2014103020:59:59','2014103023:59:59' ],
        [ [2014,10,30,21,0,0],[2014,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2015,3,26,21,59,59],[2015,3,26,23,59,59],
          '2014103021:00:00','2014103023:00:00','2015032621:59:59','2015032623:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,26,22,0,0],[2015,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2015,10,29,20,59,59],[2015,10,29,23,59,59],
          '2015032622:00:00','2015032701:00:00','2015102920:59:59','2015102923:59:59' ],
        [ [2015,10,29,21,0,0],[2015,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2016,3,24,21,59,59],[2016,3,24,23,59,59],
          '2015102921:00:00','2015102923:00:00','2016032421:59:59','2016032423:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,24,22,0,0],[2016,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2016,10,27,20,59,59],[2016,10,27,23,59,59],
          '2016032422:00:00','2016032501:00:00','2016102720:59:59','2016102723:59:59' ],
        [ [2016,10,27,21,0,0],[2016,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2017,3,30,21,59,59],[2017,3,30,23,59,59],
          '2016102721:00:00','2016102723:00:00','2017033021:59:59','2017033023:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,30,22,0,0],[2017,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2017,10,26,20,59,59],[2017,10,26,23,59,59],
          '2017033022:00:00','2017033101:00:00','2017102620:59:59','2017102623:59:59' ],
        [ [2017,10,26,21,0,0],[2017,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2018,3,29,21,59,59],[2018,3,29,23,59,59],
          '2017102621:00:00','2017102623:00:00','2018032921:59:59','2018032923:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,29,22,0,0],[2018,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2018,10,25,20,59,59],[2018,10,25,23,59,59],
          '2018032922:00:00','2018033001:00:00','2018102520:59:59','2018102523:59:59' ],
        [ [2018,10,25,21,0,0],[2018,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2019,3,28,21,59,59],[2019,3,28,23,59,59],
          '2018102521:00:00','2018102523:00:00','2019032821:59:59','2019032823:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,28,22,0,0],[2019,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2019,10,24,20,59,59],[2019,10,24,23,59,59],
          '2019032822:00:00','2019032901:00:00','2019102420:59:59','2019102423:59:59' ],
        [ [2019,10,24,21,0,0],[2019,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2020,3,26,21,59,59],[2020,3,26,23,59,59],
          '2019102421:00:00','2019102423:00:00','2020032621:59:59','2020032623:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,26,22,0,0],[2020,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2020,10,29,20,59,59],[2020,10,29,23,59,59],
          '2020032622:00:00','2020032701:00:00','2020102920:59:59','2020102923:59:59' ],
        [ [2020,10,29,21,0,0],[2020,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2021,3,25,21,59,59],[2021,3,25,23,59,59],
          '2020102921:00:00','2020102923:00:00','2021032521:59:59','2021032523:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,25,22,0,0],[2021,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2021,10,28,20,59,59],[2021,10,28,23,59,59],
          '2021032522:00:00','2021032601:00:00','2021102820:59:59','2021102823:59:59' ],
        [ [2021,10,28,21,0,0],[2021,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2022,3,24,21,59,59],[2022,3,24,23,59,59],
          '2021102821:00:00','2021102823:00:00','2022032421:59:59','2022032423:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,24,22,0,0],[2022,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2022,10,27,20,59,59],[2022,10,27,23,59,59],
          '2022032422:00:00','2022032501:00:00','2022102720:59:59','2022102723:59:59' ],
        [ [2022,10,27,21,0,0],[2022,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2023,3,30,21,59,59],[2023,3,30,23,59,59],
          '2022102721:00:00','2022102723:00:00','2023033021:59:59','2023033023:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,30,22,0,0],[2023,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2023,10,26,20,59,59],[2023,10,26,23,59,59],
          '2023033022:00:00','2023033101:00:00','2023102620:59:59','2023102623:59:59' ],
        [ [2023,10,26,21,0,0],[2023,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2024,3,28,21,59,59],[2024,3,28,23,59,59],
          '2023102621:00:00','2023102623:00:00','2024032821:59:59','2024032823:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,28,22,0,0],[2024,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2024,10,24,20,59,59],[2024,10,24,23,59,59],
          '2024032822:00:00','2024032901:00:00','2024102420:59:59','2024102423:59:59' ],
        [ [2024,10,24,21,0,0],[2024,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2025,3,27,21,59,59],[2025,3,27,23,59,59],
          '2024102421:00:00','2024102423:00:00','2025032721:59:59','2025032723:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,27,22,0,0],[2025,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2025,10,30,20,59,59],[2025,10,30,23,59,59],
          '2025032722:00:00','2025032801:00:00','2025103020:59:59','2025103023:59:59' ],
        [ [2025,10,30,21,0,0],[2025,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2026,3,26,21,59,59],[2026,3,26,23,59,59],
          '2025103021:00:00','2025103023:00:00','2026032621:59:59','2026032623:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,26,22,0,0],[2026,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2026,10,29,20,59,59],[2026,10,29,23,59,59],
          '2026032622:00:00','2026032701:00:00','2026102920:59:59','2026102923:59:59' ],
        [ [2026,10,29,21,0,0],[2026,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2027,3,25,21,59,59],[2027,3,25,23,59,59],
          '2026102921:00:00','2026102923:00:00','2027032521:59:59','2027032523:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,25,22,0,0],[2027,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2027,10,28,20,59,59],[2027,10,28,23,59,59],
          '2027032522:00:00','2027032601:00:00','2027102820:59:59','2027102823:59:59' ],
        [ [2027,10,28,21,0,0],[2027,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2028,3,30,21,59,59],[2028,3,30,23,59,59],
          '2027102821:00:00','2027102823:00:00','2028033021:59:59','2028033023:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,30,22,0,0],[2028,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2028,10,26,20,59,59],[2028,10,26,23,59,59],
          '2028033022:00:00','2028033101:00:00','2028102620:59:59','2028102623:59:59' ],
        [ [2028,10,26,21,0,0],[2028,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2029,3,29,21,59,59],[2029,3,29,23,59,59],
          '2028102621:00:00','2028102623:00:00','2029032921:59:59','2029032923:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,29,22,0,0],[2029,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2029,10,25,20,59,59],[2029,10,25,23,59,59],
          '2029032922:00:00','2029033001:00:00','2029102520:59:59','2029102523:59:59' ],
        [ [2029,10,25,21,0,0],[2029,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2030,3,28,21,59,59],[2030,3,28,23,59,59],
          '2029102521:00:00','2029102523:00:00','2030032821:59:59','2030032823:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,28,22,0,0],[2030,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2030,10,24,20,59,59],[2030,10,24,23,59,59],
          '2030032822:00:00','2030032901:00:00','2030102420:59:59','2030102423:59:59' ],
        [ [2030,10,24,21,0,0],[2030,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2031,3,27,21,59,59],[2031,3,27,23,59,59],
          '2030102421:00:00','2030102423:00:00','2031032721:59:59','2031032723:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,27,22,0,0],[2031,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2031,10,30,20,59,59],[2031,10,30,23,59,59],
          '2031032722:00:00','2031032801:00:00','2031103020:59:59','2031103023:59:59' ],
        [ [2031,10,30,21,0,0],[2031,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2032,3,25,21,59,59],[2032,3,25,23,59,59],
          '2031103021:00:00','2031103023:00:00','2032032521:59:59','2032032523:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,25,22,0,0],[2032,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2032,10,28,20,59,59],[2032,10,28,23,59,59],
          '2032032522:00:00','2032032601:00:00','2032102820:59:59','2032102823:59:59' ],
        [ [2032,10,28,21,0,0],[2032,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2033,3,24,21,59,59],[2033,3,24,23,59,59],
          '2032102821:00:00','2032102823:00:00','2033032421:59:59','2033032423:59:59' ],
     ],
   2033 =>
     [
        [ [2033,3,24,22,0,0],[2033,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2033,10,27,20,59,59],[2033,10,27,23,59,59],
          '2033032422:00:00','2033032501:00:00','2033102720:59:59','2033102723:59:59' ],
        [ [2033,10,27,21,0,0],[2033,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2034,3,30,21,59,59],[2034,3,30,23,59,59],
          '2033102721:00:00','2033102723:00:00','2034033021:59:59','2034033023:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,30,22,0,0],[2034,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2034,10,26,20,59,59],[2034,10,26,23,59,59],
          '2034033022:00:00','2034033101:00:00','2034102620:59:59','2034102623:59:59' ],
        [ [2034,10,26,21,0,0],[2034,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2035,3,29,21,59,59],[2035,3,29,23,59,59],
          '2034102621:00:00','2034102623:00:00','2035032921:59:59','2035032923:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,29,22,0,0],[2035,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2035,10,25,20,59,59],[2035,10,25,23,59,59],
          '2035032922:00:00','2035033001:00:00','2035102520:59:59','2035102523:59:59' ],
        [ [2035,10,25,21,0,0],[2035,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2036,3,27,21,59,59],[2036,3,27,23,59,59],
          '2035102521:00:00','2035102523:00:00','2036032721:59:59','2036032723:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,27,22,0,0],[2036,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2036,10,30,20,59,59],[2036,10,30,23,59,59],
          '2036032722:00:00','2036032801:00:00','2036103020:59:59','2036103023:59:59' ],
        [ [2036,10,30,21,0,0],[2036,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2037,3,26,21,59,59],[2037,3,26,23,59,59],
          '2036103021:00:00','2036103023:00:00','2037032621:59:59','2037032623:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,26,22,0,0],[2037,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2037,10,29,20,59,59],[2037,10,29,23,59,59],
          '2037032622:00:00','2037032701:00:00','2037102920:59:59','2037102923:59:59' ],
        [ [2037,10,29,21,0,0],[2037,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2038,3,25,21,59,59],[2038,3,25,23,59,59],
          '2037102921:00:00','2037102923:00:00','2038032521:59:59','2038032523:59:59' ],
     ],
   2038 =>
     [
        [ [2038,3,25,22,0,0],[2038,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2038,10,28,20,59,59],[2038,10,28,23,59,59],
          '2038032522:00:00','2038032601:00:00','2038102820:59:59','2038102823:59:59' ],
        [ [2038,10,28,21,0,0],[2038,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2039,3,24,21,59,59],[2039,3,24,23,59,59],
          '2038102821:00:00','2038102823:00:00','2039032421:59:59','2039032423:59:59' ],
     ],
   2039 =>
     [
        [ [2039,3,24,22,0,0],[2039,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2039,10,27,20,59,59],[2039,10,27,23,59,59],
          '2039032422:00:00','2039032501:00:00','2039102720:59:59','2039102723:59:59' ],
        [ [2039,10,27,21,0,0],[2039,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2040,3,29,21,59,59],[2040,3,29,23,59,59],
          '2039102721:00:00','2039102723:00:00','2040032921:59:59','2040032923:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,29,22,0,0],[2040,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2040,10,25,20,59,59],[2040,10,25,23,59,59],
          '2040032922:00:00','2040033001:00:00','2040102520:59:59','2040102523:59:59' ],
        [ [2040,10,25,21,0,0],[2040,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2041,3,28,21,59,59],[2041,3,28,23,59,59],
          '2040102521:00:00','2040102523:00:00','2041032821:59:59','2041032823:59:59' ],
     ],
   2041 =>
     [
        [ [2041,3,28,22,0,0],[2041,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2041,10,24,20,59,59],[2041,10,24,23,59,59],
          '2041032822:00:00','2041032901:00:00','2041102420:59:59','2041102423:59:59' ],
        [ [2041,10,24,21,0,0],[2041,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2042,3,27,21,59,59],[2042,3,27,23,59,59],
          '2041102421:00:00','2041102423:00:00','2042032721:59:59','2042032723:59:59' ],
     ],
   2042 =>
     [
        [ [2042,3,27,22,0,0],[2042,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2042,10,30,20,59,59],[2042,10,30,23,59,59],
          '2042032722:00:00','2042032801:00:00','2042103020:59:59','2042103023:59:59' ],
        [ [2042,10,30,21,0,0],[2042,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2043,3,26,21,59,59],[2043,3,26,23,59,59],
          '2042103021:00:00','2042103023:00:00','2043032621:59:59','2043032623:59:59' ],
     ],
   2043 =>
     [
        [ [2043,3,26,22,0,0],[2043,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2043,10,29,20,59,59],[2043,10,29,23,59,59],
          '2043032622:00:00','2043032701:00:00','2043102920:59:59','2043102923:59:59' ],
        [ [2043,10,29,21,0,0],[2043,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2044,3,24,21,59,59],[2044,3,24,23,59,59],
          '2043102921:00:00','2043102923:00:00','2044032421:59:59','2044032423:59:59' ],
     ],
   2044 =>
     [
        [ [2044,3,24,22,0,0],[2044,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2044,10,27,20,59,59],[2044,10,27,23,59,59],
          '2044032422:00:00','2044032501:00:00','2044102720:59:59','2044102723:59:59' ],
        [ [2044,10,27,21,0,0],[2044,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2045,3,30,21,59,59],[2045,3,30,23,59,59],
          '2044102721:00:00','2044102723:00:00','2045033021:59:59','2045033023:59:59' ],
     ],
   2045 =>
     [
        [ [2045,3,30,22,0,0],[2045,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2045,10,26,20,59,59],[2045,10,26,23,59,59],
          '2045033022:00:00','2045033101:00:00','2045102620:59:59','2045102623:59:59' ],
        [ [2045,10,26,21,0,0],[2045,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2046,3,29,21,59,59],[2046,3,29,23,59,59],
          '2045102621:00:00','2045102623:00:00','2046032921:59:59','2046032923:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,29,22,0,0],[2046,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2046,10,25,20,59,59],[2046,10,25,23,59,59],
          '2046032922:00:00','2046033001:00:00','2046102520:59:59','2046102523:59:59' ],
        [ [2046,10,25,21,0,0],[2046,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2047,3,28,21,59,59],[2047,3,28,23,59,59],
          '2046102521:00:00','2046102523:00:00','2047032821:59:59','2047032823:59:59' ],
     ],
   2047 =>
     [
        [ [2047,3,28,22,0,0],[2047,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2047,10,24,20,59,59],[2047,10,24,23,59,59],
          '2047032822:00:00','2047032901:00:00','2047102420:59:59','2047102423:59:59' ],
        [ [2047,10,24,21,0,0],[2047,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2048,3,26,21,59,59],[2048,3,26,23,59,59],
          '2047102421:00:00','2047102423:00:00','2048032621:59:59','2048032623:59:59' ],
     ],
   2048 =>
     [
        [ [2048,3,26,22,0,0],[2048,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2048,10,29,20,59,59],[2048,10,29,23,59,59],
          '2048032622:00:00','2048032701:00:00','2048102920:59:59','2048102923:59:59' ],
        [ [2048,10,29,21,0,0],[2048,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2049,3,25,21,59,59],[2049,3,25,23,59,59],
          '2048102921:00:00','2048102923:00:00','2049032521:59:59','2049032523:59:59' ],
     ],
   2049 =>
     [
        [ [2049,3,25,22,0,0],[2049,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2049,10,28,20,59,59],[2049,10,28,23,59,59],
          '2049032522:00:00','2049032601:00:00','2049102820:59:59','2049102823:59:59' ],
        [ [2049,10,28,21,0,0],[2049,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2050,3,24,21,59,59],[2050,3,24,23,59,59],
          '2049102821:00:00','2049102823:00:00','2050032421:59:59','2050032423:59:59' ],
     ],
   2050 =>
     [
        [ [2050,3,24,22,0,0],[2050,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2050,10,27,20,59,59],[2050,10,27,23,59,59],
          '2050032422:00:00','2050032501:00:00','2050102720:59:59','2050102723:59:59' ],
        [ [2050,10,27,21,0,0],[2050,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2051,3,30,21,59,59],[2051,3,30,23,59,59],
          '2050102721:00:00','2050102723:00:00','2051033021:59:59','2051033023:59:59' ],
     ],
   2051 =>
     [
        [ [2051,3,30,22,0,0],[2051,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2051,10,26,20,59,59],[2051,10,26,23,59,59],
          '2051033022:00:00','2051033101:00:00','2051102620:59:59','2051102623:59:59' ],
        [ [2051,10,26,21,0,0],[2051,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2052,3,28,21,59,59],[2052,3,28,23,59,59],
          '2051102621:00:00','2051102623:00:00','2052032821:59:59','2052032823:59:59' ],
     ],
   2052 =>
     [
        [ [2052,3,28,22,0,0],[2052,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2052,10,24,20,59,59],[2052,10,24,23,59,59],
          '2052032822:00:00','2052032901:00:00','2052102420:59:59','2052102423:59:59' ],
        [ [2052,10,24,21,0,0],[2052,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2053,3,27,21,59,59],[2053,3,27,23,59,59],
          '2052102421:00:00','2052102423:00:00','2053032721:59:59','2053032723:59:59' ],
     ],
   2053 =>
     [
        [ [2053,3,27,22,0,0],[2053,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2053,10,30,20,59,59],[2053,10,30,23,59,59],
          '2053032722:00:00','2053032801:00:00','2053103020:59:59','2053103023:59:59' ],
        [ [2053,10,30,21,0,0],[2053,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2054,3,26,21,59,59],[2054,3,26,23,59,59],
          '2053103021:00:00','2053103023:00:00','2054032621:59:59','2054032623:59:59' ],
     ],
   2054 =>
     [
        [ [2054,3,26,22,0,0],[2054,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2054,10,29,20,59,59],[2054,10,29,23,59,59],
          '2054032622:00:00','2054032701:00:00','2054102920:59:59','2054102923:59:59' ],
        [ [2054,10,29,21,0,0],[2054,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2055,3,25,21,59,59],[2055,3,25,23,59,59],
          '2054102921:00:00','2054102923:00:00','2055032521:59:59','2055032523:59:59' ],
     ],
   2055 =>
     [
        [ [2055,3,25,22,0,0],[2055,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2055,10,28,20,59,59],[2055,10,28,23,59,59],
          '2055032522:00:00','2055032601:00:00','2055102820:59:59','2055102823:59:59' ],
        [ [2055,10,28,21,0,0],[2055,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2056,3,30,21,59,59],[2056,3,30,23,59,59],
          '2055102821:00:00','2055102823:00:00','2056033021:59:59','2056033023:59:59' ],
     ],
   2056 =>
     [
        [ [2056,3,30,22,0,0],[2056,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2056,10,26,20,59,59],[2056,10,26,23,59,59],
          '2056033022:00:00','2056033101:00:00','2056102620:59:59','2056102623:59:59' ],
        [ [2056,10,26,21,0,0],[2056,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2057,3,29,21,59,59],[2057,3,29,23,59,59],
          '2056102621:00:00','2056102623:00:00','2057032921:59:59','2057032923:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,29,22,0,0],[2057,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2057,10,25,20,59,59],[2057,10,25,23,59,59],
          '2057032922:00:00','2057033001:00:00','2057102520:59:59','2057102523:59:59' ],
        [ [2057,10,25,21,0,0],[2057,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2058,3,28,21,59,59],[2058,3,28,23,59,59],
          '2057102521:00:00','2057102523:00:00','2058032821:59:59','2058032823:59:59' ],
     ],
   2058 =>
     [
        [ [2058,3,28,22,0,0],[2058,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2058,10,24,20,59,59],[2058,10,24,23,59,59],
          '2058032822:00:00','2058032901:00:00','2058102420:59:59','2058102423:59:59' ],
        [ [2058,10,24,21,0,0],[2058,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2059,3,27,21,59,59],[2059,3,27,23,59,59],
          '2058102421:00:00','2058102423:00:00','2059032721:59:59','2059032723:59:59' ],
     ],
   2059 =>
     [
        [ [2059,3,27,22,0,0],[2059,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2059,10,30,20,59,59],[2059,10,30,23,59,59],
          '2059032722:00:00','2059032801:00:00','2059103020:59:59','2059103023:59:59' ],
        [ [2059,10,30,21,0,0],[2059,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2060,3,25,21,59,59],[2060,3,25,23,59,59],
          '2059103021:00:00','2059103023:00:00','2060032521:59:59','2060032523:59:59' ],
     ],
   2060 =>
     [
        [ [2060,3,25,22,0,0],[2060,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2060,10,28,20,59,59],[2060,10,28,23,59,59],
          '2060032522:00:00','2060032601:00:00','2060102820:59:59','2060102823:59:59' ],
        [ [2060,10,28,21,0,0],[2060,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2061,3,24,21,59,59],[2061,3,24,23,59,59],
          '2060102821:00:00','2060102823:00:00','2061032421:59:59','2061032423:59:59' ],
     ],
   2061 =>
     [
        [ [2061,3,24,22,0,0],[2061,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2061,10,27,20,59,59],[2061,10,27,23,59,59],
          '2061032422:00:00','2061032501:00:00','2061102720:59:59','2061102723:59:59' ],
        [ [2061,10,27,21,0,0],[2061,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2062,3,30,21,59,59],[2062,3,30,23,59,59],
          '2061102721:00:00','2061102723:00:00','2062033021:59:59','2062033023:59:59' ],
     ],
   2062 =>
     [
        [ [2062,3,30,22,0,0],[2062,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2062,10,26,20,59,59],[2062,10,26,23,59,59],
          '2062033022:00:00','2062033101:00:00','2062102620:59:59','2062102623:59:59' ],
        [ [2062,10,26,21,0,0],[2062,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2063,3,29,21,59,59],[2063,3,29,23,59,59],
          '2062102621:00:00','2062102623:00:00','2063032921:59:59','2063032923:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,29,22,0,0],[2063,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2063,10,25,20,59,59],[2063,10,25,23,59,59],
          '2063032922:00:00','2063033001:00:00','2063102520:59:59','2063102523:59:59' ],
        [ [2063,10,25,21,0,0],[2063,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2064,3,27,21,59,59],[2064,3,27,23,59,59],
          '2063102521:00:00','2063102523:00:00','2064032721:59:59','2064032723:59:59' ],
     ],
   2064 =>
     [
        [ [2064,3,27,22,0,0],[2064,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2064,10,30,20,59,59],[2064,10,30,23,59,59],
          '2064032722:00:00','2064032801:00:00','2064103020:59:59','2064103023:59:59' ],
        [ [2064,10,30,21,0,0],[2064,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2065,3,26,21,59,59],[2065,3,26,23,59,59],
          '2064103021:00:00','2064103023:00:00','2065032621:59:59','2065032623:59:59' ],
     ],
   2065 =>
     [
        [ [2065,3,26,22,0,0],[2065,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2065,10,29,20,59,59],[2065,10,29,23,59,59],
          '2065032622:00:00','2065032701:00:00','2065102920:59:59','2065102923:59:59' ],
        [ [2065,10,29,21,0,0],[2065,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2066,3,25,21,59,59],[2066,3,25,23,59,59],
          '2065102921:00:00','2065102923:00:00','2066032521:59:59','2066032523:59:59' ],
     ],
   2066 =>
     [
        [ [2066,3,25,22,0,0],[2066,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2066,10,28,20,59,59],[2066,10,28,23,59,59],
          '2066032522:00:00','2066032601:00:00','2066102820:59:59','2066102823:59:59' ],
        [ [2066,10,28,21,0,0],[2066,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2067,3,24,21,59,59],[2067,3,24,23,59,59],
          '2066102821:00:00','2066102823:00:00','2067032421:59:59','2067032423:59:59' ],
     ],
   2067 =>
     [
        [ [2067,3,24,22,0,0],[2067,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2067,10,27,20,59,59],[2067,10,27,23,59,59],
          '2067032422:00:00','2067032501:00:00','2067102720:59:59','2067102723:59:59' ],
        [ [2067,10,27,21,0,0],[2067,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2068,3,29,21,59,59],[2068,3,29,23,59,59],
          '2067102721:00:00','2067102723:00:00','2068032921:59:59','2068032923:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,29,22,0,0],[2068,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2068,10,25,20,59,59],[2068,10,25,23,59,59],
          '2068032922:00:00','2068033001:00:00','2068102520:59:59','2068102523:59:59' ],
        [ [2068,10,25,21,0,0],[2068,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2069,3,28,21,59,59],[2069,3,28,23,59,59],
          '2068102521:00:00','2068102523:00:00','2069032821:59:59','2069032823:59:59' ],
     ],
   2069 =>
     [
        [ [2069,3,28,22,0,0],[2069,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2069,10,24,20,59,59],[2069,10,24,23,59,59],
          '2069032822:00:00','2069032901:00:00','2069102420:59:59','2069102423:59:59' ],
        [ [2069,10,24,21,0,0],[2069,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2070,3,27,21,59,59],[2070,3,27,23,59,59],
          '2069102421:00:00','2069102423:00:00','2070032721:59:59','2070032723:59:59' ],
     ],
   2070 =>
     [
        [ [2070,3,27,22,0,0],[2070,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2070,10,30,20,59,59],[2070,10,30,23,59,59],
          '2070032722:00:00','2070032801:00:00','2070103020:59:59','2070103023:59:59' ],
        [ [2070,10,30,21,0,0],[2070,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2071,3,26,21,59,59],[2071,3,26,23,59,59],
          '2070103021:00:00','2070103023:00:00','2071032621:59:59','2071032623:59:59' ],
     ],
   2071 =>
     [
        [ [2071,3,26,22,0,0],[2071,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2071,10,29,20,59,59],[2071,10,29,23,59,59],
          '2071032622:00:00','2071032701:00:00','2071102920:59:59','2071102923:59:59' ],
        [ [2071,10,29,21,0,0],[2071,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2072,3,24,21,59,59],[2072,3,24,23,59,59],
          '2071102921:00:00','2071102923:00:00','2072032421:59:59','2072032423:59:59' ],
     ],
   2072 =>
     [
        [ [2072,3,24,22,0,0],[2072,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2072,10,27,20,59,59],[2072,10,27,23,59,59],
          '2072032422:00:00','2072032501:00:00','2072102720:59:59','2072102723:59:59' ],
        [ [2072,10,27,21,0,0],[2072,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2073,3,30,21,59,59],[2073,3,30,23,59,59],
          '2072102721:00:00','2072102723:00:00','2073033021:59:59','2073033023:59:59' ],
     ],
   2073 =>
     [
        [ [2073,3,30,22,0,0],[2073,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2073,10,26,20,59,59],[2073,10,26,23,59,59],
          '2073033022:00:00','2073033101:00:00','2073102620:59:59','2073102623:59:59' ],
        [ [2073,10,26,21,0,0],[2073,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2074,3,29,21,59,59],[2074,3,29,23,59,59],
          '2073102621:00:00','2073102623:00:00','2074032921:59:59','2074032923:59:59' ],
     ],
   2074 =>
     [
        [ [2074,3,29,22,0,0],[2074,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2074,10,25,20,59,59],[2074,10,25,23,59,59],
          '2074032922:00:00','2074033001:00:00','2074102520:59:59','2074102523:59:59' ],
        [ [2074,10,25,21,0,0],[2074,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2075,3,28,21,59,59],[2075,3,28,23,59,59],
          '2074102521:00:00','2074102523:00:00','2075032821:59:59','2075032823:59:59' ],
     ],
   2075 =>
     [
        [ [2075,3,28,22,0,0],[2075,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2075,10,24,20,59,59],[2075,10,24,23,59,59],
          '2075032822:00:00','2075032901:00:00','2075102420:59:59','2075102423:59:59' ],
        [ [2075,10,24,21,0,0],[2075,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2076,3,26,21,59,59],[2076,3,26,23,59,59],
          '2075102421:00:00','2075102423:00:00','2076032621:59:59','2076032623:59:59' ],
     ],
   2076 =>
     [
        [ [2076,3,26,22,0,0],[2076,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2076,10,29,20,59,59],[2076,10,29,23,59,59],
          '2076032622:00:00','2076032701:00:00','2076102920:59:59','2076102923:59:59' ],
        [ [2076,10,29,21,0,0],[2076,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2077,3,25,21,59,59],[2077,3,25,23,59,59],
          '2076102921:00:00','2076102923:00:00','2077032521:59:59','2077032523:59:59' ],
     ],
   2077 =>
     [
        [ [2077,3,25,22,0,0],[2077,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2077,10,28,20,59,59],[2077,10,28,23,59,59],
          '2077032522:00:00','2077032601:00:00','2077102820:59:59','2077102823:59:59' ],
        [ [2077,10,28,21,0,0],[2077,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2078,3,24,21,59,59],[2078,3,24,23,59,59],
          '2077102821:00:00','2077102823:00:00','2078032421:59:59','2078032423:59:59' ],
     ],
   2078 =>
     [
        [ [2078,3,24,22,0,0],[2078,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2078,10,27,20,59,59],[2078,10,27,23,59,59],
          '2078032422:00:00','2078032501:00:00','2078102720:59:59','2078102723:59:59' ],
        [ [2078,10,27,21,0,0],[2078,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2079,3,30,21,59,59],[2079,3,30,23,59,59],
          '2078102721:00:00','2078102723:00:00','2079033021:59:59','2079033023:59:59' ],
     ],
   2079 =>
     [
        [ [2079,3,30,22,0,0],[2079,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2079,10,26,20,59,59],[2079,10,26,23,59,59],
          '2079033022:00:00','2079033101:00:00','2079102620:59:59','2079102623:59:59' ],
        [ [2079,10,26,21,0,0],[2079,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2080,3,28,21,59,59],[2080,3,28,23,59,59],
          '2079102621:00:00','2079102623:00:00','2080032821:59:59','2080032823:59:59' ],
     ],
   2080 =>
     [
        [ [2080,3,28,22,0,0],[2080,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2080,10,24,20,59,59],[2080,10,24,23,59,59],
          '2080032822:00:00','2080032901:00:00','2080102420:59:59','2080102423:59:59' ],
        [ [2080,10,24,21,0,0],[2080,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2081,3,27,21,59,59],[2081,3,27,23,59,59],
          '2080102421:00:00','2080102423:00:00','2081032721:59:59','2081032723:59:59' ],
     ],
   2081 =>
     [
        [ [2081,3,27,22,0,0],[2081,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2081,10,30,20,59,59],[2081,10,30,23,59,59],
          '2081032722:00:00','2081032801:00:00','2081103020:59:59','2081103023:59:59' ],
        [ [2081,10,30,21,0,0],[2081,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2082,3,26,21,59,59],[2082,3,26,23,59,59],
          '2081103021:00:00','2081103023:00:00','2082032621:59:59','2082032623:59:59' ],
     ],
   2082 =>
     [
        [ [2082,3,26,22,0,0],[2082,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2082,10,29,20,59,59],[2082,10,29,23,59,59],
          '2082032622:00:00','2082032701:00:00','2082102920:59:59','2082102923:59:59' ],
        [ [2082,10,29,21,0,0],[2082,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2083,3,25,21,59,59],[2083,3,25,23,59,59],
          '2082102921:00:00','2082102923:00:00','2083032521:59:59','2083032523:59:59' ],
     ],
   2083 =>
     [
        [ [2083,3,25,22,0,0],[2083,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2083,10,28,20,59,59],[2083,10,28,23,59,59],
          '2083032522:00:00','2083032601:00:00','2083102820:59:59','2083102823:59:59' ],
        [ [2083,10,28,21,0,0],[2083,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2084,3,30,21,59,59],[2084,3,30,23,59,59],
          '2083102821:00:00','2083102823:00:00','2084033021:59:59','2084033023:59:59' ],
     ],
   2084 =>
     [
        [ [2084,3,30,22,0,0],[2084,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2084,10,26,20,59,59],[2084,10,26,23,59,59],
          '2084033022:00:00','2084033101:00:00','2084102620:59:59','2084102623:59:59' ],
        [ [2084,10,26,21,0,0],[2084,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2085,3,29,21,59,59],[2085,3,29,23,59,59],
          '2084102621:00:00','2084102623:00:00','2085032921:59:59','2085032923:59:59' ],
     ],
   2085 =>
     [
        [ [2085,3,29,22,0,0],[2085,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2085,10,25,20,59,59],[2085,10,25,23,59,59],
          '2085032922:00:00','2085033001:00:00','2085102520:59:59','2085102523:59:59' ],
        [ [2085,10,25,21,0,0],[2085,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2086,3,28,21,59,59],[2086,3,28,23,59,59],
          '2085102521:00:00','2085102523:00:00','2086032821:59:59','2086032823:59:59' ],
     ],
   2086 =>
     [
        [ [2086,3,28,22,0,0],[2086,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2086,10,24,20,59,59],[2086,10,24,23,59,59],
          '2086032822:00:00','2086032901:00:00','2086102420:59:59','2086102423:59:59' ],
        [ [2086,10,24,21,0,0],[2086,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2087,3,27,21,59,59],[2087,3,27,23,59,59],
          '2086102421:00:00','2086102423:00:00','2087032721:59:59','2087032723:59:59' ],
     ],
   2087 =>
     [
        [ [2087,3,27,22,0,0],[2087,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2087,10,30,20,59,59],[2087,10,30,23,59,59],
          '2087032722:00:00','2087032801:00:00','2087103020:59:59','2087103023:59:59' ],
        [ [2087,10,30,21,0,0],[2087,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2088,3,25,21,59,59],[2088,3,25,23,59,59],
          '2087103021:00:00','2087103023:00:00','2088032521:59:59','2088032523:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+03:00:00',
                'stdoff' => '+02:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'EEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'EET',
                        },
               },
);

1;
