/* Simple data structure that handles pipes
 * Ben Lynn
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef PIPE_H
#define PIPE_H

struct pipe_s {
    int is_open;
    char *name;
    int readfd;
    int writefd;
};
typedef struct pipe_s pipe_t[1];

void pipe_init(pipe_t p);
void pipe_free(pipe_t p);
void pipe_open(pipe_t p);
void pipe_close(pipe_t p);
void pipe_readflush(pipe_t p);
void pipe_assign(pipe_t p, char *);
int pipe_write(pipe_t p, char *s);

#endif //PIPE_H
