/* Demo application that uses pipes
 * Fades current song, then goes to next one
 * Ben Lynn
 */
/*
Copyright (C) 2002 Jeremy Schaeffer <jeremy@datye.zzn.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static FILE *in, *out;

static void send_command(char *s)
{
    fprintf(out, "%s\n", s);
    //using buffered I/O is okay as long as we tell it when it must send
    fflush(out);
}

int main()
{
    char *homedir;
    char *outpipe;
    char *inpipe;

    int vl, vr;
    char buf[100];
    struct timeval tv0, tv1;
    long delay = 2000000;

    printf(
"This demo program uses XMMSPipe to fade the currently playing song and\n"
"advance to the next one.\n\n"
"If XMMS is playing a song now, and XMMSPipe is enabled, then this should\n"
"happen now.\n"
	    );

    homedir = getenv("HOME");
    outpipe = malloc(strlen(homedir) + 128);
    inpipe = malloc(strlen(homedir) + 128);

    strcpy(outpipe, homedir);
    strcat(outpipe, "/.xmms/outpipe");

    strcpy(inpipe, homedir);
    strcat(inpipe, "/.xmms/inpipe");

    out = fopen(inpipe, "w");
    if (!out) {
	fprintf(stderr, "Error: can't open input pipe '%s'\n", inpipe);
	return 1;
    }

    send_command("out on");

    //flush outpipe just in case there is some stale output on it
    send_command("out flush");

    in = fopen(outpipe,"r");
    if (!in) {
	fprintf(stderr, "Error: can't open output pipe '%s'\n", outpipe);
	return 1;
    }

    send_command("report volume");

    fscanf(in, "%d %d", &vl, &vr);

    gettimeofday(&tv0, NULL);
    for (;;) {
	long diff;
	usleep(32);
	gettimeofday(&tv1, NULL);
	diff = (tv1.tv_sec - tv0.tv_sec) * 1000000 + (tv1.tv_usec - tv0.tv_usec);
	if (diff > delay) break;
	sprintf(buf, "volume %d %d",  vl - (int) (diff * vl / delay),
		vr - (int) (diff * vr / delay));
	send_command(buf);
    }
    send_command("next");
    sprintf(buf, "volume %d %d", vl, vr);
    send_command(buf);

    fclose(in);
    fclose(out);

    return 0;
}
