/*
 *	support.c - support functions
 *	Copyright (C) 2000 Fred Barnes <frmb2@ukc.ac.uk>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include "error.h"

/*
 *	void *xmalloc (int size)
 *	allocates some memory
 */
void *xmalloc (int size)
{
	void *ptr;

	ptr = malloc (size);
	if (!ptr) {
		ERR_MSG ("out of memory.");
		exit (EXIT_FAILURE);
	}
	return ptr;
}


/*
 *	void *xrealloc (void *ptr, int old_size, int new_size)
 *	Safely reallocates a block of memory
 */
void *xrealloc (void *ptr, int old_size, int new_size)
{
	void *tmp;

	tmp = xmalloc (new_size);
	if (ptr && old_size) {
		if (new_size < old_size) {
			memmove (tmp, ptr, new_size);
		} else {
			memmove (tmp, ptr, old_size);
			memset (tmp + old_size, 0, (new_size - old_size));
		}
	} else {
		memset (tmp, 0, new_size);
	}
	return tmp;
}


/*
 *	char *string_dup (char *str)
 *	Duplicates `str'
 */
char *string_dup (char *str)
{
	char *ptr;

	ptr = (char *)xmalloc (strlen(str) + 1);
	strcpy (ptr, str);
	return ptr;
}


/*
 *	char *string_cat (char *str, char *text)
 *	Appends to a string (frees original)
 */
char *string_cat (char *str, char *text)
{
	char *ptr;

	ptr = (char *)xmalloc (strlen(str) + strlen(text) + 1);
	strcpy (ptr, str);
	strcat (ptr, text);
	free (str);
	return ptr;
}


