#include <qvalidator.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qspinbox.h>
#include <qwidget.h>
#include <qfile.h>
#include <qdir.h>
#include <stdlib.h>
#include "config.h"
#include "lanbase.h"
#include "lan.h"

static QString shellQuote(const QString& s)
{
    QString r="\"";
    for (int i=0; i<(int)s.length(); i++) {
	char c = s[i].latin1();
	switch (c) {
	    case '\\': case '"': case '$':
		r+="\\";
	}
	r += s[i];
    }
    r += "\"";
    return r;
}

class WepKeyValidator : public QValidator {
public:
    WepKeyValidator(QWidget* parent) :
	QValidator(parent)
    {
    }

    State validate( QString& key, int& curs ) const
    {
	QString k;
	int hexes=0;
	int ncurs=0;
	for (int i=0; i<(int)key.length(); i++) {
	    char c=key[i].lower().latin1();
	    if ( c>='0' && c<='9' || c>='a' && c<='z' ) {
		if ( hexes == 2 ) {
		    hexes = 0;
		    k += ':';
		    if ( i<curs ) ncurs++;
		}
		k += c;
		hexes++;
		if ( i<curs ) ncurs++;
	    } else if ( c == ':' && hexes==2 ) {
		hexes = 0;
		k += c;
		if ( i<curs ) ncurs++;
	    }
	}
	key = k;
	curs = ncurs;
	return Acceptable;
    }

    //void fixup( QString& key ) const
    //{
    //}
};

Lan::Lan(QWidget *parent, const char *name):
    LanBase(parent, name)
{
    connect( apply_button, SIGNAL(released()), this, SLOT(Apply()) );
    ipGroup = new QButtonGroup( this );
    ipGroup->hide();
    ipGroup->insert( manualIP );
    ipGroup->insert( autoIP );
    connect( ipGroup, SIGNAL(clicked(int)), this, SLOT(ipSelect(int)) );
    ipGroup->setButton( 1 );

    tabs->setTabEnabled( wireless, false );
    bt_macaddr->setEnabled(false);
    bt_search->setEnabled(false);

//    config = new Config("Network-LAN");
//    readConfig(config);

    QString dir = QString(getenv("HOME")) + QString("/Choices/common/");
    QDir d(dir);

    acname->clear();

    bool found = false;

    d.setFilter( QDir::Files );
    d.setNameFilter("Network-LAN-*.conf");
    for (unsigned int i = 0; i < d.count(); i++) {
	if (d[i] != "Network-LAN-.conf") {
	    Config cfg(dir + d[i], Config::File);
	    cfg.setGroup("Info");
	    addConfig(cfg.readEntry("Name"));
	    found = true;
	}
    }

    if (found) {
	Config *config = new Config("Network-LAN-" + acname->currentText());
	readConfig(config);
	delete config;
    }
}

Lan::~Lan()
{
//    delete config;
}

void Lan::removeConfig(QString n)
{
    for (int i = 0; i < acname->count(); i++) {
	if (n == acname->text(i)) {
	    acname->removeItem(i);
	}
    }
}

void Lan::addConfig(QString n)
{
    removeConfig(n);
    acname->insertItem(n);
    acname->setCurrentItem(acname->count()-1);
}

void Lan::cable_selected()
{
    tabs->setTabEnabled( wireless, false );
    bt_macaddr->setEnabled(false);
    bt_search->setEnabled(false);
}

void Lan::wifi_selected()
{
    tabs->setTabEnabled( wireless, true );
    bt_macaddr->setEnabled(false);
    bt_search->setEnabled(false);
}

void Lan::bt_selected()
{
    tabs->setTabEnabled( wireless, false );
    bt_macaddr->setEnabled(true);
    bt_search->setEnabled(true);
}

void Lan::ipSelect( int id )
{
    tabs->setTabEnabled( tcpip, id==0 );
}

void Lan::new_wifi_mode(int i)
{
    if (i == 1) wifi_channel->setEnabled(true);
    else wifi_channel->setEnabled(false);
}

void Lan::Apply()
{
//    qDebug("apply!");
    Config *config = new Config("Network-LAN-" + acname->currentText());
    writeConfig(config);

    QString confname = "";
//    if (wifi_button->isChecked()) confname="qpelan";
//    else 
    confname="qpelan";

    if (!writePcmciaNetworkOpts(config, confname)) {
	QMessageBox::information(NULL, "LAN", "Error during config file creating!", QMessageBox::Ok);
    }
    delete config;
    addConfig(acname->currentText());
}

void Lan::remove_account()
{
    QString file = QString(getenv("HOME")) + "/Choices/common/Network-LAN-" + acname->currentText()  + ".conf";
    QFile f(file);
    if (f.exists()) f.remove();
    removeConfig(acname->currentText());
}

void Lan::new_account(const QString &str)
{
    QString file = QString(getenv("HOME")) + "/Choices/common/Network-LAN-" + str  + ".conf";
    QFile f(file);
    if (f.exists()) {
	config = new Config("Network-LAN-" + str);
	readConfig(config);
	delete config;
    }
    addConfig(str);
}

bool Lan::writeNetworkOpts( Config *config, QString scheme )
{
    return writePcmciaNetworkOpts(config, scheme);
}

bool Lan::writePcmciaNetworkOpts( Config *config, QString scheme )
{
    QString prev = "/etc/pcmcia/network.opts";
//    QString prev = "network.opts";
    QFile prevFile(prev);
    if ( !prevFile.open( IO_ReadOnly ) )
	return FALSE;

    QString tmp = prev + "-qpe-new";
    QFile tmpFile(tmp);
    if ( !tmpFile.open( IO_WriteOnly ) )
	return FALSE;

    bool retval = TRUE;
    
    QTextStream in( &prevFile );
    QTextStream out( &tmpFile );

    config->setGroup("Info");
    QString nm = config->readEntry( "Name" );
    
    config->setGroup("Properties");

    //For DHCP to work, we have to remove the TCP/IP fields
    bool dhcp = config->readEntry("DHCP","y") != "n";
    
    QString line;
    while ( !in.atEnd() ) {
	QString line = in.readLine();
	QString wline = line.simplifyWhiteSpace();
	if ( wline.right(7) == ",*,*,*)" ) {
	    // end - add new entry
	    // Not all fields have a GUI, but all are supported
	    // in the network configuration files.
	    static const char* txtfields[] = {
		"IF_PORT", "DHCP_HOSTNAME", "NETWORK",
		"DOMAIN", "SEARCH", "MOUNTS",
		"MTU", "NO_CHECK", "NO_FUSER",
		"IPADDR", "NETMASK", "BROADCAST", "GATEWAY",
		"DNS_1", "DNS_2", "DNS_3", 0
	    };
	    out << "*,*,*,*)" << "\n"
		<< "    INFO=" << shellQuote(nm) << "\n"
		<< "    BOOTP=" << config->readEntry("BOOTP","n") << "\n"
		<< "    DHCP=" << config->readEntry("DHCP","y") << "\n"
		<< "    start_fn () " << config->readEntry("start_fn","{ return; }") << "\n"
		<< "    stop_fn () " << config->readEntry("stop_fn","{ return; }") << "\n"
		;
	    const char** f = txtfields;
	    while (*f) {
		out << "    " << *f << "=" 
		    << shellQuote(dhcp ? QString("") : config->readEntry(*f,""))
		    << "\n";
		++f;
	    }
	    out << "    ;;\n";
	    out << "esac\n";
	    break;
	}
	out << line << "\n";
    }

    prevFile.close();
    tmpFile.close();


    QString prev2 = "/etc/pcmcia/wireless.opts";
//    QString prev2 = "wlan-ng.opts";
    prevFile.setName(prev2);
    if ( !prevFile.open( IO_ReadOnly ) )
	return FALSE;

    QString tmp2 = prev2 + "-qpe-new";
    tmpFile.setName(tmp2);
    if ( !tmpFile.open( IO_WriteOnly ) )
	return FALSE;

    QTextStream win( &prevFile );
    QTextStream wout( &tmpFile );

    while ( !win.atEnd() ) {
	QString line = win.readLine();
	QString wline = line.simplifyWhiteSpace();
	if ( wline.right(7) == ",*,*,*)" ) {
	    // end - add new entry
	    // Not all fields have a GUI, but all are supported
	    // in the wlan configuration files.
	    static const char* txtfields[] = {
		"ESSID", "MODE", "CHANNEL", "KEY",
		"NWID", "SENS", "RATE", "RTS", "IWCONFIG",
		"IWSPY", "IWPRIV",
		0
	    };
	    wout << "*,*,*,*)" << "\n";
	    wout << "    INFO=" << shellQuote(nm) << "\n";
	    const char** f = txtfields;
	    while (*f) {
		wout << "    " << *f << "=" 
		     << shellQuote(config->readEntry(*f,""))
		     << "\n";
		++f;
	    }
	    wout << "    ;;\n";
	    wout << "esac\n";
	    wout << "fi\n";
	    break;
	}
	wout << line << "\n";
    }

    prevFile.close();
    tmpFile.close();


    system("cardctl eject");

    if ( system( "mv " + tmp + " " + prev ) )
	retval = FALSE;
    if ( system( "mv " + tmp2 + " " + prev2 ) )
	retval = FALSE;

    system("cardctl insert");

    return retval;
}

void Lan::readConfig(Config *config)
{
    int id = config->readEntry("DHCP","y") != "n";
    ipGroup->setButton( id );
    ipSelect( id );

    config->setGroup("Info");
    addConfig(config->readEntry("Name","LAN"));

    cable_button->setChecked(config->readBoolEntry("cable"));
    wifi_button->setChecked(config->readBoolEntry("wifi"));
    bt_button->setChecked(config->readBoolEntry("bt_pan"));

    if (cable_button->isChecked()) cable_selected();
    if (wifi_button->isChecked()) wifi_selected();
    if (bt_button->isChecked()) bt_selected();

    config->setGroup("Properties");
    ip->setText( config->readEntry("IPADDR") );
    subnet->setText( config->readEntry("NETMASK","255.255.255.0") );
    broadcast->setText( config->readEntry("BROADCAST","") );
    gateway->setText( config->readEntry("GATEWAY") );
    dns1->setText( config->readEntry("DNS_1") );
    dns2->setText( config->readEntry("DNS_2") );

    wifi_essid->setText(config->readEntry("ESSID"));
    int mode = config->readNumEntry("MODE_N");
    box_wifi_mode->setCurrentItem(mode);
    if (mode == 1) {
	wifi_channel->setText(config->readEntry("CHANNEL"));
	wifi_channel->setEnabled(true);
    } else {
	wifi_channel->setEnabled(false);
    }
    wifi_key->setText(config->readEntry("KEY"));

//    config->setGroup("Proxy");
//    proxies->readConfig( config );
}

bool Lan::writeConfig(Config *config)
{
    QString nm = acname->currentText();

#ifdef USE_SCHEMES    
    QString scheme;
#endif
    {
	config->setGroup("Info");
	config->writeEntry("Name",nm);
#ifdef USE_SCHEMES    
	scheme = toSchemeId(nm);
	if ( scheme.isEmpty() )
	    scheme = "*"; // The default config
#endif    
	config->writeEntry("cable",cable_button->isChecked());
	config->writeEntry("wifi",wifi_button->isChecked());
	config->writeEntry("bt_pan",bt_button->isChecked());

	config->setGroup("Properties");

	config->writeEntry("DHCP",autoIP->isChecked() ? "y" : "n");
	config->writeEntry("IPADDR",ip->text());
	config->writeEntry("NETMASK",subnet->text());
	config->writeEntry("BROADCAST",broadcast->text());
	config->writeEntry("GATEWAY",gateway->text());
	config->writeEntry("DNS_1",dns1->text());
	config->writeEntry("DNS_2",dns2->text());

	if (wifi_button->isChecked())
	    config->writeEntry("WLAN_ENABLE","y");
	else
	    config->writeEntry("WLAN_ENABLE","n");
	
	config->writeEntry("ESSID",   wifi_essid->text());
	config->writeEntry("MODE_N",    box_wifi_mode->currentItem());
	config->writeEntry("MODE",    box_wifi_mode->currentText());
	if (box_wifi_mode->currentItem() == 1) 
	    config->writeEntry("CHANNEL", wifi_channel->text());
	else
	    config->writeEntry("CHANNEL", "");
	config->writeEntry("KEY",     wifi_key->text());

//	config->setGroup("Proxy");
//	proxies->writeConfig( config );
    }

#ifdef USE_SCHEMES    
    return writeNetworkOpts( config, scheme );
#else
    return TRUE;
#endif    
}
