/*
   Device info utility for Sharp Zaurus SL-C7x0/860 and SL-5600
   version 1.0
   Copyright 2004 Alexander Chukov <sash@pdaXrom.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 */

#define CONFIG_MTD_NAND_LOGICAL_ADDRESS_ACCESS

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>

#include <asm/types.h>
#include <linux/mtd/mtd.h>

static int open_mtd(void)
{
	int fd;
	mtd_info_t meminfo;

	/* Open the device */
	if((fd = open("/dev/mtd1", O_RDWR)) == -1) {
	    if((fd = open("/dev/mtd/1", O_RDWR)) == -1) {
		perror("open flash");
		exit(1);
	    }
	}

	/* Fill in MTD device capability structure */  
	if(ioctl(fd, MEMGETINFO, &meminfo) != 0) {
		perror("MEMGETINFO");
		close(fd);
		exit(1);
	}

	/* Make sure device page sizes are valid */
	if( !(meminfo.oobsize == 16 && meminfo.oobblock == 512) &&
		!(meminfo.oobsize == 8 && meminfo.oobblock == 256) ) {
		printf("Unknown flash (not normal NAND)\n");
		close(fd);
		exit(1);
	}

	return fd;
}

static void read_mtd(int mfd, loff_t offset, size_t len, void *buf)
{
	struct read_laddr_info_user rinfo;
	
	rinfo.from = offset;
	rinfo.len = len;
	rinfo.buf = (u_char *) buf;
	if (ioctl(mfd, MEMREADLADDR, &rinfo) != 0) {
		perror("ioctl(MEMREADLADDR)");
		close(mfd);
		exit(1);
	}
}

static void write_mtd(int mfd, loff_t offset, size_t len, void *buf)
{
	struct write_laddr_info_user winfo;
	
	winfo.to = offset;
	winfo.len = len;
	winfo.buf = (u_char *) buf;
	if (ioctl(mfd, MEMWRITELADDR, &winfo) != 0) {
		perror("ioctl(MEMWRITELADDR)");
		close(mfd);
		exit(1);
	}
}

static void write_devinfo(char *name, char *str)
{
    char file[128];
    FILE *f;
    strcpy(file, "/proc/deviceinfo/");
    strcat(file, name);
    f = fopen(file,"wb");
    if (!f) {
	fprintf(stderr, "can't open deviceinfo file!\n");
	exit(1);
    }
    fprintf(f, str);
    fclose(f);
}

int main(int argc, char *argv[])
{
	int mfd;
	char buf[32];

	mfd = open_mtd();

	read_mtd(mfd, 0x68030, 8, buf);
	write_devinfo("product", buf);

	memset(buf, 0, 32);
	read_mtd(mfd, 0x68000, 16, buf);
	write_devinfo("vendor", buf);
	
	close(mfd);
	return 0;
}
